/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.virtual.VirtualizedColumnInspector;

public class VirtualizedColumnSelectorFactory
extends VirtualizedColumnInspector
implements ColumnSelectorFactory {
    private final ColumnSelectorFactory baseFactory;

    public VirtualizedColumnSelectorFactory(ColumnSelectorFactory baseFactory, VirtualColumns virtualColumns) {
        super(baseFactory, virtualColumns);
        this.baseFactory = (ColumnSelectorFactory)Preconditions.checkNotNull((Object)baseFactory, (Object)"baseFactory");
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this.baseFactory);
        }
        return this.baseFactory.makeDimensionSelector(dimensionSpec);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this.baseFactory);
        }
        return this.baseFactory.makeColumnValueSelector(columnName);
    }
}

