/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.druid.query.metadata.metadata.ListColumnIncluderator;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryConfig;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanQueryQueryToolChest;
import org.apache.druid.query.scan.ScanQueryRunnerFactory;
import org.apache.druid.query.scan.ScanQueryRunnerTest;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DoubleStorageTest {
    private static final SegmentMetadataQueryRunnerFactory METADATA_QR_FACTORY = new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    private static final ScanQueryQueryToolChest SCAN_QUERY_QUERY_TOOL_CHEST = new ScanQueryQueryToolChest(new ScanQueryConfig(), DefaultGenericQueryMetricsFactory.instance());
    private static final ScanQueryRunnerFactory SCAN_QUERY_RUNNER_FACTORY = new ScanQueryRunnerFactory(SCAN_QUERY_QUERY_TOOL_CHEST, new ScanQueryEngine(), new ScanQueryConfig());
    private static final IndexMergerV9 INDEX_MERGER_V9 = TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
    private static final IndexIO INDEX_IO = TestHelper.getTestIndexIO();
    private static final Integer MAX_ROWS = 10;
    private static final String TIME_COLUMN = "__time";
    private static final String DIM_NAME = "testDimName";
    private static final String DIM_VALUE = "testDimValue";
    private static final String DIM_FLOAT_NAME = "testDimFloatName";
    private static final SegmentId SEGMENT_ID = SegmentId.dummy((String)"segmentId");
    private static final Interval INTERVAL = Intervals.of((String)"2011-01-13T00:00:00.000Z/2011-01-22T00:00:00.001Z");
    private static final InputRowParser<Map<String, Object>> ROW_PARSER = new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("__time", "auto", null), DimensionsSpec.builder().setDimensions(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"testDimName"))).setDimensionExclusions((List)ImmutableList.of((Object)"testDimFloatName")).build(), null, null, null));
    private QueryableIndex index;
    private final SegmentAnalysis expectedSegmentAnalysis;
    private final String storeDoubleAs;

    private Druids.ScanQueryBuilder newTestQuery() {
        return Druids.newScanQueryBuilder().dataSource((DataSource)new TableDataSource("testing")).columns(Collections.emptyList()).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).limit(Integer.MAX_VALUE).legacy(Boolean.valueOf(false));
    }

    public DoubleStorageTest(String storeDoubleAs, SegmentAnalysis expectedSegmentAnalysis) {
        this.storeDoubleAs = storeDoubleAs;
        this.expectedSegmentAnalysis = expectedSegmentAnalysis;
    }

    @Parameterized.Parameters
    public static Collection<?> dataFeeder() {
        SegmentAnalysis expectedSegmentAnalysisDouble = new SegmentAnalysis(SEGMENT_ID.toString(), (List)ImmutableList.of((Object)INTERVAL), (Map)ImmutableMap.of((Object)TIME_COLUMN, (Object)new ColumnAnalysis(ColumnType.LONG, ValueType.LONG.name(), false, false, 100L, null, null, null, null), (Object)DIM_NAME, (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.name(), false, false, 120L, Integer.valueOf(1), (Comparable)((Object)DIM_VALUE), (Comparable)((Object)DIM_VALUE), null), (Object)DIM_FLOAT_NAME, (Object)new ColumnAnalysis(ColumnType.DOUBLE, ValueType.DOUBLE.name(), false, false, 80L, null, null, null, null)), 330L, (long)MAX_ROWS.intValue(), null, null, null, null);
        SegmentAnalysis expectedSegmentAnalysisFloat = new SegmentAnalysis(SEGMENT_ID.toString(), (List)ImmutableList.of((Object)INTERVAL), (Map)ImmutableMap.of((Object)TIME_COLUMN, (Object)new ColumnAnalysis(ColumnType.LONG, ValueType.LONG.name(), false, false, 100L, null, null, null, null), (Object)DIM_NAME, (Object)new ColumnAnalysis(ColumnType.STRING, ValueType.STRING.name(), false, false, 120L, Integer.valueOf(1), (Comparable)((Object)DIM_VALUE), (Comparable)((Object)DIM_VALUE), null), (Object)DIM_FLOAT_NAME, (Object)new ColumnAnalysis(ColumnType.FLOAT, ValueType.FLOAT.name(), false, false, 80L, null, null, null, null)), 330L, (long)MAX_ROWS.intValue(), null, null, null, null);
        return ImmutableList.of((Object)new Object[]{"double", expectedSegmentAnalysisDouble}, (Object)new Object[]{"float", expectedSegmentAnalysisFloat});
    }

    @Before
    public void setup() throws IOException {
        this.index = DoubleStorageTest.buildIndex(this.storeDoubleAs);
    }

    @Test
    public void testMetaDataAnalysis() {
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(METADATA_QR_FACTORY, SEGMENT_ID, (Segment)new QueryableIndexSegment(this.index, SEGMENT_ID), null);
        SegmentMetadataQuery segmentMetadataQuery = Druids.newSegmentMetadataQueryBuilder().dataSource("testing").intervals((List)ImmutableList.of((Object)INTERVAL)).toInclude((ColumnIncluderator)new ListColumnIncluderator(Arrays.asList(TIME_COLUMN, DIM_NAME, DIM_FLOAT_NAME))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.SIZE, SegmentMetadataQuery.AnalysisType.INTERVAL, SegmentMetadataQuery.AnalysisType.MINMAX}).merge(true).build();
        List results = runner.run(QueryPlus.wrap((Query)segmentMetadataQuery)).toList();
        Assert.assertEquals(Collections.singletonList(this.expectedSegmentAnalysis), (Object)results);
    }

    @Test
    public void testSelectValues() {
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(SCAN_QUERY_RUNNER_FACTORY, SEGMENT_ID, (Segment)new QueryableIndexSegment(this.index, SEGMENT_ID), null);
        ScanQuery query = this.newTestQuery().intervals((QuerySegmentSpec)new LegacySegmentSpec((Object)INTERVAL)).virtualColumns(new VirtualColumn[0]).build();
        List results = runner.run(QueryPlus.wrap((Query)query)).toList();
        ScanResultValue expectedScanResult = new ScanResultValue(SEGMENT_ID.toString(), (List)ImmutableList.of((Object)TIME_COLUMN, (Object)DIM_NAME, (Object)DIM_FLOAT_NAME), DoubleStorageTest.getStreamOfEvents().collect(Collectors.toList()));
        List<ScanResultValue> expectedResults = Collections.singletonList(expectedScanResult);
        ScanQueryRunnerTest.verify(expectedResults, results);
    }

    private static QueryableIndex buildIndex(String storeDoubleAsFloat) throws IOException {
        String oldValue = System.getProperty("druid.indexing.doubleStorage");
        System.setProperty("druid.indexing.doubleStorage", storeDoubleAsFloat);
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-13T00:00:00.000Z").getMillis()).withDimensionsSpec(ROW_PARSER).withMetrics(new AggregatorFactory[]{new DoubleSumAggregatorFactory(DIM_FLOAT_NAME, DIM_FLOAT_NAME)}).build();
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(MAX_ROWS.intValue()).build();
        DoubleStorageTest.getStreamOfEvents().forEach(o -> {
            try {
                index.add((InputRow)ROW_PARSER.parseBatch((Object)((Map)o)).get(0));
            }
            catch (IndexSizeExceededException e) {
                throw new RuntimeException(e);
            }
        });
        if (oldValue == null) {
            System.clearProperty("druid.indexing.doubleStorage");
        } else {
            System.setProperty("druid.indexing.doubleStorage", oldValue);
        }
        File someTmpFile = File.createTempFile("billy", "yay");
        someTmpFile.delete();
        FileUtils.mkdirp((File)someTmpFile);
        INDEX_MERGER_V9.persist(index, someTmpFile, new IndexSpec(), null);
        someTmpFile.delete();
        return INDEX_IO.loadIndex(someTmpFile);
    }

    @After
    public void cleanUp() {
        this.index.close();
    }

    private static Stream getStreamOfEvents() {
        return IntStream.range(0, MAX_ROWS).mapToObj(i -> ImmutableMap.of((Object)TIME_COLUMN, (Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z").plusDays(i).getMillis(), (Object)DIM_NAME, (Object)DIM_VALUE, (Object)DIM_FLOAT_NAME, (Object)((double)i / 1.6179775280898876)));
    }
}

