/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.ExecutorServiceMonitor;
import org.apache.druid.query.MetricsEmittingQueryProcessingPool;
import org.apache.druid.query.PrioritizedExecutorService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MetricsEmittingQueryProcessingPoolTest {
    @Test
    public void testPrioritizedExecutorDelegate() {
        PrioritizedExecutorService service = (PrioritizedExecutorService)Mockito.mock(PrioritizedExecutorService.class);
        Mockito.when((Object)service.getQueueSize()).thenReturn((Object)10);
        ExecutorServiceMonitor monitor = new ExecutorServiceMonitor();
        final ArrayList events = new ArrayList();
        MetricsEmittingQueryProcessingPool processingPool = new MetricsEmittingQueryProcessingPool((ListeningExecutorService)service, monitor);
        Assert.assertSame((Object)service, (Object)processingPool.delegate());
        ServiceEmitter serviceEmitter = new ServiceEmitter("service", "host", (Emitter)Mockito.mock(Emitter.class)){

            public void emit(Event event) {
                events.add(event);
            }
        };
        monitor.doMonitor(serviceEmitter);
        Assert.assertEquals((long)1L, (long)events.size());
        Assert.assertEquals((Object)((ServiceMetricEvent)events.get(0)).getMetric(), (Object)"segment/scan/pending");
        Assert.assertEquals((Object)((ServiceMetricEvent)events.get(0)).getValue(), (Object)10);
    }

    @Test
    public void testNonPrioritizedExecutorDelegate() {
        ListeningExecutorService service = (ListeningExecutorService)Mockito.mock(ListeningExecutorService.class);
        ExecutorServiceMonitor monitor = new ExecutorServiceMonitor();
        MetricsEmittingQueryProcessingPool processingPool = new MetricsEmittingQueryProcessingPool(service, monitor);
        Assert.assertSame((Object)service, (Object)processingPool.delegate());
        ServiceEmitter serviceEmitter = (ServiceEmitter)Mockito.mock(ServiceEmitter.class);
        monitor.doMonitor(serviceEmitter);
        Mockito.verifyNoInteractions((Object[])new Object[]{serviceEmitter});
    }
}

