/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class QueryContextTest {
    @Test
    public void testEquals() {
        EqualsVerifier.configure().suppress(new Warning[]{Warning.NONFINAL_FIELDS, Warning.ALL_FIELDS_SHOULD_BE_USED}).usingGetClass().forClass(QueryContext.class).withNonnullFields(new String[]{"defaultParams", "userParams", "systemParams"}).verify();
    }

    @Test
    public void testEmptyParam() {
        QueryContext context = new QueryContext();
        Assert.assertEquals((Object)ImmutableMap.of(), (Object)context.getMergedParams());
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)new QueryContext().isEmpty());
        Assert.assertFalse((boolean)new QueryContext((Map)ImmutableMap.of((Object)"k", (Object)"v")).isEmpty());
        QueryContext context = new QueryContext();
        context.addDefaultParam("k", (Object)"v");
        Assert.assertFalse((boolean)context.isEmpty());
        context = new QueryContext();
        context.addSystemParam("k", (Object)"v");
        Assert.assertFalse((boolean)context.isEmpty());
    }

    @Test
    public void testGetString() {
        QueryContext context = new QueryContext((Map)ImmutableMap.of((Object)"key", (Object)"val"));
        Assert.assertEquals((Object)"val", (Object)context.get("key"));
        Assert.assertEquals((Object)"val", (Object)context.getAsString("key"));
        Assert.assertNull((Object)context.getAsString("non-exist"));
    }

    @Test
    public void testGetBoolean() {
        QueryContext context = new QueryContext((Map)ImmutableMap.of((Object)"key1", (Object)"true", (Object)"key2", (Object)true));
        Assert.assertTrue((boolean)context.getAsBoolean("key1", false));
        Assert.assertTrue((boolean)context.getAsBoolean("key2", false));
        Assert.assertFalse((boolean)context.getAsBoolean("non-exist", false));
    }

    @Test
    public void testGetInt() {
        QueryContext context = new QueryContext((Map)ImmutableMap.of((Object)"key1", (Object)"100", (Object)"key2", (Object)100));
        Assert.assertEquals((long)100L, (long)context.getAsInt("key1", 0));
        Assert.assertEquals((long)100L, (long)context.getAsInt("key2", 0));
        Assert.assertEquals((long)0L, (long)context.getAsInt("non-exist", 0));
    }

    @Test
    public void testGetLong() {
        QueryContext context = new QueryContext((Map)ImmutableMap.of((Object)"key1", (Object)"100", (Object)"key2", (Object)100));
        Assert.assertEquals((long)100L, (long)context.getAsLong("key1", 0L));
        Assert.assertEquals((long)100L, (long)context.getAsLong("key2", 0L));
        Assert.assertEquals((long)0L, (long)context.getAsLong("non-exist", 0L));
    }

    @Test
    public void testAddSystemParamOverrideUserParam() {
        QueryContext context = new QueryContext((Map)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"conflict", (Object)"userVal2"));
        context.addSystemParam("sys1", (Object)"sysVal1");
        context.addSystemParam("conflict", (Object)"sysVal2");
        Assert.assertEquals((Object)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"conflict", (Object)"userVal2"), (Object)context.getUserParams());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"sys1", (Object)"sysVal1", (Object)"conflict", (Object)"sysVal2"), (Object)context.getMergedParams());
    }

    @Test
    public void testUserParamOverrideDefaultParam() {
        QueryContext context = new QueryContext((Map)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"conflict", (Object)"userVal2"));
        context.addDefaultParams((Map)ImmutableMap.of((Object)"default1", (Object)"defaultVal1"));
        context.addDefaultParam("conflict", (Object)"defaultVal2");
        Assert.assertEquals((Object)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"conflict", (Object)"userVal2"), (Object)context.getUserParams());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"default1", (Object)"defaultVal1", (Object)"conflict", (Object)"userVal2"), (Object)context.getMergedParams());
    }

    @Test
    public void testRemoveUserParam() {
        QueryContext context = new QueryContext((Map)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"conflict", (Object)"userVal2"));
        context.addDefaultParams((Map)ImmutableMap.of((Object)"default1", (Object)"defaultVal1", (Object)"conflict", (Object)"defaultVal2"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"default1", (Object)"defaultVal1", (Object)"conflict", (Object)"userVal2"), (Object)context.getMergedParams());
        Assert.assertEquals((Object)"userVal2", (Object)context.removeUserParam("conflict"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"default1", (Object)"defaultVal1", (Object)"conflict", (Object)"defaultVal2"), (Object)context.getMergedParams());
    }

    @Test
    public void testGetMergedParams() {
        QueryContext context = new QueryContext((Map)ImmutableMap.of((Object)"user1", (Object)"userVal1", (Object)"conflict", (Object)"userVal2"));
        context.addDefaultParams((Map)ImmutableMap.of((Object)"default1", (Object)"defaultVal1", (Object)"conflict", (Object)"defaultVal2"));
        Assert.assertSame((Object)context.getMergedParams(), (Object)context.getMergedParams());
    }

    @Test
    public void testLegacyReturnsLegacy() {
        LegacyContextQuery legacy = new LegacyContextQuery((Map<String, Object>)ImmutableMap.of((Object)"foo", (Object)"bar"));
        Assert.assertNull((Object)legacy.getQueryContext());
    }

    @Test
    public void testNonLegacyIsNotLegacyContext() {
        TimeseriesQuery timeseries = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals("2015-01-02/2015-01-03").granularity(Granularities.DAY).aggregators(Collections.singletonList(new CountAggregatorFactory("theCount"))).context((Map)ImmutableMap.of((Object)"foo", (Object)"bar")).build();
        Assert.assertNotNull((Object)timeseries.getQueryContext());
    }

    public static class LegacyContextQuery
    implements Query {
        private final Map<String, Object> context;

        public LegacyContextQuery(Map<String, Object> context) {
            this.context = context;
        }

        public DataSource getDataSource() {
            return new TableDataSource("fake");
        }

        public boolean hasFilters() {
            return false;
        }

        public DimFilter getFilter() {
            return null;
        }

        public String getType() {
            return "legacy-context-query";
        }

        public QueryRunner getRunner(QuerySegmentWalker walker) {
            return new NoopQueryRunner();
        }

        public List<Interval> getIntervals() {
            return Collections.singletonList(Intervals.ETERNITY);
        }

        public Duration getDuration() {
            return this.getIntervals().get(0).toDuration();
        }

        public Granularity getGranularity() {
            return Granularities.ALL;
        }

        public DateTimeZone getTimezone() {
            return DateTimeZone.UTC;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public boolean getContextBoolean(String key, boolean defaultValue) {
            if (this.context == null || !this.context.containsKey(key)) {
                return defaultValue;
            }
            return (Boolean)this.context.get(key);
        }

        public boolean isDescending() {
            return false;
        }

        public Ordering getResultOrdering() {
            return Ordering.natural();
        }

        public Query withQuerySegmentSpec(QuerySegmentSpec spec) {
            return new LegacyContextQuery(this.context);
        }

        public Query withId(String id) {
            this.context.put("queryId", id);
            return this;
        }

        @Nullable
        public String getId() {
            return (String)this.context.get("queryId");
        }

        public Query withSubQueryId(String subQueryId) {
            this.context.put("subQueryId", subQueryId);
            return this;
        }

        @Nullable
        public String getSubQueryId() {
            return (String)this.context.get("subQueryId");
        }

        public Query withDataSource(DataSource dataSource) {
            return this;
        }

        public Query withOverriddenContext(Map contextOverride) {
            return new LegacyContextQuery(contextOverride);
        }

        public Object getContextValue(String key, Object defaultValue) {
            if (!this.context.containsKey(key)) {
                return defaultValue;
            }
            return this.context.get(key);
        }

        public Object getContextValue(String key) {
            return this.context.get(key);
        }
    }
}

