/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.TestQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QueryContextsTest {
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testDefaultQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, new HashMap());
        Assert.assertEquals((long)300000L, (long)QueryContexts.getDefaultTimeout((Query)query));
    }

    @Test
    public void testEmptyQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, new HashMap());
        Assert.assertEquals((long)300000L, (long)QueryContexts.getTimeout((Query)query));
        query = QueryContexts.withDefaultTimeout((Query)query, (long)60000L);
        Assert.assertEquals((long)60000L, (long)QueryContexts.getTimeout((Query)query));
    }

    @Test
    public void testQueryTimeout() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"timeout", (Object)1000));
        Assert.assertEquals((long)1000L, (long)QueryContexts.getTimeout((Query)query));
        query = QueryContexts.withDefaultTimeout((Query)query, (long)1000000L);
        Assert.assertEquals((long)1000L, (long)QueryContexts.getTimeout((Query)query));
    }

    @Test
    public void testQueryMaxTimeout() {
        this.exception.expect(IAE.class);
        this.exception.expectMessage("configured [timeout = 1000] is more than enforced limit of maxQueryTimeout [100].");
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"timeout", (Object)1000));
        QueryContexts.verifyMaxQueryTimeout((Query)query, (long)100L);
    }

    @Test
    public void testMaxScatterGatherBytes() {
        this.exception.expect(IAE.class);
        this.exception.expectMessage("configured [maxScatterGatherBytes = 1000] is more than enforced limit of [100].");
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"maxScatterGatherBytes", (Object)1000));
        QueryContexts.withMaxScatterGatherBytes((Query)query, (long)100L);
    }

    @Test
    public void testDisableSegmentPruning() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"secondaryPartitionPruning", (Object)false));
        Assert.assertFalse((boolean)QueryContexts.isSecondaryPartitionPruningEnabled((Query)query));
    }

    @Test
    public void testDefaultSegmentPruning() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of());
        Assert.assertTrue((boolean)QueryContexts.isSecondaryPartitionPruningEnabled((Query)query));
    }

    @Test
    public void testDefaultInSubQueryThreshold() {
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)QueryContexts.getInSubQueryThreshold((Map)ImmutableMap.of()));
    }

    @Test
    public void testGetEnableJoinLeftScanDirect() {
        Assert.assertFalse((boolean)QueryContexts.getEnableJoinLeftScanDirect((Map)ImmutableMap.of()));
        Assert.assertTrue((boolean)QueryContexts.getEnableJoinLeftScanDirect((Map)ImmutableMap.of((Object)"enableJoinLeftTableScanDirect", (Object)true)));
        Assert.assertFalse((boolean)QueryContexts.getEnableJoinLeftScanDirect((Map)ImmutableMap.of((Object)"enableJoinLeftTableScanDirect", (Object)false)));
    }

    @Test
    public void testGetBrokerServiceName() {
        HashMap<String, String> queryContext = new HashMap<String, String>();
        Assert.assertNull((Object)QueryContexts.getBrokerServiceName(queryContext));
        queryContext.put("brokerService", "hotBroker");
        Assert.assertEquals((Object)"hotBroker", (Object)QueryContexts.getBrokerServiceName(queryContext));
    }

    @Test
    public void testGetBrokerServiceName_withNonStringValue() {
        HashMap<String, Integer> queryContext = new HashMap<String, Integer>();
        queryContext.put("brokerService", 100);
        this.exception.expect(ClassCastException.class);
        QueryContexts.getBrokerServiceName(queryContext);
    }

    @Test
    public void testDefaultEnableQueryDebugging() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of());
        Assert.assertFalse((boolean)QueryContexts.isDebug((Query)query));
        Assert.assertFalse((boolean)QueryContexts.isDebug((Map)query.getContext()));
    }

    @Test
    public void testEnableQueryDebuggingSetToTrue() {
        TestQuery query = new TestQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"0/100"))), false, (Map)ImmutableMap.of((Object)"debug", (Object)true));
        Assert.assertTrue((boolean)QueryContexts.isDebug((Query)query));
        Assert.assertTrue((boolean)QueryContexts.isDebug((Map)query.getContext()));
    }
}

