/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.druid.query.aggregation.cardinality.CardinalityBufferAggregator;
import org.apache.druid.query.aggregation.cardinality.types.CardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.types.StringCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ExtractionDimensionSpec;
import org.apache.druid.query.dimension.RegexFilteredDimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.junit.Assert;
import org.junit.Test;

public class CardinalityAggregatorTest {
    private static final List<String[]> VALUES1 = CardinalityAggregatorTest.dimensionValues("a", "b", "c", "a", "a", null, "b", "b", "b", "b", "a", "a");
    private static final List<String[]> VALUES2 = CardinalityAggregatorTest.dimensionValues("a", "b", "c", "x", "a", "e", "b", new String[]{null, "x"}, new String[]{"x", null}, new String[]{"y", "x"}, new String[]{"x", "y"}, new String[]{"x", "y", "a"});
    List<ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>> dimInfoList;
    List<DimensionSelector> selectorList;
    CardinalityAggregatorFactory rowAggregatorFactory;
    CardinalityAggregatorFactory rowAggregatorFactoryRounded;
    CardinalityAggregatorFactory valueAggregatorFactory;
    final TestDimensionSelector dim1;
    final TestDimensionSelector dim2;
    List<ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>> dimInfoListWithExtraction;
    List<DimensionSelector> selectorListWithExtraction;
    final TestDimensionSelector dim1WithExtraction;
    final TestDimensionSelector dim2WithExtraction;
    List<ColumnSelectorPlus<CardinalityAggregatorColumnSelectorStrategy>> dimInfoListConstantVal;
    List<DimensionSelector> selectorListConstantVal;
    final TestDimensionSelector dim1ConstantVal;
    final TestDimensionSelector dim2ConstantVal;
    final DimensionSpec dimSpec1 = new DefaultDimensionSpec("dim1", "dim1");
    final DimensionSpec dimSpec2 = new DefaultDimensionSpec("dim2", "dim2");

    private static List<String[]> dimensionValues(Object ... values) {
        return Lists.transform((List)Lists.newArrayList((Object[])values), (Function)new Function<Object, String[]>(){

            @Nullable
            public String[] apply(@Nullable Object input) {
                if (input instanceof String[]) {
                    return (String[])input;
                }
                return new String[]{(String)input};
            }
        });
    }

    private static void aggregate(List<DimensionSelector> selectorList, Aggregator agg) {
        agg.aggregate();
        for (DimensionSelector selector : selectorList) {
            ((TestDimensionSelector)selector).increment();
        }
    }

    private static void bufferAggregate(List<DimensionSelector> selectorList, BufferAggregator agg, ByteBuffer buf, int pos) {
        agg.aggregate(buf, pos);
        for (DimensionSelector selector : selectorList) {
            ((TestDimensionSelector)selector).increment();
        }
    }

    public CardinalityAggregatorTest() {
        this.dim1 = new TestDimensionSelector(VALUES1, null);
        this.dim2 = new TestDimensionSelector(VALUES2, null);
        this.dimInfoList = Lists.newArrayList((Object[])new ColumnSelectorPlus[]{new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim1), new ColumnSelectorPlus(this.dimSpec2.getDimension(), this.dimSpec2.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim2)});
        this.selectorList = Lists.newArrayList((Object[])new DimensionSelector[]{this.dim1, this.dim2});
        this.rowAggregatorFactory = new CardinalityAggregatorFactory("billy", (List)Lists.newArrayList((Object[])new DimensionSpec[]{this.dimSpec1, this.dimSpec2}), true);
        this.rowAggregatorFactoryRounded = new CardinalityAggregatorFactory("billy", null, (List)Lists.newArrayList((Object[])new DimensionSpec[]{this.dimSpec1, this.dimSpec2}), true, true);
        this.valueAggregatorFactory = new CardinalityAggregatorFactory("billy", (List)Lists.newArrayList((Object[])new DimensionSpec[]{this.dimSpec1, this.dimSpec2}), false);
        String superJsFn = "function(str) { return 'super-' + str; }";
        JavaScriptExtractionFn superFn = new JavaScriptExtractionFn(superJsFn, false, JavaScriptConfig.getEnabledInstance());
        this.dim1WithExtraction = new TestDimensionSelector(VALUES1, (ExtractionFn)superFn);
        this.dim2WithExtraction = new TestDimensionSelector(VALUES2, (ExtractionFn)superFn);
        this.selectorListWithExtraction = Lists.newArrayList((Object[])new DimensionSelector[]{this.dim1WithExtraction, this.dim2WithExtraction});
        this.dimInfoListWithExtraction = Lists.newArrayList((Object[])new ColumnSelectorPlus[]{new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim1WithExtraction), new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim2WithExtraction)});
        String helloJsFn = "function(str) { return 'hello' }";
        JavaScriptExtractionFn helloFn = new JavaScriptExtractionFn(helloJsFn, false, JavaScriptConfig.getEnabledInstance());
        this.dim1ConstantVal = new TestDimensionSelector(VALUES1, (ExtractionFn)helloFn);
        this.dim2ConstantVal = new TestDimensionSelector(VALUES2, (ExtractionFn)helloFn);
        this.selectorListConstantVal = Lists.newArrayList((Object[])new DimensionSelector[]{this.dim1ConstantVal, this.dim2ConstantVal});
        this.dimInfoListConstantVal = Lists.newArrayList((Object[])new ColumnSelectorPlus[]{new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim1ConstantVal), new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim2ConstantVal)});
    }

    @Test
    public void testAggregateRows() {
        NullHandling.initializeForTestsWithValues(null, null);
        CardinalityAggregator agg = new CardinalityAggregator(this.dimInfoList, true);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorList, (Aggregator)agg);
        }
        Assert.assertEquals((double)9.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg.get())), (double)0.05);
        Assert.assertEquals((Object)9L, (Object)this.rowAggregatorFactoryRounded.finalizeComputation(agg.get()));
    }

    @Test
    public void testAggregateValues() {
        NullHandling.initializeForTestsWithValues(null, null);
        CardinalityAggregator agg = new CardinalityAggregator(this.dimInfoList, false);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorList, (Aggregator)agg);
        }
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 7.0 : 6.0), (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg.get())), (double)0.05);
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? 7L : 6L), (Object)this.rowAggregatorFactoryRounded.finalizeComputation(agg.get()));
    }

    @Test
    public void testBufferAggregateRows() {
        NullHandling.initializeForTestsWithValues(null, null);
        CardinalityBufferAggregator agg = new CardinalityBufferAggregator(this.dimInfoList.toArray(new ColumnSelectorPlus[0]), true);
        int maxSize = this.rowAggregatorFactory.getMaxIntermediateSizeWithNulls();
        ByteBuffer buf = ByteBuffer.allocate(maxSize + 64);
        int pos = 10;
        buf.limit(pos + maxSize);
        agg.init(buf, pos);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.bufferAggregate(this.selectorList, (BufferAggregator)agg, buf, pos);
        }
        Assert.assertEquals((double)9.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg.get(buf, pos))), (double)0.05);
        Assert.assertEquals((Object)9L, (Object)this.rowAggregatorFactoryRounded.finalizeComputation(agg.get(buf, pos)));
    }

    @Test
    public void testBufferAggregateValues() {
        NullHandling.initializeForTestsWithValues(null, null);
        CardinalityBufferAggregator agg = new CardinalityBufferAggregator(this.dimInfoList.toArray(new ColumnSelectorPlus[0]), false);
        int maxSize = this.valueAggregatorFactory.getMaxIntermediateSizeWithNulls();
        ByteBuffer buf = ByteBuffer.allocate(maxSize + 64);
        int pos = 10;
        buf.limit(pos + maxSize);
        agg.init(buf, pos);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.bufferAggregate(this.selectorList, (BufferAggregator)agg, buf, pos);
        }
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 7.0 : 6.0), (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg.get(buf, pos))), (double)0.05);
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? 7L : 6L), (Object)this.rowAggregatorFactoryRounded.finalizeComputation(agg.get(buf, pos)));
    }

    @Test
    public void testCombineRows() {
        int i;
        NullHandling.initializeForTestsWithValues(null, null);
        List<TestDimensionSelector> selector1 = Collections.singletonList(this.dim1);
        List<TestDimensionSelector> selector2 = Collections.singletonList(this.dim2);
        List<ColumnSelectorPlus> dimInfo1 = Collections.singletonList(new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim1));
        List<ColumnSelectorPlus> dimInfo2 = Collections.singletonList(new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim2));
        CardinalityAggregator agg1 = new CardinalityAggregator(dimInfo1, true);
        CardinalityAggregator agg2 = new CardinalityAggregator(dimInfo2, true);
        for (i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector1, (Aggregator)agg1);
        }
        for (i = 0; i < VALUES2.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector2, (Aggregator)agg2);
        }
        Assert.assertEquals((double)4.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg1.get())), (double)0.05);
        Assert.assertEquals((double)8.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg2.get())), (double)0.05);
        Assert.assertEquals((double)9.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(this.rowAggregatorFactory.combine(agg1.get(), agg2.get()))), (double)0.05);
    }

    @Test
    public void testCombineValues() {
        int i;
        NullHandling.initializeForTestsWithValues(null, null);
        List<TestDimensionSelector> selector1 = Collections.singletonList(this.dim1);
        List<TestDimensionSelector> selector2 = Collections.singletonList(this.dim2);
        List<ColumnSelectorPlus> dimInfo1 = Collections.singletonList(new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim1));
        List<ColumnSelectorPlus> dimInfo2 = Collections.singletonList(new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim2));
        CardinalityAggregator agg1 = new CardinalityAggregator(dimInfo1, false);
        CardinalityAggregator agg2 = new CardinalityAggregator(dimInfo2, false);
        for (i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector1, (Aggregator)agg1);
        }
        for (i = 0; i < VALUES2.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector2, (Aggregator)agg2);
        }
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 4.0 : 3.0), (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg1.get())), (double)0.05);
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 7.0 : 6.0), (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg2.get())), (double)0.05);
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 7.0 : 6.0), (double)((Double)this.rowAggregatorFactory.finalizeComputation(this.rowAggregatorFactory.combine(agg1.get(), agg2.get()))), (double)0.05);
    }

    @Test
    public void testAggregateRowsWithExtraction() {
        NullHandling.initializeForTestsWithValues(null, null);
        CardinalityAggregator agg = new CardinalityAggregator(this.dimInfoListWithExtraction, true);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorListWithExtraction, (Aggregator)agg);
        }
        Assert.assertEquals((double)9.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg.get())), (double)0.05);
        CardinalityAggregator agg2 = new CardinalityAggregator(this.dimInfoListConstantVal, true);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorListConstantVal, (Aggregator)agg2);
        }
        Assert.assertEquals((double)3.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg2.get())), (double)0.05);
    }

    @Test
    public void testAggregateValuesWithExtraction() {
        NullHandling.initializeForTestsWithValues(null, null);
        CardinalityAggregator agg = new CardinalityAggregator(this.dimInfoListWithExtraction, false);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorListWithExtraction, (Aggregator)agg);
        }
        Assert.assertEquals((double)7.0, (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg.get())), (double)0.05);
        CardinalityAggregator agg2 = new CardinalityAggregator(this.dimInfoListConstantVal, false);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorListConstantVal, (Aggregator)agg2);
        }
        Assert.assertEquals((double)1.0, (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg2.get())), (double)0.05);
    }

    @Test
    public void testSerde() throws Exception {
        CardinalityAggregatorFactory factory = new CardinalityAggregatorFactory("billy", null, (List)ImmutableList.of((Object)new DefaultDimensionSpec("b", "b"), (Object)new DefaultDimensionSpec("a", "a"), (Object)new DefaultDimensionSpec("c", "c")), true, true);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)factory, (Object)objectMapper.readValue(objectMapper.writeValueAsString((Object)factory), AggregatorFactory.class));
        String fieldNamesOnly = "{\"type\":\"cardinality\",\"name\":\"billy\",\"fields\":[\"b\",\"a\",\"c\"],\"byRow\":true,\"round\":true}";
        Assert.assertEquals((Object)factory, (Object)objectMapper.readValue(fieldNamesOnly, AggregatorFactory.class));
        CardinalityAggregatorFactory factory2 = new CardinalityAggregatorFactory("billy", (List)ImmutableList.of((Object)new ExtractionDimensionSpec("b", "b", (ExtractionFn)new RegexDimExtractionFn(".*", Boolean.valueOf(false), null)), (Object)new RegexFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("a", "a"), ".*"), (Object)new DefaultDimensionSpec("c", "c")), true);
        Assert.assertEquals((Object)factory2, (Object)objectMapper.readValue(objectMapper.writeValueAsString((Object)factory2), AggregatorFactory.class));
    }

    @Test
    public void testAggregateRowsIgnoreNulls() {
        NullHandling.initializeForTestsWithValues(null, (Boolean)true);
        CardinalityAggregator agg = new CardinalityAggregator(this.dimInfoList, true);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorList, (Aggregator)agg);
        }
        Assert.assertEquals((double)9.0, (double)((Double)this.rowAggregatorFactory.finalizeComputation(agg.get())), (double)0.05);
        Assert.assertEquals((Object)9L, (Object)this.rowAggregatorFactoryRounded.finalizeComputation(agg.get()));
    }

    @Test
    public void testAggregateValuesIgnoreNulls() {
        NullHandling.initializeForTestsWithValues(null, (Boolean)true);
        CardinalityAggregator agg = new CardinalityAggregator(this.dimInfoList, false);
        for (int i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(this.selectorList, (Aggregator)agg);
        }
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 6.0 : 6.0), (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg.get())), (double)0.05);
        Assert.assertEquals((Object)(NullHandling.replaceWithDefault() ? 6L : 6L), (Object)this.rowAggregatorFactoryRounded.finalizeComputation(agg.get()));
    }

    @Test
    public void testCombineValuesIgnoreNulls() {
        int i;
        NullHandling.initializeForTestsWithValues(null, (Boolean)true);
        List<TestDimensionSelector> selector1 = Collections.singletonList(this.dim1);
        List<TestDimensionSelector> selector2 = Collections.singletonList(this.dim2);
        List<ColumnSelectorPlus> dimInfo1 = Collections.singletonList(new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim1));
        List<ColumnSelectorPlus> dimInfo2 = Collections.singletonList(new ColumnSelectorPlus(this.dimSpec1.getDimension(), this.dimSpec1.getOutputName(), (ColumnSelectorStrategy)new StringCardinalityAggregatorColumnSelectorStrategy(), (ColumnValueSelector)this.dim2));
        CardinalityAggregator agg1 = new CardinalityAggregator(dimInfo1, false);
        CardinalityAggregator agg2 = new CardinalityAggregator(dimInfo2, false);
        for (i = 0; i < VALUES1.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector1, (Aggregator)agg1);
        }
        for (i = 0; i < VALUES2.size(); ++i) {
            CardinalityAggregatorTest.aggregate(selector2, (Aggregator)agg2);
        }
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 3.0 : 3.0), (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg1.get())), (double)0.05);
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 6.0 : 6.0), (double)((Double)this.valueAggregatorFactory.finalizeComputation(agg2.get())), (double)0.05);
        Assert.assertEquals((double)(NullHandling.replaceWithDefault() ? 6.0 : 6.0), (double)((Double)this.rowAggregatorFactory.finalizeComputation(this.rowAggregatorFactory.combine(agg1.get(), agg2.get()))), (double)0.05);
    }

    public static class TestDimensionSelector
    extends AbstractDimensionSelector {
        private final List<Integer[]> column;
        private final Map<String, Integer> ids;
        private final Map<Integer, String> lookup = new HashMap<Integer, String>();
        private final ExtractionFn exFn;
        private int pos = 0;

        public TestDimensionSelector(Iterable<String[]> values, ExtractionFn exFn) {
            this.ids = new HashMap<String, Integer>();
            this.exFn = exFn;
            int index = 0;
            for (String[] multiValue : values) {
                for (String value : multiValue) {
                    if (this.ids.containsKey(value)) continue;
                    this.ids.put(value, index);
                    this.lookup.put(index, value);
                    ++index;
                }
            }
            this.column = Lists.newArrayList((Iterable)Iterables.transform(values, (Function)new Function<String[], Integer[]>(){

                @Nullable
                public Integer[] apply(@Nullable String[] input) {
                    return (Integer[])Iterators.toArray((Iterator)Iterators.transform((Iterator)Iterators.forArray((Object[])input), ids::get), Integer.class);
                }
            }));
        }

        public void increment() {
            ++this.pos;
        }

        public void reset() {
            this.pos = 0;
        }

        public IndexedInts getRow() {
            final int p = this.pos;
            return new IndexedInts(){

                public int size() {
                    return ((Integer[])column.get(p)).length;
                }

                public int get(int i) {
                    return ((Integer[])column.get(p))[i];
                }

                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }
            };
        }

        public ValueMatcher makeValueMatcher(String value) {
            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, (String)value);
        }

        public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
            return DimensionSelectorUtils.makeValueMatcherGeneric((DimensionSelector)this, predicate);
        }

        public int getValueCardinality() {
            return 1;
        }

        public String lookupName(int i) {
            String val = this.lookup.get(i);
            return this.exFn == null ? val : this.exFn.apply(val);
        }

        public boolean nameLookupPossibleInAdvance() {
            return true;
        }

        @Nullable
        public IdLookup idLookup() {
            return new IdLookup(){

                public int lookupId(String s) {
                    return (Integer)ids.get(s);
                }
            };
        }

        public Class classOfObject() {
            return Object.class;
        }

        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }
    }
}

