/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class GroupByQueryConfigTest {
    private final ObjectMapper MAPPER = TestHelper.makeJsonMapper();
    private final ImmutableMap<String, String> CONFIG_MAP = ImmutableMap.builder().put((Object)"singleThreaded", (Object)"true").put((Object)"defaultStrategy", (Object)"v2").put((Object)"bufferGrouperInitialBuckets", (Object)"1").put((Object)"maxIntermediateRows", (Object)"2").put((Object)"maxResults", (Object)"3").put((Object)"maxOnDiskStorage", (Object)"4").put((Object)"maxSelectorDictionarySize", (Object)"5").put((Object)"maxMergingDictionarySize", (Object)"6").put((Object)"bufferGrouperMaxLoadFactor", (Object)"7").build();

    @Test
    public void testSerde() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP, GroupByQueryConfig.class);
        Assert.assertEquals((Object)true, (Object)config.isSingleThreaded());
        Assert.assertEquals((Object)"v2", (Object)config.getDefaultStrategy());
        Assert.assertEquals((long)1L, (long)config.getBufferGrouperInitialBuckets());
        Assert.assertEquals((long)2L, (long)config.getMaxIntermediateRows());
        Assert.assertEquals((long)3L, (long)config.getMaxResults());
        Assert.assertEquals((long)4L, (long)config.getMaxOnDiskStorage());
        Assert.assertEquals((long)5L, (long)config.getMaxSelectorDictionarySize());
        Assert.assertEquals((long)6L, (long)config.getMaxMergingDictionarySize());
        Assert.assertEquals((double)7.0, (double)config.getBufferGrouperMaxLoadFactor(), (double)0.0);
        Assert.assertFalse((boolean)config.isApplyLimitPushDownToSegment());
    }

    @Test
    public void testNoOverrides() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP, GroupByQueryConfig.class);
        GroupByQueryConfig config2 = config.withOverrides(GroupByQuery.builder().setDataSource("test").setInterval(Intervals.of((String)"2000/P1D")).setGranularity(Granularities.ALL).build());
        Assert.assertEquals((Object)true, (Object)config2.isSingleThreaded());
        Assert.assertEquals((Object)"v2", (Object)config2.getDefaultStrategy());
        Assert.assertEquals((long)1L, (long)config2.getBufferGrouperInitialBuckets());
        Assert.assertEquals((long)2L, (long)config2.getMaxIntermediateRows());
        Assert.assertEquals((long)3L, (long)config2.getMaxResults());
        Assert.assertEquals((long)4L, (long)config2.getMaxOnDiskStorage());
        Assert.assertEquals((long)5L, (long)config2.getMaxSelectorDictionarySize());
        Assert.assertEquals((long)6L, (long)config2.getMaxMergingDictionarySize());
        Assert.assertEquals((double)7.0, (double)config2.getBufferGrouperMaxLoadFactor(), (double)0.0);
        Assert.assertFalse((boolean)config2.isApplyLimitPushDownToSegment());
    }

    @Test
    public void testOverrides() {
        GroupByQueryConfig config = (GroupByQueryConfig)this.MAPPER.convertValue(this.CONFIG_MAP, GroupByQueryConfig.class);
        GroupByQueryConfig config2 = config.withOverrides(GroupByQuery.builder().setDataSource("test").setInterval(Intervals.of((String)"2000/P1D")).setGranularity(Granularities.ALL).setContext((Map)ImmutableMap.builder().put((Object)"groupByStrategy", (Object)"v1").put((Object)"maxOnDiskStorage", (Object)0).put((Object)"maxResults", (Object)2).put((Object)"maxSelectorDictionarySize", (Object)3).put((Object)"maxMergingDictionarySize", (Object)4).put((Object)"applyLimitPushDownToSegment", (Object)true).build()).build());
        Assert.assertEquals((Object)true, (Object)config2.isSingleThreaded());
        Assert.assertEquals((Object)"v1", (Object)config2.getDefaultStrategy());
        Assert.assertEquals((long)1L, (long)config2.getBufferGrouperInitialBuckets());
        Assert.assertEquals((long)2L, (long)config2.getMaxIntermediateRows());
        Assert.assertEquals((long)2L, (long)config2.getMaxResults());
        Assert.assertEquals((long)0L, (long)config2.getMaxOnDiskStorage());
        Assert.assertEquals((long)3L, (long)config2.getMaxSelectorDictionarySize());
        Assert.assertEquals((long)4L, (long)config2.getMaxMergingDictionarySize());
        Assert.assertEquals((double)7.0, (double)config2.getBufferGrouperMaxLoadFactor(), (double)0.0);
        Assert.assertTrue((boolean)config2.isApplyLimitPushDownToSegment());
    }
}

