/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.MergeSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.GroupByQueryRunnerFactory;
import org.apache.druid.query.groupby.GroupByQueryRunnerTest;
import org.apache.druid.query.groupby.GroupByQueryRunnerTestHelper;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.timeline.SegmentId;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class GroupByQueryRunnerFactoryTest {
    @Rule
    public CloserRule closerRule = new CloserRule(true);
    private GroupByQueryRunnerFactory factory;
    private Closer resourceCloser;

    @Before
    public void setup() {
        Pair<GroupByQueryRunnerFactory, Closer> factoryAndCloser = GroupByQueryRunnerTest.makeQueryRunnerFactory(new GroupByQueryConfig());
        this.factory = (GroupByQueryRunnerFactory)factoryAndCloser.lhs;
        this.resourceCloser = (Closer)factoryAndCloser.rhs;
    }

    @After
    public void teardown() throws IOException {
        this.resourceCloser.close();
    }

    @Test
    public void testMergeRunnersEnsureGroupMerging() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("xx").setQuerySegmentSpec((QuerySegmentSpec)new LegacySegmentSpec((Object)"1970/3000")).setGranularity(Granularities.ALL).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("tags", "tags")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
        QueryRunner mergedRunner = this.factory.getToolchest().mergeResults(new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                return GroupByQueryRunnerFactoryTest.this.factory.getToolchest().mergeResults(new QueryRunner(){

                    public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                        Query query = queryPlus.getQuery();
                        try {
                            return new MergeSequence(query.getResultOrdering(), Sequences.simple(Arrays.asList(GroupByQueryRunnerFactoryTest.this.factory.createRunner(GroupByQueryRunnerFactoryTest.this.createSegment()).run(queryPlus, responseContext), GroupByQueryRunnerFactoryTest.this.factory.createRunner(GroupByQueryRunnerFactoryTest.this.createSegment()).run(queryPlus, responseContext))));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }).run(queryPlus, responseContext);
            }
        });
        Sequence result = mergedRunner.run(QueryPlus.wrap((Query)query), ResponseContext.createEmpty());
        List<ResultRow> expectedResults = Arrays.asList(GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "t1", "count", 2L), GroupByQueryRunnerTestHelper.createExpectedRow(query, "1970-01-01T00:00:00.000Z", "tags", "t2", "count", 4L));
        TestHelper.assertExpectedObjects(expectedResults, result.toList(), "");
    }

    private Segment createSegment() throws Exception {
        String[] rows;
        IncrementalIndex incrementalIndex = new OnheapIncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("count")}).setConcurrentEventAdd(true).setMaxRowCount(5000).build();
        StringInputRowParser parser = new StringInputRowParser((ParseSpec)new CSVParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"product", (Object)"tags"))), "\t", (List)ImmutableList.of((Object)"timestamp", (Object)"product", (Object)"tags"), false, 0), "UTF-8");
        for (String row : rows = new String[]{"2011-01-12T00:00:00.000Z,product_1,t1", "2011-01-13T00:00:00.000Z,product_2,t2", "2011-01-14T00:00:00.000Z,product_3,t2"}) {
            incrementalIndex.add(parser.parse(row));
        }
        this.closerRule.closeLater(incrementalIndex);
        return new IncrementalIndexSegment(incrementalIndex, SegmentId.dummy((String)"test"));
    }
}

