/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.NoopAggregator;
import org.apache.druid.query.aggregation.NoopBufferAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.query.metadata.SegmentAnalyzer;
import org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SegmentAnalyzerTest
extends InitializedNullHandlingTest {
    private static final EnumSet<SegmentMetadataQuery.AnalysisType> EMPTY_ANALYSES = EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class);
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testIncrementalWorks() {
        this.testIncrementalWorksHelper(null);
        this.testIncrementalWorksHelper(EMPTY_ANALYSES);
    }

    private void testIncrementalWorksHelper(EnumSet<SegmentMetadataQuery.AnalysisType> analyses) {
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), SegmentId.dummy((String)"ds")), analyses);
        Assert.assertEquals((long)1L, (long)results.size());
        SegmentAnalysis analysis = results.get(0);
        Assert.assertEquals((Object)SegmentId.dummy((String)"ds").toString(), (Object)analysis.getId());
        Map columns = analysis.getColumns();
        Assert.assertEquals((long)(TestIndex.COLUMNS.length + 3), (long)columns.size());
        for (DimensionSchema schema : TestIndex.DIMENSION_SCHEMAS) {
            String dimension = schema.getName();
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(dimension);
            boolean isString = schema.getColumnType().is((TypeDescriptor)ValueType.STRING);
            Assert.assertEquals((String)dimension, (Object)schema.getColumnType().toString(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getSize());
            if (isString) {
                if (analyses == null) {
                    Assert.assertTrue((String)dimension, (columnAnalysis.getCardinality() > 0 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getCardinality().longValue());
                continue;
            }
            Assert.assertNull((String)dimension, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.DOUBLE_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.DOUBLE.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.FLOAT_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.FLOAT.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
    }

    @Test
    public void testMappedWorks() {
        this.testMappedWorksHelper(null);
        this.testMappedWorksHelper(EMPTY_ANALYSES);
    }

    private void testMappedWorksHelper(EnumSet<SegmentMetadataQuery.AnalysisType> analyses) {
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)new QueryableIndexSegment(TestIndex.getMMappedTestIndex(), SegmentId.dummy((String)"test_1")), analyses);
        Assert.assertEquals((long)1L, (long)results.size());
        SegmentAnalysis analysis = results.get(0);
        Assert.assertEquals((Object)SegmentId.dummy((String)"test_1").toString(), (Object)analysis.getId());
        Map columns = analysis.getColumns();
        Assert.assertEquals((long)(TestIndex.COLUMNS.length + 3), (long)columns.size());
        for (DimensionSchema schema : TestIndex.DIMENSION_SCHEMAS) {
            String dimension = schema.getName();
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(dimension);
            boolean isString = schema.getColumnType().is((TypeDescriptor)ValueType.STRING);
            Assert.assertEquals((String)dimension, (Object)schema.getColumnType().toString(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getSize());
            if (isString) {
                if (analyses == null) {
                    Assert.assertTrue((String)dimension, (columnAnalysis.getCardinality() > 0 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertEquals((String)dimension, (long)0L, (long)columnAnalysis.getCardinality().longValue());
                continue;
            }
            Assert.assertNull((String)dimension, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.DOUBLE_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.DOUBLE.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
        for (String metric : TestIndex.FLOAT_METRICS) {
            ColumnAnalysis columnAnalysis = (ColumnAnalysis)columns.get(metric);
            Assert.assertEquals((String)metric, (Object)ValueType.FLOAT.name(), (Object)columnAnalysis.getType());
            Assert.assertEquals((String)metric, (long)0L, (long)columnAnalysis.getSize());
            Assert.assertNull((String)metric, (Object)columnAnalysis.getCardinality());
        }
    }

    private List<SegmentAnalysis> getSegmentAnalysises(Segment index, EnumSet<SegmentMetadataQuery.AnalysisType> analyses) {
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER), index, null);
        SegmentMetadataQuery query = new SegmentMetadataQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new LegacySegmentSpec((Object)"2011/2012"), null, null, null, analyses, Boolean.valueOf(false), Boolean.valueOf(false));
        return runner.run(QueryPlus.wrap((Query)query)).toList();
    }

    @Test
    public void testAnalyzingSegmentWithNonExistentAggregator() throws IOException {
        URL resource = SegmentAnalyzerTest.class.getClassLoader().getResource("druid.sample.numeric.tsv");
        CharSource source = Resources.asByteSource((URL)resource).asCharSource(StandardCharsets.UTF_8);
        String invalid_aggregator = "invalid_aggregator";
        AggregatorFactory[] metrics = new AggregatorFactory[]{new DoubleSumAggregatorFactory(TestIndex.DOUBLE_METRICS[0], "index"), new HyperUniquesAggregatorFactory("quality_uniques", "quality"), new InvalidAggregatorFactory(invalid_aggregator, "quality")};
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-12T00:00:00.000Z").getMillis()).withTimestampSpec(new TimestampSpec("ds", "auto", null)).withDimensionsSpec(TestIndex.DIMENSIONS_SPEC).withMetrics(metrics).withRollup(true).build();
        IncrementalIndex retVal = new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(10000).build();
        IncrementalIndex incrementalIndex = TestIndex.loadIncrementalIndex(retVal, source);
        SegmentAnalyzer analyzer = new SegmentAnalyzer(EnumSet.of(SegmentMetadataQuery.AnalysisType.SIZE));
        IncrementalIndexSegment segment = new IncrementalIndexSegment(incrementalIndex, SegmentId.dummy((String)"ds"));
        Map analyses = analyzer.analyze((Segment)segment);
        ColumnAnalysis columnAnalysis = (ColumnAnalysis)analyses.get(invalid_aggregator);
        Assert.assertFalse((boolean)columnAnalysis.isError());
        Assert.assertEquals((Object)"invalid_complex_column_type", (Object)columnAnalysis.getType());
        Assert.assertEquals((Object)ColumnType.ofComplex((String)"invalid_complex_column_type"), (Object)columnAnalysis.getTypeSignature());
        File segmentFile = TestIndex.INDEX_MERGER.persist(incrementalIndex, this.temporaryFolder.newFolder(), TestIndex.INDEX_SPEC, null);
        ComplexMetrics.unregisterSerde((String)"invalid_complex_column_type");
        SegmentAnalyzer analyzer2 = new SegmentAnalyzer(EnumSet.of(SegmentMetadataQuery.AnalysisType.SIZE));
        QueryableIndexSegment segment2 = new QueryableIndexSegment(TestIndex.INDEX_IO.loadIndex(segmentFile), SegmentId.dummy((String)"ds"));
        Map analyses2 = analyzer2.analyze((Segment)segment2);
        ColumnAnalysis invalidColumnAnalysis = (ColumnAnalysis)analyses2.get(invalid_aggregator);
        Assert.assertTrue((boolean)invalidColumnAnalysis.isError());
        Assert.assertEquals((Object)"error:unknown_complex_invalid_complex_column_type", (Object)invalidColumnAnalysis.getErrorMessage());
        List<SegmentAnalysis> results = this.getSegmentAnalysises((Segment)segment2, EnumSet.of(SegmentMetadataQuery.AnalysisType.SIZE));
        for (SegmentAnalysis result : results) {
            Assert.assertTrue((boolean)((ColumnAnalysis)result.getColumns().get(invalid_aggregator)).isError());
        }
    }

    static {
        ComplexMetrics.registerSerde((String)"invalid_complex_column_type", (ComplexMetricSerde)new ComplexMetricSerde(){

            public String getTypeName() {
                return "invalid_complex_column_type";
            }

            public ComplexMetricExtractor getExtractor() {
                return null;
            }

            public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
            }

            public ObjectStrategy getObjectStrategy() {
                return DummyObjectStrategy.getInstance();
            }
        });
    }

    private static class InvalidAggregatorFactory
    extends AggregatorFactory {
        private final String name;
        private final String fieldName;
        private static final String TYPE = "invalid_complex_column_type";

        public InvalidAggregatorFactory(String name, String fieldName) {
            this.name = name;
            this.fieldName = fieldName;
        }

        public Aggregator factorize(ColumnSelectorFactory metricFactory) {
            return NoopAggregator.instance();
        }

        public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
            return NoopBufferAggregator.instance();
        }

        public Comparator getComparator() {
            return null;
        }

        @Nullable
        public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
            return null;
        }

        public AggregatorFactory getCombiningFactory() {
            return null;
        }

        public List<AggregatorFactory> getRequiredColumns() {
            return null;
        }

        public Object deserialize(Object object) {
            return null;
        }

        @Nullable
        public Object finalizeComputation(@Nullable Object object) {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public List<String> requiredFields() {
            return Collections.singletonList(this.fieldName);
        }

        public ColumnType getIntermediateType() {
            return new ColumnType(ValueType.COMPLEX, TYPE, null);
        }

        public int getMaxIntermediateSize() {
            return 0;
        }

        public byte[] getCacheKey() {
            return new byte[0];
        }

        public ColumnType getResultType() {
            return this.getIntermediateType();
        }
    }

    private static final class DummyObjectStrategy
    implements ObjectStrategy {
        private static final Object TO_RETURN = new Object();
        private static final DummyObjectStrategy INSTANCE = new DummyObjectStrategy();

        private DummyObjectStrategy() {
        }

        private static DummyObjectStrategy getInstance() {
            return INSTANCE;
        }

        public Class getClazz() {
            return Object.class;
        }

        @Nullable
        public Object fromByteBuffer(ByteBuffer buffer, int numBytes) {
            return TO_RETURN;
        }

        @Nullable
        public byte[] toBytes(@Nullable Object val) {
            return new byte[0];
        }

        public int compare(Object o1, Object o2) {
            return 0;
        }
    }
}

