/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.scan;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.LegacySegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.VirtualColumns;
import org.junit.Assert;
import org.junit.Test;

public class ScanQuerySpecTest {
    private static final ObjectMapper JSON_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerialization() throws Exception {
        String legacy = "{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"filter\":null,\"columns\":[\"market\",\"quality\",\"index\"],\"limit\":3,\"context\":null}";
        String current = "{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"virtualColumns\":[],\"resultFormat\":\"list\",\"batchSize\":20480,\"limit\":3,\"filter\":null,\"columns\":[\"market\",\"quality\",\"index\"],\"context\":{},\"descending\":false,\"granularity\":{\"type\":\"all\"}}";
        ScanQuery query = new ScanQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), VirtualColumns.EMPTY, ScanQuery.ResultFormat.RESULT_FORMAT_LIST, 0, 0L, 3L, ScanQuery.Order.NONE, null, null, Arrays.asList("market", "quality", "index"), null, null);
        String actual = JSON_MAPPER.writeValueAsString((Object)query);
        Assert.assertEquals((Object)current, (Object)actual);
        Assert.assertEquals((Object)query, (Object)JSON_MAPPER.readValue(actual, ScanQuery.class));
        Assert.assertEquals((Object)query, (Object)JSON_MAPPER.readValue(legacy, ScanQuery.class));
    }

    @Test
    public void testSerializationWithTimeOrder() throws Exception {
        String originalJson = "{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"virtualColumns\":[],\"resultFormat\":\"list\",\"batchSize\":20480,\"limit\":3,\"order\":\"ascending\",\"filter\":null,\"columns\":[\"market\",\"quality\",\"index\",\"__time\"],\"context\":{},\"descending\":false,\"granularity\":{\"type\":\"all\"}}";
        ScanQuery expectedQuery = new ScanQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), VirtualColumns.EMPTY, ScanQuery.ResultFormat.RESULT_FORMAT_LIST, 0, 0L, 3L, ScanQuery.Order.ASCENDING, null, null, Arrays.asList("market", "quality", "index", "__time"), null, null);
        String serializedJson = JSON_MAPPER.writeValueAsString((Object)expectedQuery);
        Assert.assertEquals((Object)originalJson, (Object)serializedJson);
        Assert.assertEquals((Object)expectedQuery, (Object)JSON_MAPPER.readValue(originalJson, ScanQuery.class));
        Assert.assertEquals((Object)ScanQuery.Order.ASCENDING, (Object)expectedQuery.getTimeOrder());
        Assert.assertEquals(Collections.singletonList(new ScanQuery.OrderBy("__time", ScanQuery.Order.ASCENDING)), (Object)expectedQuery.getOrderBys());
    }

    @Test
    public void testSerializationWithOrderBy() throws Exception {
        String originalJson = "{\"queryType\":\"scan\",\"dataSource\":{\"type\":\"table\",\"name\":\"testing\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2011-01-12T00:00:00.000Z/2011-01-14T00:00:00.000Z\"]},\"virtualColumns\":[],\"resultFormat\":\"list\",\"batchSize\":20480,\"limit\":3,\"orderBy\":[{\"columnName\":\"quality\",\"order\":\"ascending\"}],\"filter\":null,\"columns\":[\"market\",\"quality\",\"index\",\"__time\"],\"context\":{},\"descending\":false,\"granularity\":{\"type\":\"all\"}}";
        ScanQuery expectedQuery = new ScanQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), VirtualColumns.EMPTY, ScanQuery.ResultFormat.RESULT_FORMAT_LIST, 0, 0L, 3L, null, Collections.singletonList(new ScanQuery.OrderBy("quality", ScanQuery.Order.ASCENDING)), null, Arrays.asList("market", "quality", "index", "__time"), null, null);
        String serializedJson = JSON_MAPPER.writeValueAsString((Object)expectedQuery);
        Assert.assertEquals((Object)originalJson, (Object)serializedJson);
        Assert.assertEquals((Object)expectedQuery, (Object)JSON_MAPPER.readValue(originalJson, ScanQuery.class));
        Assert.assertEquals((Object)ScanQuery.Order.NONE, (Object)expectedQuery.getTimeOrder());
        Assert.assertEquals(Collections.singletonList(new ScanQuery.OrderBy("quality", ScanQuery.Order.ASCENDING)), (Object)expectedQuery.getOrderBys());
    }

    @Test
    public void testSerializationLegacyString() throws Exception {
        ScanQuery query = new ScanQuery((DataSource)new TableDataSource("testing"), (QuerySegmentSpec)new LegacySegmentSpec((Object)Intervals.of((String)"2011-01-12/2011-01-14")), VirtualColumns.EMPTY, ScanQuery.ResultFormat.RESULT_FORMAT_LIST, 0, 1L, 3L, ScanQuery.Order.NONE, null, null, Arrays.asList("market", "quality", "index"), null, null);
        String serialized = JSON_MAPPER.writeValueAsString((Object)query);
        ScanQuery deserialized = (ScanQuery)JSON_MAPPER.readValue(serialized, Query.class);
        Assert.assertEquals((Object)query, (Object)deserialized);
    }
}

