/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeboundary;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ConcurrentResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryRunnerFactory;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleElementPartitionChunk;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeBoundaryQueryRunnerTest {
    private final QueryRunner runner;
    private static final QueryRunnerFactory FACTORY = new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    private static Segment segment0;
    private static Segment segment1;
    public static final String[] V_0112;
    public static final String[] V_0113;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.transformToConstructionFeeder(QueryRunnerTestHelper.makeQueryRunners(new TimeBoundaryQueryRunnerFactory(QueryRunnerTestHelper.NOOP_QUERYWATCHER)));
    }

    public TimeBoundaryQueryRunnerTest(QueryRunner runner) {
        this.runner = runner;
    }

    private static IncrementalIndex newIndex(String minTimeStamp) {
        return TimeBoundaryQueryRunnerTest.newIndex(minTimeStamp, 10000);
    }

    private static IncrementalIndex newIndex(String minTimeStamp, int maxRowCount) {
        IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)minTimeStamp).getMillis()).withQueryGranularity(Granularities.HOUR).withMetrics(TestIndex.METRIC_AGGS).build();
        return new OnheapIncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(maxRowCount).build();
    }

    private static SegmentId makeIdentifier(IncrementalIndex index, String version) {
        return TimeBoundaryQueryRunnerTest.makeIdentifier(index.getInterval(), version);
    }

    private static SegmentId makeIdentifier(Interval interval, String version) {
        return SegmentId.of((String)"testing", (Interval)interval, (String)version, (ShardSpec)NoneShardSpec.instance());
    }

    private QueryRunner getCustomRunner() throws IOException {
        CharSource v_0112 = CharSource.wrap((CharSequence)StringUtils.join((Object[])V_0112, (String)"\n"));
        CharSource v_0113 = CharSource.wrap((CharSequence)StringUtils.join((Object[])V_0113, (String)"\n"));
        IncrementalIndex index0 = TestIndex.loadIncrementalIndex(TimeBoundaryQueryRunnerTest.newIndex("2011-01-12T00:00:00.000Z"), v_0112);
        IncrementalIndex index1 = TestIndex.loadIncrementalIndex(TimeBoundaryQueryRunnerTest.newIndex("2011-01-14T00:00:00.000Z"), v_0113);
        segment0 = new IncrementalIndexSegment(index0, TimeBoundaryQueryRunnerTest.makeIdentifier(index0, "v1"));
        segment1 = new IncrementalIndexSegment(index1, TimeBoundaryQueryRunnerTest.makeIdentifier(index1, "v1"));
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)StringComparators.LEXICOGRAPHIC);
        timeline.add(index0.getInterval(), (Object)"v1", (PartitionChunk)new SingleElementPartitionChunk((Object)ReferenceCountingSegment.wrapRootGenerationSegment((Segment)segment0)));
        timeline.add(index1.getInterval(), (Object)"v1", (PartitionChunk)new SingleElementPartitionChunk((Object)ReferenceCountingSegment.wrapRootGenerationSegment((Segment)segment1)));
        return QueryRunnerTestHelper.makeFilteringQueryRunner((VersionedIntervalTimeline<String, ReferenceCountingSegment>)timeline, FACTORY);
    }

    @Test
    public void testFilteredTimeBoundaryQuery() throws IOException {
        QueryRunner customRunner = this.getCustomRunner();
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").filters("quality", "automotive").build();
        Assert.assertTrue((boolean)timeBoundaryQuery.hasFilters());
        List results = customRunner.run(QueryPlus.wrap((Query)timeBoundaryQuery)).toList();
        Assert.assertTrue((Iterables.size((Iterable)results) > 0 ? 1 : 0) != 0);
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-13T00:00:00.000Z"), (Object)minTime);
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-16T00:00:00.000Z"), (Object)maxTime);
    }

    @Test
    public void testFilteredTimeBoundaryQueryNoMatches() throws IOException {
        QueryRunner customRunner = this.getCustomRunner();
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").filters("quality", "foobar").build();
        Assert.assertTrue((boolean)timeBoundaryQuery.hasFilters());
        List results = customRunner.run(QueryPlus.wrap((Query)timeBoundaryQuery)).toList();
        Assert.assertTrue((Iterables.size((Iterable)results) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTimeBoundary() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").build();
        Assert.assertFalse((boolean)timeBoundaryQuery.hasFilters());
        List results = this.runner.run(QueryPlus.wrap((Query)timeBoundaryQuery)).toList();
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)minTime);
        Assert.assertEquals((Object)DateTimes.of((String)"2011-04-15T00:00:00.000Z"), (Object)maxTime);
    }

    @Test
    public void testTimeBoundaryMax() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").bound("maxTime").build();
        ConcurrentResponseContext context = ConcurrentResponseContext.createEmpty();
        context.initializeMissingSegments();
        List results = this.runner.run(QueryPlus.wrap((Query)timeBoundaryQuery), (ResponseContext)context).toList();
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertNull((Object)minTime);
        Assert.assertEquals((Object)DateTimes.of((String)"2011-04-15T00:00:00.000Z"), (Object)maxTime);
    }

    @Test
    public void testTimeBoundaryMin() {
        TimeBoundaryQuery timeBoundaryQuery = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").bound("minTime").build();
        ConcurrentResponseContext context = ConcurrentResponseContext.createEmpty();
        context.initializeMissingSegments();
        List results = this.runner.run(QueryPlus.wrap((Query)timeBoundaryQuery), (ResponseContext)context).toList();
        TimeBoundaryResultValue val = (TimeBoundaryResultValue)((Result)results.iterator().next()).getValue();
        DateTime minTime = val.getMinTime();
        DateTime maxTime = val.getMaxTime();
        Assert.assertEquals((Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)minTime);
        Assert.assertNull((Object)maxTime);
    }

    @Test
    public void testMergeResults() {
        List<Result> results = Arrays.asList(new Result(DateTimes.nowUtc(), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)"2012-01-01", (Object)"minTime", (Object)"2011-01-01"))), new Result(DateTimes.nowUtc(), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)"2012-02-01", (Object)"minTime", (Object)"2011-01-01"))));
        TimeBoundaryQuery query = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null, null);
        Iterable actual = query.mergeResults(results);
        Assert.assertTrue((boolean)((TimeBoundaryResultValue)((Result)actual.iterator().next()).getValue()).getMaxTime().equals((Object)DateTimes.of((String)"2012-02-01")));
    }

    @Test
    public void testMergeResultsEmptyResults() {
        ArrayList results = new ArrayList();
        TimeBoundaryQuery query = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null, null);
        Iterable actual = query.mergeResults(results);
        Assert.assertFalse((boolean)actual.iterator().hasNext());
    }

    static {
        V_0112 = new String[]{"2011-01-12T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t100.000000", "2011-01-12T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t100.000000", "2011-01-13T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t100.000000", "2011-01-13T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t100.000000"};
        V_0113 = new String[]{"2011-01-14T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-14T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299", "2011-01-15T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-15T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-16T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t100000\tpreferred\ta\u0001preferred\t94.874713", "2011-01-16T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-16T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299", "2011-01-17T01:00:00.000Z\tspot\tbusiness\t1100\t11000.0\t110000\tpreferred\tb\u0001preferred\t103.629399", "2011-01-17T02:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t120000\tpreferred\te\u0001preferred\t110.087299"};
    }
}

