/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorBitmapIndexSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringDictionaryEncodedColumn;
import org.apache.druid.segment.data.CloseableIndexed;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnSelectorBitmapIndexSelectorTest {
    private static final String STRING_DICTIONARY_COLUMN_NAME = "string";
    private static final String NON_STRING_DICTIONARY_COLUMN_NAME = "not-string";
    BitmapFactory bitmapFactory;
    VirtualColumns virtualColumns;
    ColumnSelector index;
    ColumnSelectorBitmapIndexSelector bitmapIndexSelector;

    @Before
    public void setup() {
        this.bitmapFactory = (BitmapFactory)EasyMock.createMock(BitmapFactory.class);
        this.virtualColumns = (VirtualColumns)EasyMock.createMock(VirtualColumns.class);
        this.index = (ColumnSelector)EasyMock.createMock(ColumnSelector.class);
        this.bitmapIndexSelector = new ColumnSelectorBitmapIndexSelector(this.bitmapFactory, this.virtualColumns, this.index);
        EasyMock.expect((Object)this.virtualColumns.getVirtualColumn(STRING_DICTIONARY_COLUMN_NAME)).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.virtualColumns.getVirtualColumn(NON_STRING_DICTIONARY_COLUMN_NAME)).andReturn(null).anyTimes();
        ColumnHolder holder = (ColumnHolder)EasyMock.createMock(ColumnHolder.class);
        EasyMock.expect((Object)this.index.getColumnHolder(STRING_DICTIONARY_COLUMN_NAME)).andReturn((Object)holder).anyTimes();
        StringDictionaryEncodedColumn stringColumn = (StringDictionaryEncodedColumn)EasyMock.createMock(StringDictionaryEncodedColumn.class);
        EasyMock.expect((Object)holder.getCapabilities()).andReturn((Object)ColumnCapabilitiesImpl.createDefault().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(true)).anyTimes();
        EasyMock.expect((Object)holder.getColumn()).andReturn((Object)stringColumn).anyTimes();
        BitmapIndex someIndex = (BitmapIndex)EasyMock.createMock(BitmapIndex.class);
        EasyMock.expect((Object)holder.getBitmapIndex()).andReturn((Object)someIndex).anyTimes();
        ImmutableBitmap someBitmap = (ImmutableBitmap)EasyMock.createMock(ImmutableBitmap.class);
        EasyMock.expect((Object)someIndex.getIndex("foo")).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)someIndex.getBitmap(0)).andReturn((Object)someBitmap).anyTimes();
        ColumnHolder nonStringHolder = (ColumnHolder)EasyMock.createMock(ColumnHolder.class);
        EasyMock.expect((Object)this.index.getColumnHolder(NON_STRING_DICTIONARY_COLUMN_NAME)).andReturn((Object)nonStringHolder).anyTimes();
        EasyMock.expect((Object)nonStringHolder.getCapabilities()).andReturn((Object)ColumnCapabilitiesImpl.createDefault().setType(ColumnType.ofComplex((String)"testBlob")).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(true).setFilterable(true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.bitmapFactory, this.virtualColumns, this.index, holder, stringColumn, nonStringHolder, someIndex, someBitmap});
    }

    @Test
    public void testStringDictionaryUseIndex() {
        BitmapIndex bitmapIndex = this.bitmapIndexSelector.getBitmapIndex(STRING_DICTIONARY_COLUMN_NAME);
        Assert.assertNotNull((Object)bitmapIndex);
        CloseableIndexed vals = this.bitmapIndexSelector.getDimensionValues(STRING_DICTIONARY_COLUMN_NAME);
        Assert.assertNotNull((Object)vals);
        ImmutableBitmap valueIndex = this.bitmapIndexSelector.getBitmapIndex(STRING_DICTIONARY_COLUMN_NAME, "foo");
        Assert.assertNotNull((Object)valueIndex);
        EasyMock.verify((Object[])new Object[]{this.bitmapFactory, this.virtualColumns, this.index});
    }

    @Test
    public void testNonStringDictionaryDoNotUseIndex() {
        BitmapIndex bitmapIndex = this.bitmapIndexSelector.getBitmapIndex(NON_STRING_DICTIONARY_COLUMN_NAME);
        Assert.assertNull((Object)bitmapIndex);
        CloseableIndexed vals = this.bitmapIndexSelector.getDimensionValues(NON_STRING_DICTIONARY_COLUMN_NAME);
        Assert.assertNull((Object)vals);
        ImmutableBitmap valueIndex = this.bitmapIndexSelector.getBitmapIndex(NON_STRING_DICTIONARY_COLUMN_NAME, "foo");
        Assert.assertNull((Object)valueIndex);
        EasyMock.verify((Object[])new Object[]{this.bitmapFactory, this.virtualColumns, this.index});
    }
}

