/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.QueryableIndexCursorSequenceBuilder;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.junit.Assert;
import org.junit.Test;

public class QueryableIndexCursorSequenceBuilderTest {
    @Test
    public void testTimeSearch() {
        final int[] values = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 5, 7, 10};
        NumericColumn column = new NumericColumn(){

            public int length() {
                return values.length;
            }

            public long getLongSingleValueRow(int rowNum) {
                return values[rowNum];
            }

            public void close() {
                throw new UnsupportedOperationException();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                throw new UnsupportedOperationException();
            }

            public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
                throw new UnsupportedOperationException();
            }
        };
        Assert.assertEquals((long)0L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)0L, (int)0, (int)values.length));
        Assert.assertEquals((long)2L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)0L, (int)2, (int)values.length));
        Assert.assertEquals((long)0L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)0L, (int)0, (int)(values.length / 2)));
        Assert.assertEquals((long)1L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)1L, (int)0, (int)values.length));
        Assert.assertEquals((long)2L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)1L, (int)2, (int)values.length));
        Assert.assertEquals((long)1L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)1L, (int)0, (int)(values.length / 2)));
        Assert.assertEquals((long)1L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)1L, (int)1, (int)8));
        Assert.assertEquals((long)8L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)2L, (int)0, (int)values.length));
        Assert.assertEquals((long)10L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)10L, (int)0, (int)values.length));
        Assert.assertEquals((long)11L, (long)QueryableIndexCursorSequenceBuilder.timeSearch((NumericColumn)column, (long)15L, (int)0, (int)values.length));
    }
}

