/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.base.Supplier;
import com.google.common.primitives.Doubles;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.ColumnCapacityExceededException;
import org.apache.druid.segment.data.ColumnarDoubles;
import org.apache.druid.segment.data.ColumnarDoublesSerializer;
import org.apache.druid.segment.data.CompressedColumnarDoublesSuppliers;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.utils.CloseableUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressedDoublesSerdeTest {
    private static final double DELTA = 1.0E-5;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected final CompressionStrategy compressionStrategy;
    protected final ByteOrder order;
    private final double[] values0 = new double[0];
    private final double[] values1 = new double[]{0.0, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0};
    private final double[] values2 = new double[]{13.2, 6.1, 0.001, 123.0, 12572.0, 123.1, 784.4, 6892.8634, 8.341111};
    private final double[] values3 = new double[]{0.001, 0.001, 0.001, 0.001, 0.001, 100.0, 100.0, 100.0, 100.0, 100.0};
    private final double[] values4 = new double[]{0.0, 0.0, 0.0, 0.0, 0.01, 0.0, 0.0, 0.0, 21.22, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final double[] values5 = new double[]{123.16, 1.12, 62.0, 462.12, 517.71, 56.54, 971.32, 824.22, 472.12, 625.26};
    private final double[] values6 = new double[]{1000000.0, 1000001.0, 1000002.0, 1000003.0, 1000004.0, 1000005.0, 1000006.0, 1000007.0, 1000008.0};
    private final double[] values7 = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 12378.5734, -1.27182437496E7, -9.36536531E7, 1.2743153385534E7, 21431.414538, 6.5487435436632125E13, -4.373452623456465E13};

    @Parameterized.Parameters(name="{0} {1} {2}")
    public static Iterable<Object[]> compressionStrategies() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (CompressionStrategy strategy : CompressionStrategy.values()) {
            data.add(new Object[]{strategy, ByteOrder.BIG_ENDIAN});
            data.add(new Object[]{strategy, ByteOrder.LITTLE_ENDIAN});
        }
        return data;
    }

    public CompressedDoublesSerdeTest(CompressionStrategy compressionStrategy, ByteOrder order) {
        this.compressionStrategy = compressionStrategy;
        this.order = order;
    }

    @Test
    public void testValueSerde() throws Exception {
        this.testWithValues(this.values0);
        this.testWithValues(this.values1);
        this.testWithValues(this.values2);
        this.testWithValues(this.values3);
        this.testWithValues(this.values4);
        this.testWithValues(this.values5);
        this.testWithValues(this.values6);
        this.testWithValues(this.values7);
    }

    @Test
    public void testChunkSerde() throws Exception {
        double[] chunk = new double[10000];
        for (int i = 0; i < 10000; ++i) {
            chunk[i] = i;
        }
        this.testWithValues(chunk);
    }

    @Ignore
    @Test
    public void testTooManyValues() throws IOException {
        this.expectedException.expect(ColumnCapacityExceededException.class);
        this.expectedException.expectMessage(ColumnCapacityExceededException.formatMessage((String)"test"));
        try (SegmentWriteOutMedium segmentWriteOutMedium = TmpFileSegmentWriteOutMediumFactory.instance().makeSegmentWriteOutMedium(this.temporaryFolder.newFolder());){
            ColumnarDoublesSerializer serializer = CompressionFactory.getDoubleSerializer((String)"test", (SegmentWriteOutMedium)segmentWriteOutMedium, (String)"test", (ByteOrder)this.order, (CompressionStrategy)this.compressionStrategy);
            serializer.open();
            long numRows = 2147483747L;
            for (long i = 0L; i < 2147483747L; ++i) {
                serializer.add(ThreadLocalRandom.current().nextDouble());
            }
        }
    }

    public void testWithValues(double[] values) throws Exception {
        ColumnarDoublesSerializer serializer = CompressionFactory.getDoubleSerializer((String)"test", (SegmentWriteOutMedium)new OffHeapMemorySegmentWriteOutMedium(), (String)"test", (ByteOrder)this.order, (CompressionStrategy)this.compressionStrategy);
        serializer.open();
        for (double value : values) {
            serializer.add(value);
        }
        Assert.assertEquals((long)values.length, (long)serializer.size());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.writeTo(Channels.newChannel(baos), null);
        Assert.assertEquals((long)baos.size(), (long)serializer.getSerializedSize());
        Supplier supplier = CompressedColumnarDoublesSuppliers.fromByteBuffer((ByteBuffer)ByteBuffer.wrap(baos.toByteArray()), (ByteOrder)this.order);
        ColumnarDoubles doubles = (ColumnarDoubles)supplier.get();
        this.assertIndexMatchesVals(doubles, values);
        for (int i = 0; i < 10; ++i) {
            int b;
            int a = (int)(ThreadLocalRandom.current().nextDouble() * (double)values.length);
            int start = a < (b = (int)(ThreadLocalRandom.current().nextDouble() * (double)values.length)) ? a : b;
            int end = a < b ? b : a;
            this.tryFill(doubles, values, start, end - start);
        }
        this.testConcurrentThreadReads((Supplier<ColumnarDoubles>)supplier, doubles, values);
        doubles.close();
    }

    private void tryFill(ColumnarDoubles indexed, double[] vals, int startIndex, int size) {
        double[] filled = new double[size];
        indexed.get(filled, startIndex, filled.length);
        for (int i = startIndex; i < filled.length; ++i) {
            Assert.assertEquals((double)vals[i + startIndex], (double)filled[i], (double)1.0E-5);
        }
    }

    private void assertIndexMatchesVals(ColumnarDoubles indexed, double[] vals) {
        Assert.assertEquals((long)vals.length, (long)indexed.size());
        int[] indices = new int[vals.length];
        for (int i = 0; i < indexed.size(); ++i) {
            Assert.assertEquals((double)vals[i], (double)indexed.get(i), (double)1.0E-5);
            indices[i] = i;
        }
        IntArrays.shuffle((int[])indices, (Random)ThreadLocalRandom.current());
        int limit = Math.min(indexed.size(), 1000);
        for (int i = 0; i < limit; ++i) {
            int k = indices[i];
            Assert.assertEquals((double)vals[k], (double)indexed.get(k), (double)1.0E-5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConcurrentThreadReads(Supplier<ColumnarDoubles> supplier, final ColumnarDoubles indexed, final double[] vals) throws Exception {
        final AtomicReference<String> reason = new AtomicReference<String>("none");
        int numRuns = 1000;
        final CountDownLatch startLatch = new CountDownLatch(1);
        final CountDownLatch stopLatch = new CountDownLatch(2);
        final AtomicBoolean failureHappened = new AtomicBoolean(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    startLatch.await();
                }
                catch (InterruptedException e) {
                    failureHappened.set(true);
                    reason.set("interrupt.");
                    stopLatch.countDown();
                    return;
                }
                try {
                    for (int i = 0; i < 1000; ++i) {
                        for (int j = 0; j < indexed.size(); ++j) {
                            double val = vals[j];
                            double indexedVal = indexed.get(j);
                            if (Doubles.compare((double)val, (double)indexedVal) == 0) continue;
                            failureHappened.set(true);
                            reason.set(StringUtils.format((String)"Thread1[%d]: %f != %f", (Object[])new Object[]{j, val, indexedVal}));
                            stopLatch.countDown();
                            return;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    failureHappened.set(true);
                    reason.set(e.getMessage());
                }
                stopLatch.countDown();
            }
        }).start();
        final ColumnarDoubles indexed2 = (ColumnarDoubles)supplier.get();
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        stopLatch.countDown();
                        return;
                    }
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            for (int j = indexed2.size() - 1; j >= 0; --j) {
                                double val = vals[j];
                                double indexedVal = indexed2.get(j);
                                if (Doubles.compare((double)val, (double)indexedVal) == 0) continue;
                                failureHappened.set(true);
                                reason.set(StringUtils.format((String)"Thread2[%d]: %f != %f", (Object[])new Object[]{j, val, indexedVal}));
                                stopLatch.countDown();
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        reason.set(e.getMessage());
                        failureHappened.set(true);
                    }
                    stopLatch.countDown();
                }
            }).start();
            startLatch.countDown();
            stopLatch.await();
        }
        finally {
            CloseableUtils.closeAndWrapExceptions((Closeable)indexed2);
        }
        if (failureHappened.get()) {
            Assert.fail((String)("Failure happened.  Reason: " + reason.get()));
        }
    }
}

