/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.query.extraction.DimExtractionFn;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilters;
import org.apache.druid.query.filter.ExtractionDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.serde.StringBitmapIndexColumnPartSupplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExtractionDimFilterTest {
    private static final Map<String, String[]> DIM_VALS = ImmutableMap.of((Object)"foo", (Object)new String[]{"foo1", "foo2", "foo3"}, (Object)"bar", (Object)new String[]{"bar1"}, (Object)"baz", (Object)new String[]{"foo1"});
    private static final Map<String, String> EXTRACTION_VALUES = ImmutableMap.of((Object)"foo1", (Object)"extractDimVal");
    private final BitmapFactory factory;
    private final BitmapSerdeFactory serdeFactory;
    private final ImmutableBitmap foo1BitMap;
    private final BitmapIndexSelector BITMAP_INDEX_SELECTOR = new BitmapIndexSelector(){

        public CloseableIndexed<String> getDimensionValues(String dimension) {
            Object[] vals = (String[])DIM_VALS.get(dimension);
            if (vals == null) {
                return null;
            }
            ListIndexed indexed = new ListIndexed(vals);
            return new CloseableIndexed<String>((Indexed)indexed){
                final /* synthetic */ Indexed val$indexed;
                {
                    this.val$indexed = indexed;
                }

                public int size() {
                    return this.val$indexed.size();
                }

                @Nullable
                public String get(int index) {
                    return (String)this.val$indexed.get(index);
                }

                public int indexOf(@Nullable String value) {
                    return this.val$indexed.indexOf((Object)value);
                }

                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                    inspector.visit("indexed", (HotLoopCallee)this.val$indexed);
                }

                public void close() {
                }

                public Iterator<String> iterator() {
                    return this.val$indexed.iterator();
                }
            };
        }

        public ColumnCapabilities.Capable hasMultipleValues(String dimension) {
            return ColumnCapabilities.Capable.TRUE;
        }

        public int getNumRows() {
            return 1;
        }

        public BitmapFactory getBitmapFactory() {
            return ExtractionDimFilterTest.this.factory;
        }

        public ImmutableBitmap getBitmapIndex(String dimension, String value) {
            return "foo1".equals(value) ? ExtractionDimFilterTest.this.foo1BitMap : null;
        }

        public BitmapIndex getBitmapIndex(String dimension) {
            return new StringBitmapIndexColumnPartSupplier(ExtractionDimFilterTest.this.factory, GenericIndexed.fromIterable(Collections.singletonList(ExtractionDimFilterTest.this.foo1BitMap), (ObjectStrategy)ExtractionDimFilterTest.this.serdeFactory.getObjectStrategy()), GenericIndexed.fromIterable(Collections.singletonList("foo1"), (ObjectStrategy)GenericIndexed.STRING_STRATEGY)).get();
        }

        public ImmutableRTree getSpatialIndex(String dimension) {
            return null;
        }
    };
    private static final ExtractionFn DIM_EXTRACTION_FN = new DimExtractionFn(){

        public byte[] getCacheKey() {
            return new byte[0];
        }

        public String apply(String dimValue) {
            String retval = (String)EXTRACTION_VALUES.get(dimValue);
            return retval == null ? dimValue : retval;
        }

        public boolean preservesOrdering() {
            return false;
        }

        public ExtractionFn.ExtractionType getExtractionType() {
            return ExtractionFn.ExtractionType.MANY_TO_ONE;
        }
    };

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{new ConciseBitmapFactory(), new ConciseBitmapSerdeFactory()}, (Object)new Object[]{new RoaringBitmapFactory(), new RoaringBitmapSerdeFactory(null)});
    }

    public ExtractionDimFilterTest(BitmapFactory bitmapFactory, BitmapSerdeFactory bitmapSerdeFactory) {
        MutableBitmap mutableBitmap = bitmapFactory.makeEmptyMutableBitmap();
        mutableBitmap.add(1);
        this.foo1BitMap = bitmapFactory.makeImmutableBitmap(mutableBitmap);
        this.factory = bitmapFactory;
        this.serdeFactory = bitmapSerdeFactory;
    }

    @Test
    public void testEmpty() {
        Filter extractionFilter = new SelectorDimFilter("foo", "NFDJUKFNDSJFNS", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNull() {
        Filter extractionFilter = new SelectorDimFilter("FDHJSFFHDS", "extractDimVal", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)0L, (long)immutableBitmap.size());
    }

    @Test
    public void testNormal() {
        Filter extractionFilter = new SelectorDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN).toFilter();
        ImmutableBitmap immutableBitmap = extractionFilter.getBitmapIndex(this.BITMAP_INDEX_SELECTOR);
        Assert.assertEquals((long)1L, (long)immutableBitmap.size());
    }

    @Test
    public void testOr() {
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null), new ExtractionDimFilter("foo", "DOES NOT EXIST", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }

    @Test
    public void testAnd() {
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.and((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null), new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }

    @Test
    public void testNot() {
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.or((DimFilter[])new DimFilter[]{new ExtractionDimFilter("foo", "extractDimVal", DIM_EXTRACTION_FN, null)})).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
        Assert.assertEquals((long)1L, (long)Filters.toFilter((DimFilter)DimFilters.not((DimFilter)new ExtractionDimFilter("foo", "DOES NOT EXIST", DIM_EXTRACTION_FN, null))).getBitmapIndex(this.BITMAP_INDEX_SELECTOR).size());
    }
}

