/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.SelectorPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.druid.segment.filter.PredicateValueMatcherFactory;
import org.apache.druid.segment.selector.TestColumnValueSelector;
import org.apache.druid.segment.serde.DictionaryEncodedColumnSupplier;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class PredicateValueMatcherFactoryTest
extends InitializedNullHandlingTest {
    @Test
    public void testDefaultType() {
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)PredicateValueMatcherFactoryTest.forSelector(null).defaultType());
    }

    @Test
    public void testDimensionProcessorSingleValuedDimensionMatchingValue() {
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("0").makeDimensionProcessor(DimensionSelector.constant((String)"0"), false);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testDimensionProcessorSingleValuedDimensionNotMatchingValue() {
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("1").makeDimensionProcessor(DimensionSelector.constant((String)"0"), false);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testDimensionProcessorMultiValuedDimensionMatchingValue() {
        DictionaryEncodedColumnSupplier columnSupplier = new DictionaryEncodedColumnSupplier(GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)"v1", (Object)"v2", (Object)"v3"), (ObjectStrategy)GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v1")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v2")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v3"))), (ObjectStrategy)GenericIndexed.BYTE_BUFFER_STRATEGY), null, () -> VSizeColumnarMultiInts.fromIterable((Iterable)ImmutableList.of((Object)VSizeColumnarInts.fromArray((int[])new int[]{1}))), 0);
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("v2").makeDimensionProcessor(columnSupplier.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), true);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testDimensionProcessorMultiValuedDimensionNotMatchingValue() {
        DictionaryEncodedColumnSupplier columnSupplier = new DictionaryEncodedColumnSupplier(GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)"v1", (Object)"v2", (Object)"v3"), (ObjectStrategy)GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v1")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v2")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"v3"))), (ObjectStrategy)GenericIndexed.BYTE_BUFFER_STRATEGY), null, () -> VSizeColumnarMultiInts.fromIterable((Iterable)ImmutableList.of((Object)VSizeColumnarInts.fromArray((int[])new int[]{1}))), 0);
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("v3").makeDimensionProcessor(columnSupplier.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), true);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testFloatProcessorMatchingValue() {
        TestColumnValueSelector<Float> columnValueSelector = TestColumnValueSelector.of(Float.class, (Collection<Object>)ImmutableList.of((Object)Float.valueOf(2.0f)), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("2.f").makeFloatProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testFloatProcessorNotMatchingValue() {
        TestColumnValueSelector<Float> columnValueSelector = TestColumnValueSelector.of(Float.class, (Collection<Object>)ImmutableList.of((Object)Float.valueOf(2.0f)), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("5.f").makeFloatProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testDoubleProcessorMatchingValue() {
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)2.0), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("2.").makeDoubleProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testDoubleProcessorNotMatchingValue() {
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)2.0), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("5.").makeDoubleProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testLongProcessorMatchingValue() {
        TestColumnValueSelector<Long> columnValueSelector = TestColumnValueSelector.of(Long.class, (Collection<Object>)ImmutableList.of((Object)2L), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("2").makeLongProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testLongProcessorNotMatchingValue() {
        TestColumnValueSelector<Long> columnValueSelector = TestColumnValueSelector.of(Long.class, (Collection<Object>)ImmutableList.of((Object)2L), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("5").makeLongProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingNull() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, Arrays.asList(null, "v"), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector(null).makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorEmptyString() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, Arrays.asList("", "v"), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector(null).makeComplexProcessor(columnValueSelector);
        if (NullHandling.sqlCompatible()) {
            Assert.assertFalse((boolean)matcher.matches());
        } else {
            Assert.assertTrue((boolean)matcher.matches());
        }
    }

    @Test
    public void testComplexProcessorMatchingInteger() {
        TestColumnValueSelector<Integer> columnValueSelector = TestColumnValueSelector.of(Integer.class, (Collection<Object>)ImmutableList.of((Object)11), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorNotMatchingInteger() {
        TestColumnValueSelector<Integer> columnValueSelector = TestColumnValueSelector.of(Integer.class, (Collection<Object>)ImmutableList.of((Object)15), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingLong() {
        TestColumnValueSelector<Long> columnValueSelector = TestColumnValueSelector.of(Long.class, (Collection<Object>)ImmutableList.of((Object)11L), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorNotMatchingLong() {
        TestColumnValueSelector<Long> columnValueSelector = TestColumnValueSelector.of(Long.class, (Collection<Object>)ImmutableList.of((Object)15L), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingFloat() {
        TestColumnValueSelector<Float> columnValueSelector = TestColumnValueSelector.of(Float.class, (Collection<Object>)ImmutableList.of((Object)Float.valueOf(11.0f)), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11.f").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorNotMatchingFloat() {
        TestColumnValueSelector<Float> columnValueSelector = TestColumnValueSelector.of(Float.class, (Collection<Object>)ImmutableList.of((Object)Float.valueOf(15.0f)), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11.f").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingDouble() {
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)11.0), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11.d").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorNotMatchingDouble() {
        TestColumnValueSelector<Double> columnValueSelector = TestColumnValueSelector.of(Double.class, (Collection<Object>)ImmutableList.of((Object)15.0), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("11.d").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingString() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)"val"), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorNotMatchingString() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)"bar"), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingStringList() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)ImmutableList.of((Object)"val")), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorNotMatchingStringList() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)ImmutableList.of((Object)"bar")), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingEmptyList() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)ImmutableList.of()), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector(null).makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingBoolean() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)false), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("false").makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorNotMatchingBoolean() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)true), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("false").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorMatchingByteArray() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)StringUtils.toUtf8((String)"var")), DateTimes.nowUtc());
        columnValueSelector.advance();
        String base64Encoded = StringUtils.encodeBase64String((byte[])StringUtils.toUtf8((String)"var"));
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector(base64Encoded).makeComplexProcessor(columnValueSelector);
        Assert.assertTrue((boolean)matcher.matches());
    }

    @Test
    public void testComplexProcessorNotMatchingByteArray() {
        TestColumnValueSelector<String> columnValueSelector = TestColumnValueSelector.of(String.class, (Collection<Object>)ImmutableList.of((Object)StringUtils.toUtf8((String)"var")), DateTimes.nowUtc());
        columnValueSelector.advance();
        ValueMatcher matcher = PredicateValueMatcherFactoryTest.forSelector("val").makeComplexProcessor(columnValueSelector);
        Assert.assertFalse((boolean)matcher.matches());
    }

    private static PredicateValueMatcherFactory forSelector(@Nullable String value) {
        return new PredicateValueMatcherFactory((DruidPredicateFactory)new SelectorPredicateFactory(value));
    }
}

