/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.generator;

import com.google.common.hash.Hashing;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.druid.segment.BaseProgressIndicator;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.generator.DataGenerator;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class SegmentGenerator
implements Closeable {
    private static final Logger log = new Logger(SegmentGenerator.class);
    private static final int MAX_ROWS_IN_MEMORY = 200000;
    private static final String CACHE_DIR_PROPERTY = "druid.benchmark.cacheDir";
    private static final String CACHE_DIR_ENV_VAR = "DRUID_BENCHMARK_CACHE_DIR";
    private final File cacheDir;
    private final boolean cleanupCacheDir;

    public SegmentGenerator() {
        this(null);
    }

    public SegmentGenerator(@Nullable File cacheDir) {
        if (cacheDir != null) {
            this.cacheDir = cacheDir;
            this.cleanupCacheDir = false;
        } else {
            String userConfiguredCacheDir = System.getProperty(CACHE_DIR_PROPERTY, System.getenv(CACHE_DIR_ENV_VAR));
            if (userConfiguredCacheDir != null) {
                this.cacheDir = new File(userConfiguredCacheDir);
                this.cleanupCacheDir = false;
            } else {
                log.warn("No cache directory provided; benchmark data caching is disabled. Set the 'druid.benchmark.cacheDir' property or 'DRUID_BENCHMARK_CACHE_DIR' environment variable to use caching.", new Object[0]);
                this.cacheDir = FileUtils.createTempDir();
                this.cleanupCacheDir = true;
            }
        }
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public QueryableIndex generate(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, Granularity granularity, int numRows) {
        QueryableIndex retVal;
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        String dataHash = Hashing.sha256().newHasher().putString((CharSequence)dataSegment.getId().toString(), StandardCharsets.UTF_8).putString((CharSequence)schemaInfo.toString(), StandardCharsets.UTF_8).putString((CharSequence)granularity.toString(), StandardCharsets.UTF_8).putInt(numRows).hash().toString();
        File outDir = new File(this.getSegmentDir(dataSegment.getId(), dataHash), "merged");
        if (outDir.exists()) {
            try {
                log.info("Found segment with hash[%s] cached in directory[%s].", new Object[]{dataHash, outDir});
                return TestHelper.getTestIndexIO().loadIndex(outDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        log.info("Writing segment with hash[%s] to directory[%s].", new Object[]{dataHash, outDir});
        DataGenerator dataGenerator = new DataGenerator(schemaInfo.getColumnSchemas(), (long)dataSegment.getId().hashCode(), schemaInfo.getDataInterval(), numRows);
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(schemaInfo.getDimensionsSpec()).withMetrics(schemaInfo.getAggsArray()).withRollup(schemaInfo.isWithRollup()).withQueryGranularity(granularity).build();
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        ArrayList<QueryableIndex> indexes = new ArrayList<QueryableIndex>();
        for (int i = 0; i < numRows; ++i) {
            InputRow row = dataGenerator.nextRow();
            rows.add(row);
            if ((i + 1) % 20000 == 0) {
                log.info("%,d/%,d rows generated for[%s].", new Object[]{i + 1, numRows, dataSegment});
            }
            if (rows.size() % 200000 != 0) continue;
            indexes.add(this.makeIndex(dataSegment.getId(), dataHash, indexes.size(), rows, indexSchema));
            rows.clear();
        }
        log.info("%,d/%,d rows generated for[%s].", new Object[]{numRows, numRows, dataSegment});
        if (rows.size() > 0) {
            indexes.add(this.makeIndex(dataSegment.getId(), dataHash, indexes.size(), rows, indexSchema));
            rows.clear();
        }
        if (indexes.isEmpty()) {
            throw new ISE("No rows to index?", new Object[0]);
        }
        try {
            IndexSpec indexSpec = new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), null, null, null);
            retVal = TestHelper.getTestIndexIO().loadIndex(TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).mergeQueryableIndex(indexes, false, (AggregatorFactory[])schemaInfo.getAggs().stream().map(AggregatorFactory::getCombiningFactory).toArray(AggregatorFactory[]::new), null, outDir, indexSpec, indexSpec, (ProgressIndicator)new BaseProgressIndicator(), null, -1));
            for (QueryableIndex index : indexes) {
                index.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info("Finished writing segment[%s] to[%s]", new Object[]{dataSegment, outDir});
        return retVal;
    }

    public IncrementalIndex generateIncrementalIndex(DataSegment dataSegment, GeneratorSchemaInfo schemaInfo, Granularity granularity, int numRows) {
        ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde());
        String dataHash = Hashing.sha256().newHasher().putString((CharSequence)dataSegment.getId().toString(), StandardCharsets.UTF_8).putString((CharSequence)schemaInfo.toString(), StandardCharsets.UTF_8).putString((CharSequence)granularity.toString(), StandardCharsets.UTF_8).putInt(numRows).hash().toString();
        DataGenerator dataGenerator = new DataGenerator(schemaInfo.getColumnSchemas(), (long)dataSegment.getId().hashCode(), schemaInfo.getDataInterval(), numRows);
        IncrementalIndexSchema indexSchema = new IncrementalIndexSchema.Builder().withDimensionsSpec(schemaInfo.getDimensionsSpec()).withMetrics(schemaInfo.getAggsArray()).withRollup(schemaInfo.isWithRollup()).withQueryGranularity(granularity).build();
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        for (int i = 0; i < numRows; ++i) {
            InputRow row = dataGenerator.nextRow();
            rows.add(row);
            if ((i + 1) % 20000 != 0) continue;
            log.info("%,d/%,d rows generated for[%s].", new Object[]{i + 1, numRows, dataSegment});
        }
        log.info("%,d/%,d rows generated for[%s].", new Object[]{numRows, numRows, dataSegment});
        return this.makeIncrementalIndex(dataSegment.getId(), dataHash, 0, rows, indexSchema);
    }

    @Override
    public void close() throws IOException {
        if (this.cleanupCacheDir) {
            FileUtils.deleteDirectory((File)this.cacheDir);
        }
    }

    private QueryableIndex makeIndex(SegmentId identifier, String dataHash, int indexNumber, List<InputRow> rows, IncrementalIndexSchema indexSchema) {
        return IndexBuilder.create().schema(indexSchema).tmpDir(new File(this.getSegmentDir(identifier, dataHash), String.valueOf(indexNumber))).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).rows(rows).buildMMappedIndex();
    }

    private IncrementalIndex makeIncrementalIndex(SegmentId identifier, String dataHash, int indexNumber, List<InputRow> rows, IncrementalIndexSchema indexSchema) {
        return IndexBuilder.create().schema(indexSchema).tmpDir(new File(this.getSegmentDir(identifier, dataHash), String.valueOf(indexNumber))).segmentWriteOutMediumFactory((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).rows(rows).buildIncrementalIndex();
    }

    private File getSegmentDir(SegmentId identifier, String dataHash) {
        return new File(this.cacheDir, StringUtils.format((String)"%s_%s", (Object[])new Object[]{identifier, dataHash}));
    }

    static {
        NullHandling.initializeForTests();
    }
}

