/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.table;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ConstantDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinMatcher;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.segment.join.table.RowBasedIndexedTable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexedTableJoinableTest {
    private static final String PREFIX = "j.";
    private static final String KEY_COLUMN = "str";
    private static final String VALUE_COLUMN = "long";
    private static final String ALL_SAME_COLUMN = "allsame";
    private static final String UNKNOWN_COLUMN = "unknown";
    private static final String SEARCH_KEY_NULL_VALUE = "baz";
    private static final String SEARCH_KEY_VALUE = "foo";
    private static final String SEARCH_VALUE_VALUE = "1";
    private static final String SEARCH_VALUE_UNKNOWN = "10";
    private static final long MAX_CORRELATION_SET_SIZE = 10000L;
    private final ColumnSelectorFactory dummyColumnSelectorFactory = new ColumnSelectorFactory(){

        public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
            return new ConstantDimensionSelector("dummy");
        }

        public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
            return null;
        }

        public ColumnCapabilities getColumnCapabilities(String columnName) {
            return null;
        }
    };
    private final InlineDataSource inlineDataSource = InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"foo", 1L, 1L}, (Object)new Object[]{"bar", 2L, 1L}, (Object)new Object[]{"baz", null, 1L}), (RowSignature)RowSignature.builder().add("str", ColumnType.STRING).add("long", ColumnType.LONG).add("allsame", ColumnType.LONG).build());
    private final RowBasedIndexedTable<Object[]> indexedTable = new RowBasedIndexedTable(this.inlineDataSource.getRowsAsList(), this.inlineDataSource.rowAdapter(), this.inlineDataSource.getRowSignature(), (Set)ImmutableSet.of((Object)"str"), DateTimes.nowUtc().toString());
    private IndexedTableJoinable target;

    @Before
    public void setUp() {
        this.target = new IndexedTableJoinable(this.indexedTable);
    }

    @Test
    public void getAvailableColumns() {
        Assert.assertEquals((Object)ImmutableList.of((Object)KEY_COLUMN, (Object)VALUE_COLUMN, (Object)ALL_SAME_COLUMN), (Object)this.target.getAvailableColumns());
    }

    @Test
    public void getCardinalityForStringColumn() {
        Assert.assertEquals((long)(this.indexedTable.numRows() + 1), (long)this.target.getCardinality(KEY_COLUMN));
    }

    @Test
    public void getCardinalityForLongColumn() {
        Assert.assertEquals((long)(this.indexedTable.numRows() + 1), (long)this.target.getCardinality(VALUE_COLUMN));
    }

    @Test
    public void getCardinalityForNonexistentColumn() {
        Assert.assertEquals((long)1L, (long)this.target.getCardinality("nonexistent"));
    }

    @Test
    public void getColumnCapabilitiesForStringColumn() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities(KEY_COLUMN);
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)capabilities.hasBitmapIndexes());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)capabilities.hasSpatialIndexes());
    }

    @Test
    public void getColumnCapabilitiesForLongColumn() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities(VALUE_COLUMN);
        Assert.assertEquals((Object)ValueType.LONG, (Object)capabilities.getType());
        Assert.assertFalse((boolean)capabilities.isDictionaryEncoded().isTrue());
        Assert.assertFalse((boolean)capabilities.hasBitmapIndexes());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isMaybeTrue());
        Assert.assertFalse((boolean)capabilities.hasSpatialIndexes());
    }

    @Test
    public void getColumnCapabilitiesForNonexistentColumnShouldReturnNull() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities("nonexistent");
        Assert.assertNull((Object)capabilities);
    }

    @Test
    public void makeJoinMatcherWithDimensionSelectorOnString() {
        JoinConditionAnalysis condition = JoinConditionAnalysis.forExpression((String)"x == \"j.str\"", (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
        JoinMatcher joinMatcher = this.target.makeJoinMatcher(this.dummyColumnSelectorFactory, condition, false, false, Closer.create());
        DimensionSelector selector = joinMatcher.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)KEY_COLUMN));
        Assert.assertEquals((long)4L, (long)selector.getValueCardinality());
        Assert.assertTrue((boolean)selector.nameLookupPossibleInAdvance());
        Assert.assertEquals((Object)SEARCH_KEY_VALUE, (Object)selector.lookupName(0));
        Assert.assertEquals((Object)"bar", (Object)selector.lookupName(1));
        Assert.assertEquals((Object)SEARCH_KEY_NULL_VALUE, (Object)selector.lookupName(2));
        Assert.assertNull((Object)selector.lookupName(3));
        Assert.assertNull((Object)selector.idLookup());
    }

    @Test
    public void getCorrelatedColummnValuesMissingSearchColumnShouldReturnEmpty() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(UNKNOWN_COLUMN, SEARCH_KEY_VALUE, VALUE_COLUMN, 10000L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColummnValuesMissingRetrievalColumnShouldReturnEmpty() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(KEY_COLUMN, SEARCH_KEY_VALUE, UNKNOWN_COLUMN, 10000L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyAndRetrieveKeyColumnShouldReturnSearchValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(KEY_COLUMN, SEARCH_KEY_VALUE, KEY_COLUMN, 10000L, false);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_KEY_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyAndRetrieveKeyColumnAboveLimitShouldReturnEmpty() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(KEY_COLUMN, SEARCH_KEY_VALUE, KEY_COLUMN, 0L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyAndRetrieveValueColumnShouldReturnExtractedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(KEY_COLUMN, SEARCH_KEY_VALUE, VALUE_COLUMN, 10000L, false);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_VALUE_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyMissingAndRetrieveValueColumnShouldReturnExtractedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(KEY_COLUMN, SEARCH_KEY_NULL_VALUE, VALUE_COLUMN, 10000L, false);
        Assert.assertEquals(Optional.of(Collections.singleton(null)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveValueColumnAndNonKeyColumnSearchDisabledShouldReturnEmpty() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(VALUE_COLUMN, SEARCH_VALUE_VALUE, VALUE_COLUMN, 10000L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
        correlatedValues = this.target.getCorrelatedColumnValues(VALUE_COLUMN, SEARCH_VALUE_VALUE, KEY_COLUMN, 10L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveValueColumnShouldReturnSearchValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(VALUE_COLUMN, SEARCH_VALUE_VALUE, VALUE_COLUMN, 10000L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_VALUE_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveKeyColumnShouldReturnUnAppliedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(VALUE_COLUMN, SEARCH_VALUE_VALUE, KEY_COLUMN, 10L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_KEY_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveKeyColumnWithMaxLimitSetShouldHonorMaxLimit() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(VALUE_COLUMN, SEARCH_VALUE_VALUE, KEY_COLUMN, 0L, true);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchUnknownValueAndRetrieveKeyColumnShouldReturnNoCorrelatedValues() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(VALUE_COLUMN, SEARCH_VALUE_UNKNOWN, KEY_COLUMN, 10L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of()), (Object)correlatedValues);
    }

    @Test
    public void getNonNullColumnValuesIfAllUniqueForValueColumnShouldReturnValues() {
        Optional values = this.target.getNonNullColumnValuesIfAllUnique(VALUE_COLUMN, Integer.MAX_VALUE);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_VALUE_VALUE, (Object)"2")), (Object)values);
    }

    @Test
    public void getNonNullColumnValuesIfAllUniqueForNonexistentColumnShouldReturnEmpty() {
        Optional values = this.target.getNonNullColumnValuesIfAllUnique("nonexistent", Integer.MAX_VALUE);
        Assert.assertEquals(Optional.empty(), (Object)values);
    }

    @Test
    public void getNonNullColumnValuesIfAllUniqueForKeyColumnShouldReturnValues() {
        Optional values = this.target.getNonNullColumnValuesIfAllUnique(KEY_COLUMN, Integer.MAX_VALUE);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_KEY_VALUE, (Object)"bar", (Object)SEARCH_KEY_NULL_VALUE)), (Object)values);
    }

    @Test
    public void getNonNullColumnValuesIfAllUniqueForAllSameColumnShouldReturnEmpty() {
        Optional values = this.target.getNonNullColumnValuesIfAllUnique(ALL_SAME_COLUMN, Integer.MAX_VALUE);
        Assert.assertEquals(Optional.empty(), (Object)values);
    }

    @Test
    public void getNonNullColumnValuesIfAllUniqueForKeyColumnWithLowMaxValuesShouldReturnEmpty() {
        Optional values = this.target.getNonNullColumnValuesIfAllUnique(KEY_COLUMN, 1);
        Assert.assertEquals(Optional.empty(), (Object)values);
    }

    static {
        NullHandling.initializeForTests();
    }
}

