/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.nio.ByteBuffer;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.druid.segment.serde.ColumnPartSerde;
import org.apache.druid.segment.serde.NullColumnPartSerde;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class NullColumnPartSerdeTest
extends InitializedNullHandlingTest {
    @Test
    public void testSerde() throws JsonProcessingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)new RoaringBitmapSerdeFactory(null));
        String json = mapper.writeValueAsString((Object)partSerde);
        Assert.assertEquals((Object)partSerde, (Object)mapper.readValue(json, ColumnPartSerde.class));
    }

    @Test
    public void testDeserializer() {
        NullColumnPartSerde partSerde = new NullColumnPartSerde(10, (BitmapSerdeFactory)new RoaringBitmapSerdeFactory(null));
        ColumnBuilder builder = new ColumnBuilder().setType(ValueType.DOUBLE);
        partSerde.getDeserializer().read((ByteBuffer)Mockito.mock(ByteBuffer.class), builder, (ColumnConfig)Mockito.mock(ColumnConfig.class));
        ColumnCapabilities columnCapabilities = builder.build().getCapabilities();
        Assert.assertTrue((boolean)columnCapabilities.hasNulls().isTrue());
        Assert.assertTrue((boolean)columnCapabilities.hasMultipleValues().isFalse());
        Assert.assertTrue((boolean)columnCapabilities.isFilterable());
        Assert.assertTrue((boolean)columnCapabilities.hasBitmapIndexes());
        Assert.assertTrue((boolean)columnCapabilities.isDictionaryEncoded().isTrue());
        Assert.assertTrue((boolean)columnCapabilities.areDictionaryValuesSorted().isTrue());
        Assert.assertTrue((boolean)columnCapabilities.areDictionaryValuesUnique().isTrue());
    }
}

