/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.segment.virtual.VirtualizedColumnSelectorFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class VirtualizedColumnSelectorFactoryTest
extends InitializedNullHandlingTest {
    private final VirtualizedColumnSelectorFactory selectorFactory = new VirtualizedColumnSelectorFactory((ColumnSelectorFactory)RowBasedColumnSelectorFactory.create((RowAdapter)RowAdapters.standardRow(), () -> new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"x", (Object)10L, (Object)"y", (Object)20.0)), (ColumnInspector)RowSignature.builder().add("x", ColumnType.LONG).add("y", ColumnType.DOUBLE).build(), (boolean)false), VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("v0", "x + 1", null, ExprMacroTable.nil()), (Object)new ExpressionVirtualColumn("v1", "v0 + y", null, ExprMacroTable.nil()))));

    @Test
    public void test_getColumnCapabilities_type() {
        Assert.assertEquals((Object)ValueType.LONG, (Object)this.selectorFactory.getColumnCapabilities("x").getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)this.selectorFactory.getColumnCapabilities("y").getType());
        Assert.assertEquals((Object)ValueType.LONG, (Object)this.selectorFactory.getColumnCapabilities("v0").getType());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)this.selectorFactory.getColumnCapabilities("v1").getType());
        Assert.assertNull((Object)this.selectorFactory.getColumnCapabilities("nonexistent"));
    }

    @Test
    public void test_makeColumnValueSelector() {
        Assert.assertEquals((long)10L, (long)this.selectorFactory.makeColumnValueSelector("x").getLong());
        Assert.assertEquals((double)20.0, (double)this.selectorFactory.makeColumnValueSelector("y").getDouble(), (double)0.0);
        Assert.assertEquals((long)11L, (long)this.selectorFactory.makeColumnValueSelector("v0").getLong());
        Assert.assertEquals((double)31.0, (double)this.selectorFactory.makeColumnValueSelector("v1").getDouble(), (double)0.0);
        Assert.assertEquals((Object)10L, (Object)this.selectorFactory.makeColumnValueSelector("x").getObject());
        Assert.assertEquals((Object)20.0, (Object)this.selectorFactory.makeColumnValueSelector("y").getObject());
        Assert.assertEquals((Object)11L, (Object)this.selectorFactory.makeColumnValueSelector("v0").getObject());
        Assert.assertEquals((Object)31.0, (Object)this.selectorFactory.makeColumnValueSelector("v1").getObject());
        Assert.assertNull((Object)this.selectorFactory.makeColumnValueSelector("nonexistent").getObject());
    }

    @Test
    public void test_makeDimensionSelector() {
        Assert.assertEquals((Object)"10", (Object)this.selectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"x")).getObject());
        Assert.assertEquals((Object)"20.0", (Object)this.selectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"y")).getObject());
        Assert.assertEquals((Object)"11", (Object)this.selectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"v0")).getObject());
        Assert.assertEquals((Object)"31.0", (Object)this.selectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"v1")).getObject());
        Assert.assertNull((Object)this.selectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"nonexistent")).getObject());
    }
}

