/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Numbers;

public class QueryContext {
    private final Map<String, Object> defaultParams = new TreeMap<String, Object>();
    private final Map<String, Object> userParams;
    private final Map<String, Object> systemParams;
    @Nullable
    private Map<String, Object> mergedParams;

    public QueryContext() {
        this(null);
    }

    public QueryContext(@Nullable Map<String, Object> userParams) {
        this.userParams = userParams == null ? new TreeMap<String, Object>() : new TreeMap<String, Object>(userParams);
        this.systemParams = new TreeMap<String, Object>();
        this.invalidateMergedParams();
    }

    private void invalidateMergedParams() {
        this.mergedParams = null;
    }

    public boolean isEmpty() {
        return this.defaultParams.isEmpty() && this.userParams.isEmpty() && this.systemParams.isEmpty();
    }

    public void addDefaultParam(String key, Object val) {
        this.invalidateMergedParams();
        this.defaultParams.put(key, val);
    }

    public void addDefaultParams(Map<String, Object> defaultParams) {
        this.invalidateMergedParams();
        this.defaultParams.putAll(defaultParams);
    }

    public void addSystemParam(String key, Object val) {
        this.invalidateMergedParams();
        this.systemParams.put(key, val);
    }

    public Object removeUserParam(String key) {
        this.invalidateMergedParams();
        return this.userParams.remove(key);
    }

    public Map<String, Object> getUserParams() {
        return this.userParams;
    }

    public boolean isDebug() {
        return this.getAsBoolean("debug", false);
    }

    public boolean isEnableJoinLeftScanDirect() {
        return this.getAsBoolean("enableJoinLeftTableScanDirect", false);
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    @Nullable
    public Object get(String key) {
        Object val = this.systemParams.get(key);
        if (val != null) {
            return val;
        }
        val = this.userParams.get(key);
        return val == null ? this.defaultParams.get(key) : val;
    }

    public Object getOrDefault(String key, Object defaultValue) {
        Object val = this.get(key);
        return val == null ? defaultValue : val;
    }

    @Nullable
    public String getAsString(String key) {
        return (String)this.get(key);
    }

    public boolean getAsBoolean(String parameter, boolean defaultValue) {
        Object value = this.get(parameter);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IAE("Expected parameter[%s] to be boolean", new Object[]{parameter});
    }

    public int getAsInt(String parameter, int defaultValue) {
        Object value = this.get(parameter);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Numbers.parseInt((Object)value);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new IAE("Expected parameter[%s] to be integer", new Object[]{parameter});
    }

    public long getAsLong(String parameter, long defaultValue) {
        Object value = this.get(parameter);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Numbers.parseLong((Object)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new IAE("Expected parameter[%s] to be long", new Object[]{parameter});
    }

    public Map<String, Object> getMergedParams() {
        if (this.mergedParams == null) {
            TreeMap<String, Object> merged = new TreeMap<String, Object>(this.defaultParams);
            merged.putAll(this.userParams);
            merged.putAll(this.systemParams);
            this.mergedParams = Collections.unmodifiableMap(merged);
        }
        return this.mergedParams;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryContext context = (QueryContext)o;
        return this.getMergedParams().equals(context.getMergedParams());
    }

    public int hashCode() {
        return Objects.hash(this.getMergedParams());
    }

    public String toString() {
        return "QueryContext{defaultParams=" + this.defaultParams + ", userParams=" + this.userParams + ", systemParams=" + this.systemParams + '}';
    }
}

