/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.any;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.any.StringAnyAggregator;
import org.apache.druid.query.aggregation.any.StringAnyBufferAggregator;
import org.apache.druid.query.aggregation.any.StringAnyVectorAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class StringAnyAggregatorFactory
extends AggregatorFactory {
    private static final Comparator<String> VALUE_COMPARATOR = Comparator.nullsFirst(Comparator.naturalOrder());
    private final String fieldName;
    private final String name;
    protected final int maxStringBytes;

    @JsonCreator
    public StringAnyAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="maxStringBytes") Integer maxStringBytes) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        if (maxStringBytes != null && maxStringBytes < 0) {
            throw new IAE("maxStringBytes must be greater than 0", new Object[0]);
        }
        this.name = name;
        this.fieldName = fieldName;
        this.maxStringBytes = maxStringBytes == null ? 1024 : maxStringBytes;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new StringAnyAggregator(metricFactory.makeColumnValueSelector(this.fieldName), this.maxStringBytes);
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new StringAnyBufferAggregator(metricFactory.makeColumnValueSelector(this.fieldName), this.maxStringBytes);
    }

    @Override
    public StringAnyVectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        ColumnCapabilities capabilities = selectorFactory.getColumnCapabilities(this.fieldName);
        if (capabilities != null && capabilities.hasMultipleValues().isMaybeTrue()) {
            return new StringAnyVectorAggregator(null, selectorFactory.makeMultiValueDimensionSelector(DefaultDimensionSpec.of(this.fieldName)), this.maxStringBytes);
        }
        return new StringAnyVectorAggregator(selectorFactory.makeSingleValueDimensionSelector(DefaultDimensionSpec.of(this.fieldName)), null, this.maxStringBytes);
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return lhs;
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new StringAnyAggregatorFactory(this.name, this.name, this.maxStringBytes);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Collections.singletonList(new StringAnyAggregatorFactory(this.fieldName, this.fieldName, this.maxStringBytes));
    }

    @Override
    public Object deserialize(Object object) {
        return object;
    }

    @Override
    public Object finalizeComputation(@Nullable Object object) {
        return object;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public Integer getMaxStringBytes() {
        return this.maxStringBytes;
    }

    @Override
    public List<String> requiredFields() {
        return Collections.singletonList(this.fieldName);
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(69).appendString(this.fieldName).appendInt(this.maxStringBytes).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return ColumnType.STRING;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.STRING;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 4 + this.maxStringBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringAnyAggregatorFactory that = (StringAnyAggregatorFactory)o;
        return this.maxStringBytes == that.maxStringBytes && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name, this.maxStringBytes);
    }

    public String toString() {
        return "StringAnyAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", name='" + this.name + '\'' + ", maxStringBytes=" + this.maxStringBytes + '}';
    }
}

