/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.google.common.base.Predicate;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;

final class PredicateFilteredDimensionSelector
extends AbstractDimensionSelector {
    private final DimensionSelector selector;
    private final Predicate<String> predicate;
    private final ArrayBasedIndexedInts row = new ArrayBasedIndexedInts();

    PredicateFilteredDimensionSelector(DimensionSelector selector, Predicate<String> predicate) {
        this.selector = selector;
        this.predicate = predicate;
    }

    @Override
    public IndexedInts getRow() {
        IndexedInts baseRow = this.selector.getRow();
        int baseRowSize = baseRow.size();
        this.row.ensureSize(baseRowSize);
        int resultSize = 0;
        for (int i = 0; i < baseRowSize; ++i) {
            int id = baseRow.get(i);
            if (!this.predicate.apply((Object)this.selector.lookupName(id))) continue;
            this.row.setValue(resultSize, id);
            ++resultSize;
        }
        this.row.setSize(resultSize);
        return this.row;
    }

    @Override
    public ValueMatcher makeValueMatcher(final String value) {
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts baseRow = PredicateFilteredDimensionSelector.this.selector.getRow();
                int baseRowSize = baseRow.size();
                boolean nullRow = true;
                for (int i = 0; i < baseRowSize; ++i) {
                    String rowValue = PredicateFilteredDimensionSelector.this.lookupName(baseRow.get(i));
                    if (!PredicateFilteredDimensionSelector.this.predicate.apply((Object)rowValue)) continue;
                    if (Objects.equals(rowValue, value)) {
                        return true;
                    }
                    nullRow = false;
                }
                return nullRow && value == null;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", PredicateFilteredDimensionSelector.this);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final Predicate<String> matcherPredicate) {
        final boolean matchNull = this.predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts baseRow = PredicateFilteredDimensionSelector.this.selector.getRow();
                int baseRowSize = baseRow.size();
                boolean nullRow = true;
                for (int i = 0; i < baseRowSize; ++i) {
                    String rowValue = PredicateFilteredDimensionSelector.this.lookupName(baseRow.get(i));
                    if (!PredicateFilteredDimensionSelector.this.predicate.apply((Object)rowValue)) continue;
                    if (matcherPredicate.apply((Object)rowValue)) {
                        return true;
                    }
                    nullRow = false;
                }
                return nullRow && matchNull;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", PredicateFilteredDimensionSelector.this);
                inspector.visit("matcherPredicate", matcherPredicate);
            }
        };
    }

    @Override
    public int getValueCardinality() {
        return this.selector.getValueCardinality();
    }

    @Override
    public String lookupName(int id) {
        return this.selector.lookupName(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return this.selector.nameLookupPossibleInAdvance();
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this.selector.idLookup();
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
        inspector.visit("predicate", this.predicate);
    }
}

