/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.cardinality.CardinalityAggregator;
import org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;

public class HyperUniqueExpressions {
    public static final ExpressionType TYPE = ExpressionType.fromColumnType((TypeSignature)HyperUniquesAggregatorFactory.TYPE);

    public static class HllRoundEstimateExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "hyper_unique_round_estimate";

        public String name() {
            return NAME;
        }

        public Expr apply(final List<Expr> args) {
            if (args.size() != 1) {
                throw new IAE("Function[%s] must have 1 argument", new Object[]{this.name()});
            }
            class HllExpr
            extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
                public HllExpr(Expr arg) {
                    super(HllRoundEstimateExprMacro.NAME, arg);
                }

                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval hllCollector = ((Expr)args.get(0)).eval(bindings);
                    if (!hllCollector.type().equals((Object)TYPE)) {
                        throw new IAE("Function[%s] must take a hyper-log-log collector as input", new Object[]{HllRoundEstimateExprMacro.NAME});
                    }
                    HyperLogLogCollector collector = (HyperLogLogCollector)hllCollector.value();
                    assert (collector != null);
                    return ExprEval.ofLong((Number)collector.estimateCardinalityRound());
                }

                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit(HllRoundEstimateExprMacro.this.apply(shuttle.visitAll(args)));
                }

                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.LONG;
                }
            }
            return new HllExpr(args.get(0));
        }
    }

    public static class HllEstimateExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String NAME = "hyper_unique_estimate";

        public String name() {
            return NAME;
        }

        public Expr apply(final List<Expr> args) {
            if (args.size() != 1) {
                throw new IAE("Function[%s] must have 1 argument", new Object[]{this.name()});
            }
            class HllExpr
            extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
                public HllExpr(Expr arg) {
                    super(HllEstimateExprMacro.NAME, arg);
                }

                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval hllCollector = ((Expr)args.get(0)).eval(bindings);
                    if (!(TYPE.equals((Object)hllCollector.type()) && hllCollector.type().is((TypeDescriptor)ExprType.COMPLEX) && hllCollector.value() instanceof HyperLogLogCollector)) {
                        throw new IAE("Function[%s] must take a hyper-log-log collector as input", new Object[]{HllEstimateExprMacro.NAME});
                    }
                    HyperLogLogCollector collector = (HyperLogLogCollector)hllCollector.value();
                    assert (collector != null);
                    return ExprEval.ofDouble((Number)collector.estimateCardinality());
                }

                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit(HllEstimateExprMacro.this.apply(shuttle.visitAll(args)));
                }

                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.DOUBLE;
                }
            }
            return new HllExpr(args.get(0));
        }
    }

    public static class HllAddExprMacro
    implements ExprMacroTable.ExprMacro {
        private static final String NAME = "hyper_unique_add";

        public String name() {
            return NAME;
        }

        public Expr apply(List<Expr> args) {
            if (args.size() != 2) {
                throw new IAE("Function[%s] must have 2 arguments", new Object[]{this.name()});
            }
            class HllExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public HllExpr(List<Expr> args) {
                    super(HllAddExprMacro.NAME, args);
                }

                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval hllCollector = ((Expr)this.args.get(1)).eval(bindings);
                    ExpressionType hllType = hllCollector.type();
                    if (!(TYPE.equals((Object)hllType) && hllType.is((TypeDescriptor)ExprType.COMPLEX) && hllCollector.value() instanceof HyperLogLogCollector)) {
                        throw new IAE("Function[%s] must take a hyper-log-log collector as the second argument", new Object[]{HllAddExprMacro.NAME});
                    }
                    HyperLogLogCollector collector = (HyperLogLogCollector)hllCollector.value();
                    assert (collector != null);
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    switch ((ExprType)input.type().getType()) {
                        case STRING: {
                            if (input.value() == null) {
                                if (!NullHandling.replaceWithDefault()) break;
                                collector.add(CardinalityAggregator.HASH_FUNCTION.hashUnencodedChars((CharSequence)"\u0000").asBytes());
                                break;
                            }
                            collector.add(CardinalityAggregator.HASH_FUNCTION.hashUnencodedChars((CharSequence)input.asString()).asBytes());
                            break;
                        }
                        case DOUBLE: {
                            if (!NullHandling.replaceWithDefault() && input.isNumericNull()) break;
                            collector.add(CardinalityAggregator.HASH_FUNCTION.hashLong(Double.doubleToLongBits(input.asDouble())).asBytes());
                            break;
                        }
                        case LONG: {
                            if (!NullHandling.replaceWithDefault() && input.isNumericNull()) break;
                            collector.add(CardinalityAggregator.HASH_FUNCTION.hashLong(input.asLong()).asBytes());
                            break;
                        }
                        case COMPLEX: {
                            if (TYPE.equals((Object)input.type()) || hllType.is((TypeDescriptor)ExprType.COMPLEX) && hllCollector.value() instanceof HyperLogLogCollector) {
                                collector.fold((HyperLogLogCollector)input.value());
                                break;
                            }
                        }
                        default: {
                            throw new IAE("Function[%s] cannot add [%s] to hyper-log-log collector", new Object[]{HllAddExprMacro.NAME, input.type()});
                        }
                    }
                    return ExprEval.ofComplex((ExpressionType)TYPE, (Object)collector);
                }

                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit(HllAddExprMacro.this.apply(shuttle.visitAll(this.args)));
                }

                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return TYPE;
                }
            }
            return new HllExpr(args);
        }
    }

    public static class HllCreateExprMacro
    implements ExprMacroTable.ExprMacro {
        private static final String NAME = "hyper_unique";

        public String name() {
            return NAME;
        }

        public Expr apply(List<Expr> args) {
            if (args.size() > 0) {
                throw new IAE("Function[%s] must have no arguments", new Object[]{this.name()});
            }
            final HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
            class HllExpression
            implements ExprMacroTable.ExprMacroFunctionExpr {
                HllExpression() {
                }

                public ExprEval eval(Expr.ObjectBinding bindings) {
                    return ExprEval.ofComplex((ExpressionType)TYPE, (Object)collector);
                }

                public String stringify() {
                    return StringUtils.format((String)"%s()", (Object[])new Object[]{HllCreateExprMacro.NAME});
                }

                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit((Expr)this);
                }

                public Expr.BindingAnalysis analyzeInputs() {
                    return Expr.BindingAnalysis.EMTPY;
                }

                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return TYPE;
                }

                public List<Expr> getArgs() {
                    return Collections.emptyList();
                }

                public int hashCode() {
                    return Objects.hashCode(HllCreateExprMacro.NAME);
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    return obj != null && this.getClass() == obj.getClass();
                }

                public String toString() {
                    return StringUtils.format((String)"(%s)", (Object[])new Object[]{HllCreateExprMacro.NAME});
                }
            }
            return new HllExpression();
        }
    }
}

