/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.ExprUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimestampFormatExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_format";

    public String name() {
        return FN_NAME;
    }

    public Expr apply(final List<Expr> args) {
        String formatString;
        if (args.size() < 1 || args.size() > 3) {
            throw new IAE("Function[%s] must have 1 to 3 arguments", new Object[]{this.name()});
        }
        Expr arg = args.get(0);
        if (args.size() > 1) {
            Preconditions.checkArgument((boolean)args.get(1).isLiteral(), (String)"Function[%s] format arg must be a literal", (Object[])new Object[]{this.name()});
            formatString = (String)args.get(1).getLiteralValue();
        } else {
            formatString = null;
        }
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        final DateTimeFormatter formatter = formatString == null ? ISODateTimeFormat.dateTime().withZone(timeZone) : DateTimeFormat.forPattern(formatString).withZone(timeZone);
        class TimestampFormatExpr
        extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
            TimestampFormatExpr(Expr arg) {
                super(TimestampFormatExprMacro.FN_NAME, arg);
            }

            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = this.arg.eval(bindings);
                if (eval.isNumericNull()) {
                    return ExprEval.of(null);
                }
                return ExprEval.of((String)formatter.print(this.arg.eval(bindings).asLong()));
            }

            public Expr visit(Expr.Shuttle shuttle) {
                return shuttle.visit(TimestampFormatExprMacro.this.apply(shuttle.visitAll(args)));
            }

            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.STRING;
            }

            public String stringify() {
                if (args.size() > 2) {
                    return StringUtils.format((String)"%s(%s, %s, %s)", (Object[])new Object[]{TimestampFormatExprMacro.FN_NAME, this.arg.stringify(), ((Expr)args.get(1)).stringify(), ((Expr)args.get(2)).stringify()});
                }
                if (args.size() > 1) {
                    return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{TimestampFormatExprMacro.FN_NAME, this.arg.stringify(), ((Expr)args.get(1)).stringify()});
                }
                return super.stringify();
            }
        }
        return new TimestampFormatExpr(arg);
    }
}

