/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;

public abstract class TrimExprMacro
implements ExprMacroTable.ExprMacro {
    private static final char[] EMPTY_CHARS = new char[0];
    private static final char[] DEFAULT_CHARS = new char[]{' '};
    private final TrimMode mode;

    public TrimExprMacro(TrimMode mode) {
        this.mode = mode;
    }

    public String name() {
        return this.mode.getFnName();
    }

    public Expr apply(List<Expr> args) {
        if (args.size() < 1 || args.size() > 2) {
            throw new IAE("Function[%s] must have 1 or 2 arguments", new Object[]{this.name()});
        }
        Function<Expr.Shuttle, Expr> visitFn = shuttle -> shuttle.visit(this.apply(shuttle.visitAll(args)));
        if (args.size() == 1) {
            return new TrimStaticCharsExpr(this.mode, args.get(0), DEFAULT_CHARS, null, visitFn);
        }
        Expr charsArg = args.get(1);
        if (charsArg.isLiteral()) {
            String charsString = charsArg.eval(InputBindings.nilBindings()).asString();
            char[] chars = charsString == null ? EMPTY_CHARS : charsString.toCharArray();
            return new TrimStaticCharsExpr(this.mode, args.get(0), chars, charsArg, visitFn);
        }
        return new TrimDynamicCharsExpr(this.mode, args.get(0), args.get(1), visitFn);
    }

    private static boolean arrayContains(char[] array, char c) {
        for (char arrayChar : array) {
            if (arrayChar != c) continue;
            return true;
        }
        return false;
    }

    private static boolean stringContains(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public static class RightTrimExprMacro
    extends TrimExprMacro {
        public RightTrimExprMacro() {
            super(TrimMode.RIGHT);
        }
    }

    public static class LeftTrimExprMacro
    extends TrimExprMacro {
        public LeftTrimExprMacro() {
            super(TrimMode.LEFT);
        }
    }

    public static class BothTrimExprMacro
    extends TrimExprMacro {
        public BothTrimExprMacro() {
            super(TrimMode.BOTH);
        }
    }

    @VisibleForTesting
    static class TrimDynamicCharsExpr
    implements Expr {
        private final TrimMode mode;
        private final Expr stringExpr;
        private final Expr charsExpr;
        private final Function<Expr.Shuttle, Expr> visitFn;

        public TrimDynamicCharsExpr(TrimMode mode, Expr stringExpr, Expr charsExpr, Function<Expr.Shuttle, Expr> visitFn) {
            this.mode = mode;
            this.stringExpr = stringExpr;
            this.charsExpr = charsExpr;
            this.visitFn = visitFn;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            int start;
            ExprEval stringEval = this.stringExpr.eval(bindings);
            if (stringEval.value() == null) {
                return stringEval;
            }
            ExprEval charsEval = this.charsExpr.eval(bindings);
            if (charsEval.value() == null) {
                return stringEval;
            }
            String s = stringEval.asString();
            String chars = charsEval.asString();
            int end = s.length();
            if (this.mode.isLeft()) {
                for (start = 0; start < s.length() && TrimExprMacro.stringContains(chars, s.charAt(start)); ++start) {
                }
            }
            if (this.mode.isRight()) {
                while (end > start && TrimExprMacro.stringContains(chars, s.charAt(end - 1))) {
                    --end;
                }
            }
            if (start == 0 && end == s.length()) {
                return stringEval;
            }
            return ExprEval.of((String)s.substring(start, end));
        }

        public String stringify() {
            return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{this.mode.getFnName(), this.stringExpr.stringify(), this.charsExpr.stringify()});
        }

        public Expr visit(Expr.Shuttle shuttle) {
            return this.visitFn.apply(shuttle);
        }

        public Expr.BindingAnalysis analyzeInputs() {
            return this.stringExpr.analyzeInputs().with(this.charsExpr).withScalarArguments((Set)ImmutableSet.of((Object)this.stringExpr, (Object)this.charsExpr));
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.STRING;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrimDynamicCharsExpr that = (TrimDynamicCharsExpr)o;
            return this.mode == that.mode && Objects.equals(this.stringExpr, that.stringExpr) && Objects.equals(this.charsExpr, that.charsExpr);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mode, this.stringExpr, this.charsExpr});
        }
    }

    @VisibleForTesting
    static class TrimStaticCharsExpr
    extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
        private final TrimMode mode;
        private final char[] chars;
        private final Expr charsExpr;
        private final Function<Expr.Shuttle, Expr> visitFn;

        public TrimStaticCharsExpr(TrimMode mode, Expr stringExpr, char[] chars, Expr charsExpr, Function<Expr.Shuttle, Expr> visitFn) {
            super(mode.getFnName(), stringExpr);
            this.mode = mode;
            this.chars = chars;
            this.charsExpr = charsExpr;
            this.visitFn = visitFn;
        }

        @Nonnull
        public ExprEval eval(Expr.ObjectBinding bindings) {
            int start;
            ExprEval stringEval = this.arg.eval(bindings);
            if (this.chars.length == 0 || stringEval.value() == null) {
                return stringEval;
            }
            String s = stringEval.asString();
            int end = s.length();
            if (this.mode.isLeft()) {
                for (start = 0; start < s.length() && TrimExprMacro.arrayContains(this.chars, s.charAt(start)); ++start) {
                }
            }
            if (this.mode.isRight()) {
                while (end > start && TrimExprMacro.arrayContains(this.chars, s.charAt(end - 1))) {
                    --end;
                }
            }
            if (start == 0 && end == s.length()) {
                return stringEval;
            }
            return ExprEval.of((String)s.substring(start, end));
        }

        public Expr visit(Expr.Shuttle shuttle) {
            return this.visitFn.apply(shuttle);
        }

        @Nullable
        public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
            return ExpressionType.STRING;
        }

        public String stringify() {
            if (this.charsExpr != null) {
                return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{this.mode.getFnName(), this.arg.stringify(), this.charsExpr.stringify()});
            }
            return super.stringify();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TrimStaticCharsExpr that = (TrimStaticCharsExpr)((Object)o);
            return this.mode == that.mode && Arrays.equals(this.chars, that.chars) && Objects.equals(this.charsExpr, that.charsExpr);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{super.hashCode(), this.mode, this.charsExpr});
            result = 31 * result + Arrays.hashCode(this.chars);
            return result;
        }
    }

    static enum TrimMode {
        BOTH("trim", true, true),
        LEFT("ltrim", true, false),
        RIGHT("rtrim", false, true);

        private final String name;
        private final boolean left;
        private final boolean right;

        private TrimMode(String name, boolean left, boolean right) {
            this.name = name;
            this.left = left;
            this.right = right;
        }

        public String getFnName() {
            return this.name;
        }

        public boolean isLeft() {
            return this.left;
        }

        public boolean isRight() {
            return this.right;
        }
    }
}

