/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.AbstractPrioritizedQueryRunnerCallable;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;

public class GroupByMergingQueryRunnerV2
implements QueryRunner<ResultRow> {
    private static final Logger log = new Logger(GroupByMergingQueryRunnerV2.class);
    private static final String CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION = "mergeRunnersUsingChainedExecution";
    private final GroupByQueryConfig config;
    private final Iterable<QueryRunner<ResultRow>> queryables;
    private final QueryProcessingPool queryProcessingPool;
    private final QueryWatcher queryWatcher;
    private final int concurrencyHint;
    private final BlockingPool<ByteBuffer> mergeBufferPool;
    private final ObjectMapper spillMapper;
    private final String processingTmpDir;
    private final int mergeBufferSize;

    public GroupByMergingQueryRunnerV2(GroupByQueryConfig config, QueryProcessingPool queryProcessingPool, QueryWatcher queryWatcher, Iterable<QueryRunner<ResultRow>> queryables, int concurrencyHint, BlockingPool<ByteBuffer> mergeBufferPool, int mergeBufferSize, ObjectMapper spillMapper, String processingTmpDir) {
        this.config = config;
        this.queryProcessingPool = queryProcessingPool;
        this.queryWatcher = queryWatcher;
        this.queryables = Iterables.unmodifiableIterable((Iterable)Iterables.filter(queryables, (Predicate)Predicates.notNull()));
        this.concurrencyHint = concurrencyHint;
        this.mergeBufferPool = mergeBufferPool;
        this.spillMapper = spillMapper;
        this.processingTmpDir = processingTmpDir;
        this.mergeBufferSize = mergeBufferSize;
    }

    @Override
    public Sequence<ResultRow> run(QueryPlus<ResultRow> queryPlus, final ResponseContext responseContext) {
        final GroupByQuery query = (GroupByQuery)queryPlus.getQuery();
        final GroupByQueryConfig querySpecificConfig = this.config.withOverrides(query);
        boolean forceChainedExecution = query.getContextBoolean(CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION, false);
        final QueryPlus queryPlusForRunners = queryPlus.withQuery(query.withOverriddenContext((Map)ImmutableMap.of((Object)CTX_KEY_MERGE_RUNNERS_USING_CHAINED_EXECUTION, (Object)true))).withoutThreadUnsafeState();
        if (QueryContexts.isBySegment(query) || forceChainedExecution) {
            ChainedExecutionQueryRunner runner = new ChainedExecutionQueryRunner(this.queryProcessingPool, this.queryWatcher, this.queryables);
            return runner.run(queryPlusForRunners, responseContext);
        }
        final boolean isSingleThreaded = querySpecificConfig.isSingleThreaded();
        final File temporaryStorageDirectory = new File(this.processingTmpDir, StringUtils.format((String)"druid-groupBy-%s_%s", (Object[])new Object[]{UUID.randomUUID(), query.getId()}));
        final int priority = QueryContexts.getPriority(query);
        long queryTimeout = QueryContexts.getTimeout(query);
        final boolean hasTimeout = QueryContexts.hasTimeout(query);
        final long timeoutAt = System.currentTimeMillis() + queryTimeout;
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<ResultRow, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, ResultRow>>(){

            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, ResultRow> make() {
                Closer resources = Closer.create();
                try {
                    LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
                    ReferenceCountingResourceHolder temporaryStorageHolder = ReferenceCountingResourceHolder.fromCloseable((Closeable)temporaryStorage);
                    resources.register((Closeable)temporaryStorageHolder);
                    int numMergeBuffers = querySpecificConfig.getNumParallelCombineThreads() > 1 ? 2 : 1;
                    List mergeBufferHolders = GroupByMergingQueryRunnerV2.this.getMergeBuffersHolder(numMergeBuffers, hasTimeout, timeoutAt);
                    resources.registerAll((Collection)mergeBufferHolders);
                    final ReferenceCountingResourceHolder mergeBufferHolder = (ReferenceCountingResourceHolder)mergeBufferHolders.get(0);
                    ReferenceCountingResourceHolder combineBufferHolder = numMergeBuffers == 2 ? (ReferenceCountingResourceHolder)mergeBufferHolders.get(1) : null;
                    Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<AggregateResult, ResultRow>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, null, GroupByMergingQueryRunnerV2.this.config, (Supplier<ByteBuffer>)Suppliers.ofInstance((Object)mergeBufferHolder.get()), (ReferenceCountingResourceHolder<ByteBuffer>)combineBufferHolder, GroupByMergingQueryRunnerV2.this.concurrencyHint, temporaryStorage, GroupByMergingQueryRunnerV2.this.spillMapper, GroupByMergingQueryRunnerV2.this.queryProcessingPool, priority, hasTimeout, timeoutAt, GroupByMergingQueryRunnerV2.this.mergeBufferSize);
                    Grouper grouper = (Grouper)pair.lhs;
                    final Accumulator accumulator = (Accumulator)pair.rhs;
                    grouper.init();
                    final ReferenceCountingResourceHolder grouperHolder = ReferenceCountingResourceHolder.fromCloseable((Closeable)grouper);
                    resources.register((Closeable)grouperHolder);
                    ArrayList futures = Lists.newArrayList((Iterable)Iterables.transform((Iterable)GroupByMergingQueryRunnerV2.this.queryables, (Function)new Function<QueryRunner<ResultRow>, ListenableFuture<AggregateResult>>(){

                        public ListenableFuture<AggregateResult> apply(final QueryRunner<ResultRow> input) {
                            if (input == null) {
                                throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                            }
                            ListenableFuture<AggregateResult> future = GroupByMergingQueryRunnerV2.this.queryProcessingPool.submitRunnerTask(new AbstractPrioritizedQueryRunnerCallable<AggregateResult, ResultRow>(priority, input){

                                /*
                                 * Exception decompiling
                                 */
                                @Override
                                public AggregateResult call() {
                                    /*
                                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                     * 
                                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                     */
                                    throw new IllegalStateException("Decompilation failed");
                                }
                            });
                            if (isSingleThreaded) {
                                GroupByMergingQueryRunnerV2.this.waitForFutureCompletion(query, (List)ImmutableList.of(future), hasTimeout, timeoutAt - System.currentTimeMillis());
                            }
                            return future;
                        }
                    }));
                    if (!isSingleThreaded) {
                        GroupByMergingQueryRunnerV2.this.waitForFutureCompletion(query, futures, hasTimeout, timeoutAt - System.currentTimeMillis());
                    }
                    return RowBasedGrouperHelper.makeGrouperIterator(grouper, query, (Closeable)resources);
                }
                catch (Throwable t) {
                    try {
                        resources.close();
                    }
                    catch (Exception ex) {
                        t.addSuppressed(ex);
                    }
                    throw t;
                }
            }

            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, ResultRow> iterFromMake) {
                iterFromMake.close();
            }
        });
    }

    private List<ReferenceCountingResourceHolder<ByteBuffer>> getMergeBuffersHolder(int numBuffers, boolean hasTimeout, long timeoutAt) {
        try {
            List mergeBufferHolder;
            if (numBuffers > this.mergeBufferPool.maxSize()) {
                throw new ResourceLimitExceededException("Query needs " + numBuffers + " merge buffers, but only " + this.mergeBufferPool.maxSize() + " merge buffers were configured. Try raising druid.processing.numMergeBuffers.");
            }
            if (hasTimeout) {
                long timeout = timeoutAt - System.currentTimeMillis();
                if (timeout <= 0L) {
                    throw new QueryTimeoutException();
                }
                mergeBufferHolder = this.mergeBufferPool.takeBatch(numBuffers, timeout);
                if (mergeBufferHolder.isEmpty()) {
                    throw new QueryTimeoutException("Cannot acquire enough merge buffers");
                }
            } else {
                mergeBufferHolder = this.mergeBufferPool.takeBatch(numBuffers);
            }
            return mergeBufferHolder;
        }
        catch (QueryTimeoutException | ResourceLimitExceededException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryInterruptedException(e);
        }
    }

    private void waitForFutureCompletion(GroupByQuery query, List<ListenableFuture<AggregateResult>> futures, boolean hasTimeout, long timeout) {
        ListenableFuture future = Futures.allAsList(futures);
        try {
            if (this.queryWatcher != null) {
                this.queryWatcher.registerQueryFuture(query, future);
            }
            if (hasTimeout && timeout <= 0L) {
                throw new QueryTimeoutException();
            }
            List results = hasTimeout ? (List)future.get(timeout, TimeUnit.MILLISECONDS) : (List)future.get();
            for (AggregateResult result : results) {
                if (result.isOk()) continue;
                GuavaUtils.cancelAll((boolean)true, (Future)future, futures);
                throw new ResourceLimitExceededException(result.getReason());
            }
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
            GuavaUtils.cancelAll((boolean)true, (Future)future, futures);
            throw new QueryInterruptedException(e);
        }
        catch (CancellationException e) {
            GuavaUtils.cancelAll((boolean)true, (Future)future, futures);
            throw new QueryInterruptedException(e);
        }
        catch (TimeoutException e) {
            log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
            GuavaUtils.cancelAll((boolean)true, (Future)future, futures);
            throw new QueryTimeoutException();
        }
        catch (ExecutionException e) {
            GuavaUtils.cancelAll((boolean)true, (Future)future, futures);
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ Logger access$700() {
        return log;
    }
}

