/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.groupby.epinephelinae.TemporaryStorageFullException;

public class LimitedTemporaryStorage
implements Closeable {
    private static final Logger log = new Logger(LimitedTemporaryStorage.class);
    private final File storageDirectory;
    private final long maxBytesUsed;
    private final AtomicLong bytesUsed = new AtomicLong();
    private final Set<File> files = new TreeSet<File>();
    private volatile boolean closed = false;
    private boolean createdStorageDirectory = false;

    public LimitedTemporaryStorage(File storageDirectory, long maxBytesUsed) {
        this.storageDirectory = storageDirectory;
        this.maxBytesUsed = maxBytesUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimitedOutputStream createFile() throws IOException {
        if (this.bytesUsed.get() >= this.maxBytesUsed) {
            throw new TemporaryStorageFullException(this.maxBytesUsed);
        }
        Set<File> set = this.files;
        synchronized (set) {
            if (this.closed) {
                throw new ISE("Closed", new Object[0]);
            }
            FileUtils.mkdirp((File)this.storageDirectory);
            if (!this.createdStorageDirectory) {
                this.createdStorageDirectory = true;
            }
            File theFile = new File(this.storageDirectory, StringUtils.format((String)"%08d.tmp", (Object[])new Object[]{this.files.size()}));
            EnumSet<StandardOpenOption> openOptions = EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            FileChannel channel = FileChannel.open(theFile.toPath(), openOptions, new FileAttribute[0]);
            this.files.add(theFile);
            return new LimitedOutputStream(theFile, Channels.newOutputStream(channel));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(File file) {
        Set<File> set = this.files;
        synchronized (set) {
            if (this.files.contains(file)) {
                try {
                    Files.delete(file.toPath());
                }
                catch (IOException e) {
                    log.warn((Throwable)e, "Cannot delete file: %s", new Object[]{file});
                }
                this.files.remove(file);
            }
        }
    }

    public long maxSize() {
        return this.maxBytesUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<File> set = this.files;
        synchronized (set) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (File file : ImmutableSet.copyOf(this.files)) {
                this.delete(file);
            }
            this.files.clear();
            if (this.createdStorageDirectory && this.storageDirectory.exists() && !this.storageDirectory.delete()) {
                log.warn("Cannot delete storageDirectory: %s", new Object[]{this.storageDirectory});
            }
        }
    }

    public class LimitedOutputStream
    extends OutputStream {
        private final File file;
        private final OutputStream out;

        private LimitedOutputStream(File file, OutputStream out) {
            this.file = file;
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.grab(1);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.grab(b.length);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.grab(len);
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        public File getFile() {
            return this.file;
        }

        private void grab(int n) throws IOException {
            if (LimitedTemporaryStorage.this.bytesUsed.addAndGet(n) > LimitedTemporaryStorage.this.maxBytesUsed) {
                throw new TemporaryStorageFullException(LimitedTemporaryStorage.this.maxBytesUsed);
            }
        }
    }
}

