/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.vector;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.vector.GroupByVectorColumnSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class NullableFloatGroupByVectorColumnSelector
implements GroupByVectorColumnSelector {
    private final VectorValueSelector selector;

    NullableFloatGroupByVectorColumnSelector(VectorValueSelector selector) {
        this.selector = selector;
    }

    @Override
    public int getGroupingKeySize() {
        return 5;
    }

    @Override
    public int writeKeys(WritableMemory keySpace, int keySize, int keyOffset, int startRow, int endRow) {
        float[] vector = this.selector.getFloatVector();
        boolean[] nulls = this.selector.getNullVector();
        if (nulls != null) {
            int i = startRow;
            int j = keyOffset;
            while (i < endRow) {
                keySpace.putByte((long)j, nulls[i] ? (byte)1 : 0);
                keySpace.putFloat((long)(j + 1), vector[i]);
                ++i;
                j += keySize;
            }
        } else {
            int i = startRow;
            int j = keyOffset;
            while (i < endRow) {
                keySpace.putByte((long)j, (byte)0);
                keySpace.putFloat((long)(j + 1), vector[i]);
                ++i;
                j += keySize;
            }
        }
        return 0;
    }

    @Override
    public void writeKeyToResultRow(Memory keyMemory, int keyOffset, ResultRow resultRow, int resultRowPosition) {
        if (keyMemory.getByte((long)keyOffset) == 1) {
            resultRow.set(resultRowPosition, null);
        } else {
            resultRow.set(resultRowPosition, Float.valueOf(keyMemory.getFloat((long)(keyOffset + 1))));
        }
    }

    @Override
    public void reset() {
    }
}

