/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.ComplexColumn;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class SegmentAnalyzer {
    private static final Logger log = new Logger(SegmentAnalyzer.class);
    private static final int NUM_BYTES_IN_TIMESTAMP = 10;
    private static final int NUM_BYTES_IN_TEXT_FLOAT = 8;
    private final EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes;

    public SegmentAnalyzer(EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes) {
        this.analysisTypes = analysisTypes;
    }

    public long numRows(Segment segment) {
        return ((Segment)Preconditions.checkNotNull((Object)segment, (Object)"segment")).asStorageAdapter().getNumRows();
    }

    public Map<String, ColumnAnalysis> analyze(Segment segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        QueryableIndex index = segment.asQueryableIndex();
        StorageAdapter storageAdapter = segment.asStorageAdapter();
        int length = storageAdapter.getNumRows();
        TreeMap<String, ColumnAnalysis> columns = new TreeMap<String, ColumnAnalysis>();
        RowSignature rowSignature = storageAdapter.getRowSignature();
        for (String columnName : rowSignature.getColumnNames()) {
            ColumnAnalysis analysis;
            ColumnCapabilities capabilities = storageAdapter instanceof IncrementalIndexStorageAdapter ? ((IncrementalIndexStorageAdapter)storageAdapter).getSnapshotColumnCapabilities(columnName) : storageAdapter.getColumnCapabilities(columnName);
            switch (capabilities.getType()) {
                case LONG: {
                    int bytesPerRow = "__time".equals(columnName) ? 10 : 8;
                    analysis = this.analyzeNumericColumn(capabilities, length, bytesPerRow);
                    break;
                }
                case FLOAT: {
                    analysis = this.analyzeNumericColumn(capabilities, length, 8);
                    break;
                }
                case DOUBLE: {
                    analysis = this.analyzeNumericColumn(capabilities, length, 8);
                    break;
                }
                case STRING: {
                    if (index != null) {
                        analysis = this.analyzeStringColumn(capabilities, index.getColumnHolder(columnName));
                        break;
                    }
                    analysis = this.analyzeStringColumn(capabilities, storageAdapter, columnName);
                    break;
                }
                case COMPLEX: {
                    ColumnHolder columnHolder = index != null ? index.getColumnHolder(columnName) : null;
                    analysis = this.analyzeComplexColumn(capabilities, columnHolder);
                    break;
                }
                default: {
                    log.warn("Unknown column type[%s].", new Object[]{capabilities.asTypeString()});
                    analysis = ColumnAnalysis.error(StringUtils.format((String)"unknown_type_%s", (Object[])new Object[]{capabilities.asTypeString()}));
                }
            }
            columns.put(columnName, analysis);
        }
        return columns;
    }

    public boolean analyzingSize() {
        return this.analysisTypes.contains((Object)SegmentMetadataQuery.AnalysisType.SIZE);
    }

    public boolean analyzingCardinality() {
        return this.analysisTypes.contains((Object)SegmentMetadataQuery.AnalysisType.CARDINALITY);
    }

    public boolean analyzingMinMax() {
        return this.analysisTypes.contains((Object)SegmentMetadataQuery.AnalysisType.MINMAX);
    }

    private ColumnAnalysis analyzeNumericColumn(ColumnCapabilities capabilities, int length, int sizePerRow) {
        long size = 0L;
        if (this.analyzingSize()) {
            if (capabilities.hasMultipleValues().isTrue()) {
                return ColumnAnalysis.error("multi_value");
            }
            size = (long)length * (long)sizePerRow;
        }
        return new ColumnAnalysis(capabilities.toColumnType(), capabilities.getType().name(), capabilities.hasMultipleValues().isTrue(), capabilities.hasNulls().isMaybeTrue(), size, null, null, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColumnAnalysis analyzeStringColumn(ColumnCapabilities capabilities, ColumnHolder columnHolder) {
        int cardinality;
        String min = null;
        String max = null;
        long size = 0L;
        if (capabilities.hasBitmapIndexes()) {
            BitmapIndex bitmapIndex = columnHolder.getBitmapIndex();
            cardinality = bitmapIndex.getCardinality();
            if (this.analyzingSize()) {
                for (int i = 0; i < cardinality; ++i) {
                    String value = bitmapIndex.getValue(i);
                    if (value == null) continue;
                    size += (long)StringUtils.estimatedBinaryLengthAsUTF8((String)value) * (long)bitmapIndex.getBitmap(bitmapIndex.getIndex(value)).size();
                }
            }
            if (!this.analyzingMinMax() || cardinality <= 0) return new ColumnAnalysis(capabilities.toColumnType(), capabilities.getType().name(), capabilities.hasMultipleValues().isTrue(), capabilities.hasNulls().isMaybeTrue(), size, this.analyzingCardinality() ? cardinality : 0, (Comparable)((Object)min), (Comparable)((Object)max), null);
            min = NullHandling.nullToEmptyIfNeeded((String)bitmapIndex.getValue(0));
            max = NullHandling.nullToEmptyIfNeeded((String)bitmapIndex.getValue(cardinality - 1));
            return new ColumnAnalysis(capabilities.toColumnType(), capabilities.getType().name(), capabilities.hasMultipleValues().isTrue(), capabilities.hasNulls().isMaybeTrue(), size, this.analyzingCardinality() ? cardinality : 0, (Comparable)((Object)min), (Comparable)((Object)max), null);
        } else if (capabilities.isDictionaryEncoded().isTrue()) {
            try (BaseColumn column = columnHolder.getColumn();){
                DictionaryEncodedColumn theColumn = (DictionaryEncodedColumn)column;
                cardinality = theColumn.getCardinality();
                if (!this.analyzingMinMax() || cardinality <= 0) return new ColumnAnalysis(capabilities.toColumnType(), capabilities.getType().name(), capabilities.hasMultipleValues().isTrue(), capabilities.hasNulls().isMaybeTrue(), size, this.analyzingCardinality() ? cardinality : 0, (Comparable)((Object)min), (Comparable)((Object)max), null);
                min = NullHandling.nullToEmptyIfNeeded((String)((String)theColumn.lookupName(0)));
                max = NullHandling.nullToEmptyIfNeeded((String)((String)theColumn.lookupName(cardinality - 1)));
                return new ColumnAnalysis(capabilities.toColumnType(), capabilities.getType().name(), capabilities.hasMultipleValues().isTrue(), capabilities.hasNulls().isMaybeTrue(), size, this.analyzingCardinality() ? cardinality : 0, (Comparable)((Object)min), (Comparable)((Object)max), null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            cardinality = 0;
        }
        return new ColumnAnalysis(capabilities.toColumnType(), capabilities.getType().name(), capabilities.hasMultipleValues().isTrue(), capabilities.hasNulls().isMaybeTrue(), size, this.analyzingCardinality() ? cardinality : 0, (Comparable)((Object)min), (Comparable)((Object)max), null);
    }

    private ColumnAnalysis analyzeStringColumn(ColumnCapabilities capabilities, StorageAdapter storageAdapter, final String columnName) {
        int cardinality = 0;
        long size = 0L;
        Comparable min = null;
        Comparable max = null;
        if (this.analyzingCardinality()) {
            cardinality = storageAdapter.getDimensionCardinality(columnName);
        }
        if (this.analyzingSize()) {
            DateTime start = storageAdapter.getMinTime();
            DateTime end = storageAdapter.getMaxTime();
            Sequence<Cursor> cursors = storageAdapter.makeCursors(null, new Interval((ReadableInstant)start, (ReadableInstant)end), VirtualColumns.EMPTY, Granularities.ALL, false, null);
            size = (Long)cursors.accumulate((Object)0L, (Accumulator)new Accumulator<Long, Cursor>(){

                public Long accumulate(Long accumulated, Cursor cursor) {
                    DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector(new DefaultDimensionSpec(columnName, columnName));
                    if (selector == null) {
                        return accumulated;
                    }
                    long current = accumulated;
                    while (!cursor.isDone()) {
                        IndexedInts row = selector.getRow();
                        int rowSize = row.size();
                        for (int i = 0; i < rowSize; ++i) {
                            String dimVal = selector.lookupName(row.get(i));
                            if (dimVal == null || dimVal.isEmpty()) continue;
                            current += (long)StringUtils.estimatedBinaryLengthAsUTF8((String)dimVal);
                        }
                        cursor.advance();
                    }
                    return current;
                }
            });
        }
        if (this.analyzingMinMax()) {
            min = storageAdapter.getMinValue(columnName);
            max = storageAdapter.getMaxValue(columnName);
        }
        return new ColumnAnalysis(capabilities.toColumnType(), capabilities.getType().name(), capabilities.hasMultipleValues().isTrue(), capabilities.hasNulls().isMaybeTrue(), size, cardinality, min, max, null);
    }

    private ColumnAnalysis analyzeComplexColumn(@Nullable ColumnCapabilities capabilities, @Nullable ColumnHolder columnHolder) {
        Object typeSignature = capabilities == null ? ColumnType.UNKNOWN_COMPLEX : capabilities;
        String typeName = typeSignature.getComplexTypeName();
        try (ComplexColumn complexColumn = columnHolder != null ? (ComplexColumn)columnHolder.getColumn() : null;){
            boolean hasMultipleValues = capabilities != null && capabilities.hasMultipleValues().isTrue();
            boolean hasNulls = capabilities != null && capabilities.hasNulls().isMaybeTrue();
            long size = 0L;
            if (this.analyzingSize() && complexColumn != null) {
                ComplexMetricSerde serde;
                ComplexMetricSerde complexMetricSerde = serde = typeName == null ? null : ComplexMetrics.getSerdeForType(typeName);
                if (serde == null) {
                    ColumnAnalysis columnAnalysis = ColumnAnalysis.error(StringUtils.format((String)"unknown_complex_%s", (Object[])new Object[]{typeName}));
                    return columnAnalysis;
                }
                Function<Object, Long> inputSizeFn = serde.inputSizeFn();
                if (inputSizeFn == null) {
                    ColumnAnalysis columnAnalysis = new ColumnAnalysis(ColumnTypeFactory.ofType((TypeSignature)typeSignature), typeName, hasMultipleValues, hasNulls, 0L, null, null, null, null);
                    return columnAnalysis;
                }
                int length = complexColumn.getLength();
                for (int i = 0; i < length; ++i) {
                    size += ((Long)inputSizeFn.apply(complexColumn.getRowValue(i))).longValue();
                }
            }
            ColumnAnalysis columnAnalysis = new ColumnAnalysis(ColumnTypeFactory.ofType((TypeSignature)typeSignature), typeName, hasMultipleValues, hasNulls, size, null, null, null, null);
            return columnAnalysis;
        }
    }
}

