/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeboundary;

import com.google.common.base.Function;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerHelper;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.Result;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.filter.Filters;
import org.joda.time.DateTime;

public class TimeBoundaryQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final TimeBoundaryQueryQueryToolChest TOOL_CHEST = new TimeBoundaryQueryQueryToolChest();
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeBoundaryQueryRunnerFactory(QueryWatcher queryWatcher) {
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> createRunner(Segment segment) {
        return new TimeBoundaryQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<Result<TimeBoundaryResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeBoundaryResultValue>>(queryProcessingPool, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> getToolchest() {
        return TOOL_CHEST;
    }

    private static class TimeBoundaryQueryRunner
    implements QueryRunner<Result<TimeBoundaryResultValue>> {
        private final StorageAdapter adapter;
        private final Function<Cursor, Result<DateTime>> skipToFirstMatching;

        public TimeBoundaryQueryRunner(Segment segment) {
            this.adapter = segment.asStorageAdapter();
            this.skipToFirstMatching = new Function<Cursor, Result<DateTime>>(){

                public Result<DateTime> apply(Cursor cursor) {
                    if (cursor.isDone()) {
                        return null;
                    }
                    ColumnValueSelector timestampColumnSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
                    DateTime timestamp = DateTimes.utc((long)timestampColumnSelector.getLong());
                    return new Result<DateTime>(adapter.getInterval().getStart(), timestamp);
                }
            };
        }

        private DateTime getTimeBoundary(StorageAdapter adapter, TimeBoundaryQuery legacyQuery, boolean descending) {
            Sequence<Result<DateTime>> resultSequence = QueryRunnerHelper.makeCursorBasedQuery(adapter, legacyQuery.getQuerySegmentSpec().getIntervals(), Filters.toFilter(legacyQuery.getFilter()), VirtualColumns.EMPTY, descending, Granularities.ALL, this.skipToFirstMatching);
            List resultList = resultSequence.limit(1L).toList();
            if (resultList.size() > 0) {
                return (DateTime)((Result)resultList.get(0)).getValue();
            }
            return null;
        }

        @Override
        public Sequence<Result<TimeBoundaryResultValue>> run(QueryPlus<Result<TimeBoundaryResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<TimeBoundaryResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TimeBoundaryQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", new Object[]{input.getClass(), TimeBoundaryQuery.class});
            }
            final TimeBoundaryQuery legacyQuery = (TimeBoundaryQuery)input;
            return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(){

                public Iterator<Result<TimeBoundaryResultValue>> make() {
                    DateTime maxTime;
                    DateTime minTime;
                    if (adapter == null) {
                        throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                    }
                    if (legacyQuery.getFilter() != null) {
                        minTime = this.getTimeBoundary(adapter, legacyQuery, false);
                        maxTime = minTime == null ? null : this.getTimeBoundary(adapter, legacyQuery, true);
                    } else {
                        minTime = legacyQuery.getBound().equalsIgnoreCase("maxTime") ? null : adapter.getMinTime();
                        maxTime = legacyQuery.getBound().equalsIgnoreCase("minTime") ? null : adapter.getMaxTime();
                    }
                    return legacyQuery.buildResult(adapter.getInterval().getStart(), minTime, maxTime).iterator();
                }

                public void cleanup(Iterator<Result<TimeBoundaryResultValue>> toClean) {
                }
            });
        }
    }
}

