/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.NonBlockingPool;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.collections.StupidPool;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryRunnerHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorAdapters;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesResultBuilder;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.query.vector.VectorCursorGranularizer;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.SegmentMissingException;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.Interval;

public class TimeseriesQueryEngine {
    private final NonBlockingPool<ByteBuffer> bufferPool;

    @VisibleForTesting
    public TimeseriesQueryEngine() {
        this.bufferPool = new StupidPool("dummy", () -> ByteBuffer.allocate(10000000));
    }

    @Inject
    public TimeseriesQueryEngine(@Global NonBlockingPool<ByteBuffer> bufferPool) {
        this.bufferPool = bufferPool;
    }

    public Sequence<Result<TimeseriesResultValue>> process(TimeseriesQuery query, StorageAdapter adapter) {
        if (adapter == null) {
            throw new SegmentMissingException("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()));
        Interval interval = (Interval)Iterables.getOnlyElement(query.getIntervals());
        Granularity gran = query.getGranularity();
        boolean descending = query.isDescending();
        ColumnInspector inspector = query.getVirtualColumns().wrapInspector(adapter);
        boolean doVectorize = QueryContexts.getVectorize(query).shouldVectorize(adapter.canVectorize(filter, query.getVirtualColumns(), descending) && VirtualColumns.shouldVectorize(query, query.getVirtualColumns(), adapter) && query.getAggregatorSpecs().stream().allMatch(aggregatorFactory -> aggregatorFactory.canVectorize(inspector)));
        Sequence<Result<TimeseriesResultValue>> result = doVectorize ? this.processVectorized(query, adapter, filter, interval, gran, descending) : this.processNonVectorized(query, adapter, filter, interval, gran, descending);
        int limit = query.getLimit();
        if (limit < Integer.MAX_VALUE) {
            return result.limit((long)limit);
        }
        return result;
    }

    private Sequence<Result<TimeseriesResultValue>> processVectorized(TimeseriesQuery query, StorageAdapter adapter, @Nullable Filter filter, Interval queryInterval, Granularity gran, boolean descending) {
        boolean skipEmptyBuckets = query.isSkipEmptyBuckets();
        List<AggregatorFactory> aggregatorSpecs = query.getAggregatorSpecs();
        VectorCursor cursor = adapter.makeVectorCursor(filter, queryInterval, query.getVirtualColumns(), descending, QueryContexts.getVectorSize(query), null);
        if (cursor == null) {
            return Sequences.empty();
        }
        Closer closer = Closer.create();
        closer.register((Closeable)cursor);
        try {
            VectorCursorGranularizer granularizer = VectorCursorGranularizer.create(adapter, cursor, gran, queryInterval);
            if (granularizer == null) {
                return Sequences.empty();
            }
            VectorColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
            AggregatorAdapters aggregators = (AggregatorAdapters)closer.register((Closeable)AggregatorAdapters.factorizeVector(columnSelectorFactory, query.getAggregatorSpecs()));
            ResourceHolder bufferHolder = (ResourceHolder)closer.register((Closeable)this.bufferPool.take());
            ByteBuffer buffer = (ByteBuffer)bufferHolder.get();
            if (aggregators.spaceNeeded() > buffer.remaining()) {
                throw new ISE("Not enough space for aggregators, needed [%,d] bytes but have only [%,d].", new Object[]{aggregators.spaceNeeded(), buffer.remaining()});
            }
            return Sequences.withBaggage((Sequence)Sequences.simple(granularizer.getBucketIterable()).map(bucketInterval -> {
                boolean emptyBucket = true;
                while (!cursor.isDone()) {
                    granularizer.setCurrentOffsets((Interval)bucketInterval);
                    if (granularizer.getEndOffset() > granularizer.getStartOffset()) {
                        if (emptyBucket) {
                            aggregators.init(buffer, 0);
                        }
                        aggregators.aggregateVector(buffer, 0, granularizer.getStartOffset(), granularizer.getEndOffset());
                        emptyBucket = false;
                    }
                    if (granularizer.advanceCursorWithinBucket()) continue;
                }
                if (emptyBucket && skipEmptyBuckets) {
                    return null;
                }
                TimeseriesResultBuilder bob = new TimeseriesResultBuilder(gran.toDateTime(bucketInterval.getStartMillis()));
                if (emptyBucket) {
                    aggregators.init(buffer, 0);
                }
                for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                    bob.addMetric(((AggregatorFactory)aggregatorSpecs.get(i)).getName(), aggregators.get(buffer, 0, i));
                }
                return bob.build();
            }).filter(Objects::nonNull), (Closeable)closer);
        }
        catch (Throwable t1) {
            try {
                closer.close();
            }
            catch (Throwable t2) {
                t1.addSuppressed(t2);
            }
            throw t1;
        }
    }

    private Sequence<Result<TimeseriesResultValue>> processNonVectorized(TimeseriesQuery query, StorageAdapter adapter, @Nullable Filter filter, Interval queryInterval, Granularity gran, boolean descending) {
        boolean skipEmptyBuckets = query.isSkipEmptyBuckets();
        List<AggregatorFactory> aggregatorSpecs = query.getAggregatorSpecs();
        return QueryRunnerHelper.makeCursorBasedQuery(adapter, Collections.singletonList(queryInterval), filter, query.getVirtualColumns(), descending, gran, cursor -> {
            if (skipEmptyBuckets && cursor.isDone()) {
                return null;
            }
            Aggregator[] aggregators = new Aggregator[aggregatorSpecs.size()];
            String[] aggregatorNames = new String[aggregatorSpecs.size()];
            for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                aggregators[i] = ((AggregatorFactory)aggregatorSpecs.get(i)).factorize(cursor.getColumnSelectorFactory());
                aggregatorNames[i] = ((AggregatorFactory)aggregatorSpecs.get(i)).getName();
            }
            try {
                while (!cursor.isDone()) {
                    for (Aggregator aggregator : aggregators) {
                        aggregator.aggregate();
                    }
                    cursor.advance();
                }
                TimeseriesResultBuilder bob = new TimeseriesResultBuilder(cursor.getTime());
                for (int i = 0; i < aggregatorSpecs.size(); ++i) {
                    bob.addMetric(aggregatorNames[i], aggregators[i].get());
                }
                Result<TimeseriesResultValue> result = bob.build();
                return result;
            }
            finally {
                for (Aggregator agg : aggregators) {
                    agg.close();
                }
            }
        });
    }
}

