/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.ColumnSelectorPlus;
import org.apache.druid.query.dimension.ColumnSelectorStrategy;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerProvider;
import org.apache.druid.segment.DoubleDimensionHandler;
import org.apache.druid.segment.FloatDimensionHandler;
import org.apache.druid.segment.LongDimensionHandler;
import org.apache.druid.segment.StringDimensionHandler;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.ComparableList;
import org.apache.druid.segment.data.ComparableStringArray;

public final class DimensionHandlerUtils {
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Long ZERO_LONG = 0L;
    public static final ColumnCapabilities DEFAULT_STRING_CAPABILITIES = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(false).setDictionaryValuesUnique(false).setDictionaryValuesSorted(false).setHasBitmapIndexes(false);
    public static final ConcurrentHashMap<String, DimensionHandlerProvider> DIMENSION_HANDLER_PROVIDERS = new ConcurrentHashMap();

    public static void registerDimensionHandlerProvider(String type, DimensionHandlerProvider provider) {
        DIMENSION_HANDLER_PROVIDERS.compute(type, (key, value) -> {
            if (value == null) {
                return provider;
            }
            if (!value.getClass().getName().equals(provider.getClass().getName())) {
                throw new ISE("Incompatible dimensionHandlerProvider for type[%s] already exists. Expected [%s], found [%s].", new Object[]{key, value.getClass().getName(), provider.getClass().getName()});
            }
            return value;
        });
    }

    private DimensionHandlerUtils() {
    }

    public static DimensionHandler<?, ?, ?> getHandlerFromCapabilities(String dimensionName, @Nullable ColumnCapabilities capabilities, @Nullable DimensionSchema.MultiValueHandling multiValueHandling) {
        if (capabilities == null) {
            return new StringDimensionHandler(dimensionName, multiValueHandling, true, false);
        }
        DimensionSchema.MultiValueHandling multiValueHandling2 = multiValueHandling = multiValueHandling == null ? DimensionSchema.MultiValueHandling.ofDefault() : multiValueHandling;
        if (capabilities.is((TypeDescriptor)ValueType.STRING)) {
            if (!capabilities.isDictionaryEncoded().isTrue()) {
                throw new IAE("String column must have dictionary encoding.", new Object[0]);
            }
            return new StringDimensionHandler(dimensionName, multiValueHandling, capabilities.hasBitmapIndexes(), capabilities.hasSpatialIndexes());
        }
        if (capabilities.is((TypeDescriptor)ValueType.LONG)) {
            return new LongDimensionHandler(dimensionName);
        }
        if (capabilities.is((TypeDescriptor)ValueType.FLOAT)) {
            return new FloatDimensionHandler(dimensionName);
        }
        if (capabilities.is((TypeDescriptor)ValueType.DOUBLE)) {
            return new DoubleDimensionHandler(dimensionName);
        }
        if (capabilities.is((TypeDescriptor)ValueType.COMPLEX) && capabilities.getComplexTypeName() != null) {
            DimensionHandlerProvider provider = DIMENSION_HANDLER_PROVIDERS.get(capabilities.getComplexTypeName());
            if (provider == null) {
                throw new ISE("Can't find DimensionHandlerProvider for typeName [%s]", new Object[]{capabilities.getComplexTypeName()});
            }
            return provider.get(dimensionName);
        }
        return new StringDimensionHandler(dimensionName, multiValueHandling, true, false);
    }

    public static List<ColumnType> getValueTypesFromDimensionSpecs(List<DimensionSpec> dimSpecs) {
        ArrayList<ColumnType> types = new ArrayList<ColumnType>(dimSpecs.size());
        for (DimensionSpec dimSpec : dimSpecs) {
            types.add(dimSpec.getOutputType());
        }
        return types;
    }

    public static <Strategy extends ColumnSelectorStrategy> ColumnSelectorPlus<Strategy> createColumnSelectorPlus(ColumnSelectorStrategyFactory<Strategy> strategyFactory, DimensionSpec dimensionSpec, ColumnSelectorFactory cursor) {
        return DimensionHandlerUtils.createColumnSelectorPluses(strategyFactory, (List<DimensionSpec>)ImmutableList.of((Object)dimensionSpec), cursor)[0];
    }

    public static <Strategy extends ColumnSelectorStrategy> ColumnSelectorPlus<Strategy>[] createColumnSelectorPluses(ColumnSelectorStrategyFactory<Strategy> strategyFactory, List<DimensionSpec> dimensionSpecs, ColumnSelectorFactory columnSelectorFactory) {
        int dimCount = dimensionSpecs.size();
        ColumnSelectorPlus[] dims = new ColumnSelectorPlus[dimCount];
        for (int i = 0; i < dimCount; ++i) {
            ColumnSelectorPlus<Strategy> selectorPlus;
            DimensionSpec dimSpec = dimensionSpecs.get(i);
            String dimName = dimSpec.getDimension();
            ColumnValueSelector<?> selector = DimensionHandlerUtils.getColumnValueSelectorFromDimensionSpec(dimSpec, columnSelectorFactory);
            Strategy strategy = DimensionHandlerUtils.makeStrategy(strategyFactory, dimSpec, columnSelectorFactory.getColumnCapabilities(dimSpec.getDimension()), selector);
            dims[i] = selectorPlus = new ColumnSelectorPlus<Strategy>(dimName, dimSpec.getOutputName(), strategy, selector);
        }
        return dims;
    }

    private static ColumnValueSelector<?> getColumnValueSelectorFromDimensionSpec(DimensionSpec dimSpec, ColumnSelectorFactory columnSelectorFactory) {
        String dimName = dimSpec.getDimension();
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(dimName);
        if ((capabilities = DimensionHandlerUtils.getEffectiveCapabilities(dimSpec, capabilities)).is((TypeDescriptor)ValueType.STRING)) {
            return columnSelectorFactory.makeDimensionSelector(dimSpec);
        }
        return columnSelectorFactory.makeColumnValueSelector(dimSpec.getDimension());
    }

    private static ColumnCapabilities getEffectiveCapabilities(DimensionSpec dimSpec, @Nullable ColumnCapabilities capabilities) {
        if (capabilities == null) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        if (capabilities.is((TypeDescriptor)ValueType.COMPLEX)) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        if (dimSpec.getExtractionFn() != null) {
            ExtractionFn fn = dimSpec.getExtractionFn();
            capabilities = ColumnCapabilitiesImpl.copyOf(capabilities).setType(ColumnType.STRING).setDictionaryValuesUnique(capabilities.isDictionaryEncoded().isTrue() && fn.getExtractionType() == ExtractionFn.ExtractionType.ONE_TO_ONE).setHasMultipleValues(capabilities.hasMultipleValues().isMaybeTrue() || capabilities.isArray()).setDictionaryValuesSorted(capabilities.isDictionaryEncoded().isTrue() && fn.preservesOrdering());
        }
        if (capabilities.isNumeric() && dimSpec.mustDecorate()) {
            capabilities = DEFAULT_STRING_CAPABILITIES;
        }
        return capabilities;
    }

    private static <Strategy extends ColumnSelectorStrategy> Strategy makeStrategy(ColumnSelectorStrategyFactory<Strategy> strategyFactory, DimensionSpec dimSpec, @Nullable ColumnCapabilities capabilities, ColumnValueSelector<?> selector) {
        capabilities = DimensionHandlerUtils.getEffectiveCapabilities(dimSpec, capabilities);
        return strategyFactory.makeColumnSelectorStrategy(capabilities, selector);
    }

    @Nullable
    public static String convertObjectToString(@Nullable Object valObj) {
        if (valObj == null) {
            return null;
        }
        return valObj.toString();
    }

    @Nullable
    public static Long convertObjectToLong(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToLong(valObj, false);
    }

    @Nullable
    public static Long convertObjectToLong(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return null;
        }
        if (valObj instanceof Long) {
            return (Long)valObj;
        }
        if (valObj instanceof Number) {
            return ((Number)valObj).longValue();
        }
        if (valObj instanceof String) {
            Long ret = DimensionHandlerUtils.getExactLongFromDecimalString((String)valObj);
            if (reportParseExceptions && ret == null) {
                throw new ParseException((String)valObj, "could not convert value [%s] to long", new Object[]{valObj});
            }
            return ret;
        }
        throw new ParseException(valObj.getClass().toString(), "Unknown type[%s]", new Object[]{valObj.getClass()});
    }

    @Nullable
    public static Float convertObjectToFloat(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToFloat(valObj, false);
    }

    @Nullable
    public static Float convertObjectToFloat(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return null;
        }
        if (valObj instanceof Float) {
            return (Float)valObj;
        }
        if (valObj instanceof Number) {
            return Float.valueOf(((Number)valObj).floatValue());
        }
        if (valObj instanceof String) {
            Float ret = Floats.tryParse((String)((String)valObj));
            if (reportParseExceptions && ret == null) {
                throw new ParseException((String)valObj, "could not convert value [%s] to float", new Object[]{valObj});
            }
            return ret;
        }
        throw new ParseException(valObj.getClass().toString(), "Unknown type[%s]", new Object[]{valObj.getClass()});
    }

    @Nullable
    public static Comparable<?> convertObjectToType(@Nullable Object obj, TypeSignature<ValueType> type, boolean reportParseExceptions) {
        Preconditions.checkNotNull(type, (Object)"type");
        switch ((ValueType)type.getType()) {
            case LONG: {
                return DimensionHandlerUtils.convertObjectToLong(obj, reportParseExceptions);
            }
            case FLOAT: {
                return DimensionHandlerUtils.convertObjectToFloat(obj, reportParseExceptions);
            }
            case DOUBLE: {
                return DimensionHandlerUtils.convertObjectToDouble(obj, reportParseExceptions);
            }
            case STRING: {
                return DimensionHandlerUtils.convertObjectToString(obj);
            }
            case ARRAY: {
                switch ((ValueType)type.getElementType().getType()) {
                    case STRING: {
                        return DimensionHandlerUtils.convertToComparableStringArray(obj);
                    }
                    case LONG: {
                        return DimensionHandlerUtils.convertToListWithObjectFunction(obj, DimensionHandlerUtils::convertObjectToLong);
                    }
                    case FLOAT: {
                        return DimensionHandlerUtils.convertToListWithObjectFunction(obj, DimensionHandlerUtils::convertObjectToFloat);
                    }
                    case DOUBLE: {
                        return DimensionHandlerUtils.convertToListWithObjectFunction(obj, DimensionHandlerUtils::convertObjectToDouble);
                    }
                }
            }
        }
        throw new IAE("Type[%s] is not supported for dimensions!", new Object[]{type});
    }

    @Nullable
    public static ComparableList convertToList(Object obj, ValueType elementType) {
        switch (elementType) {
            case LONG: {
                return DimensionHandlerUtils.convertToListWithObjectFunction(obj, DimensionHandlerUtils::convertObjectToLong);
            }
            case FLOAT: {
                return DimensionHandlerUtils.convertToListWithObjectFunction(obj, DimensionHandlerUtils::convertObjectToFloat);
            }
            case DOUBLE: {
                return DimensionHandlerUtils.convertToListWithObjectFunction(obj, DimensionHandlerUtils::convertObjectToDouble);
            }
        }
        throw new ISE("Unable to convert object of type[%s] to [%s]", new Object[]{obj.getClass().getName(), ComparableList.class.getName()});
    }

    private static <T> ComparableList convertToListWithObjectFunction(Object obj, Function<Object, T> convertFunction) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof List) {
            return DimensionHandlerUtils.convertToComparableList((List)obj, convertFunction);
        }
        if (obj instanceof ComparableList) {
            return DimensionHandlerUtils.convertToComparableList(((ComparableList)obj).getDelegate(), convertFunction);
        }
        if (obj instanceof Object[]) {
            ArrayList<T> delegateList = new ArrayList<T>();
            for (Object eachObj : (Object[])obj) {
                delegateList.add(convertFunction.apply(eachObj));
            }
            return new ComparableList(delegateList);
        }
        throw new ISE("Unable to convert object of type[%s] to [%s]", new Object[]{obj.getClass().getName(), ComparableList.class.getName()});
    }

    @Nonnull
    private static <T> ComparableList convertToComparableList(List obj, Function<Object, T> convertFunction) {
        ArrayList<T> delegateList = new ArrayList<T>();
        for (Object eachObj : obj) {
            delegateList.add(convertFunction.apply(eachObj));
        }
        return new ComparableList(delegateList);
    }

    @Nullable
    public static ComparableStringArray convertToComparableStringArray(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ComparableStringArray) {
            return (ComparableStringArray)obj;
        }
        if (obj instanceof List) {
            String[] delegate = new String[((List)obj).size()];
            for (int i = 0; i < delegate.length; ++i) {
                delegate[i] = DimensionHandlerUtils.convertObjectToString(((List)obj).get(i));
            }
            return ComparableStringArray.of(delegate);
        }
        if (obj instanceof Object[]) {
            Object[] objects = (Object[])obj;
            String[] delegate = new String[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                delegate[i] = DimensionHandlerUtils.convertObjectToString(objects[i]);
            }
            return ComparableStringArray.of(delegate);
        }
        throw new ISE("Unable to convert object of type[%s] to [%s]", new Object[]{obj.getClass().getName(), ComparableStringArray.class.getName()});
    }

    public static int compareObjectsAsType(@Nullable Object lhs, @Nullable Object rhs, ColumnType type) {
        return Comparators.naturalNullsFirst().compare(DimensionHandlerUtils.convertObjectToType(lhs, (TypeSignature<ValueType>)type), DimensionHandlerUtils.convertObjectToType(rhs, (TypeSignature<ValueType>)type));
    }

    @Nullable
    public static Comparable<?> convertObjectToType(@Nullable Object obj, TypeSignature<ValueType> type) {
        return DimensionHandlerUtils.convertObjectToType(obj, (TypeSignature<ValueType>)((TypeSignature)Preconditions.checkNotNull(type, (Object)"type")), false);
    }

    public static Function<Object, Comparable<?>> converterFromTypeToType(TypeSignature<ValueType> fromType, TypeSignature<ValueType> toType) {
        if (Objects.equals(fromType, toType)) {
            return Function.identity();
        }
        return obj -> DimensionHandlerUtils.convertObjectToType(obj, toType);
    }

    @Nullable
    public static Double convertObjectToDouble(@Nullable Object valObj) {
        return DimensionHandlerUtils.convertObjectToDouble(valObj, false);
    }

    @Nullable
    public static Double convertObjectToDouble(@Nullable Object valObj, boolean reportParseExceptions) {
        if (valObj == null) {
            return null;
        }
        if (valObj instanceof Double) {
            return (Double)valObj;
        }
        if (valObj instanceof Number) {
            return ((Number)valObj).doubleValue();
        }
        if (valObj instanceof String) {
            Double ret = Doubles.tryParse((String)((String)valObj));
            if (reportParseExceptions && ret == null) {
                throw new ParseException((String)valObj, "could not convert value [%s] to double", new Object[]{valObj});
            }
            return ret;
        }
        throw new ParseException(valObj.getClass().toString(), "Unknown type[%s]", new Object[]{valObj.getClass()});
    }

    @Nullable
    public static Long getExactLongFromDecimalString(String decimalStr) {
        BigDecimal convertedBD;
        Long val = GuavaUtils.tryParseLong((String)decimalStr);
        if (val != null) {
            return val;
        }
        try {
            convertedBD = new BigDecimal(decimalStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        try {
            return convertedBD.longValueExact();
        }
        catch (ArithmeticException ae) {
            return null;
        }
    }

    public static Double nullToZero(@Nullable Double number) {
        return number == null ? ZERO_DOUBLE : number;
    }

    public static Long nullToZero(@Nullable Long number) {
        return number == null ? ZERO_LONG : number;
    }

    public static Float nullToZero(@Nullable Float number) {
        return number == null ? ZERO_FLOAT : number;
    }
}

