/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorBitmapIndexSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorSequenceBuilder;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorCursor;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class QueryableIndexStorageAdapter
implements StorageAdapter {
    public static final int DEFAULT_VECTOR_SIZE = 512;
    private final QueryableIndex index;
    @Nullable
    private volatile DateTime minTime;
    @Nullable
    private volatile DateTime maxTime;

    public QueryableIndexStorageAdapter(QueryableIndex index) {
        this.index = index;
    }

    @Override
    public Interval getInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.index.getAvailableDimensions();
    }

    @Override
    public Iterable<String> getAvailableMetrics() {
        HashSet columnNames = Sets.newHashSet(this.index.getColumnNames());
        return Sets.difference((Set)columnNames, (Set)Sets.newHashSet(this.index.getAvailableDimensions()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDimensionCardinality(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder == null) {
            return 1;
        }
        try (BaseColumn col = columnHolder.getColumn();){
            if (!(col instanceof DictionaryEncodedColumn)) {
                int n = Integer.MAX_VALUE;
                return n;
            }
            int n = ((DictionaryEncodedColumn)col).getCardinality();
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int getNumRows() {
        return this.index.getNumRows();
    }

    @Override
    public DateTime getMinTime() {
        if (this.minTime == null) {
            this.populateMinMaxTime();
        }
        return this.minTime;
    }

    @Override
    public DateTime getMaxTime() {
        if (this.maxTime == null) {
            this.populateMinMaxTime();
        }
        return this.maxTime;
    }

    @Override
    @Nullable
    public Comparable getMinValue(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder != null && columnHolder.getCapabilities().hasBitmapIndexes()) {
            BitmapIndex bitmap = columnHolder.getBitmapIndex();
            return bitmap.getCardinality() > 0 ? bitmap.getValue(0) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Comparable getMaxValue(String dimension) {
        ColumnHolder columnHolder = this.index.getColumnHolder(dimension);
        if (columnHolder != null && columnHolder.getCapabilities().hasBitmapIndexes()) {
            BitmapIndex bitmap = columnHolder.getBitmapIndex();
            return bitmap.getCardinality() > 0 ? bitmap.getValue(bitmap.getCardinality() - 1) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return QueryableIndexStorageAdapter.getColumnCapabilities(this.index, column);
    }

    @Override
    public DateTime getMaxIngestedEventTime() {
        return this.getMaxTime();
    }

    @Override
    public boolean canVectorize(@Nullable Filter filter, VirtualColumns virtualColumns, boolean descending) {
        if (filter != null) {
            boolean filterCanVectorize;
            boolean bl = filterCanVectorize = filter.shouldUseBitmapIndex(this.makeBitmapIndexSelector(virtualColumns)) || filter.canVectorizeMatcher(this);
            if (!filterCanVectorize) {
                return false;
            }
        }
        return !descending;
    }

    @Override
    @Nullable
    public VectorCursor makeVectorCursor(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, boolean descending, int vectorSize, @Nullable QueryMetrics<?> queryMetrics) {
        Interval actualInterval;
        if (!this.canVectorize(filter, virtualColumns, descending)) {
            throw new ISE("Cannot vectorize. Check 'canVectorize' before calling 'makeVectorCursor'.", new Object[0]);
        }
        if (queryMetrics != null) {
            queryMetrics.vectorized(true);
        }
        if ((actualInterval = this.computeCursorInterval(Granularities.ALL, interval)) == null) {
            return null;
        }
        ColumnSelectorBitmapIndexSelector bitmapIndexSelector = this.makeBitmapIndexSelector(virtualColumns);
        FilterAnalysis filterAnalysis = this.analyzeFilter(filter, bitmapIndexSelector, queryMetrics);
        return new QueryableIndexCursorSequenceBuilder(this.index, actualInterval, virtualColumns, filterAnalysis.getPreFilterBitmap(), this.getMinTime().getMillis(), this.getMaxTime().getMillis(), descending, filterAnalysis.getPostFilter(), bitmapIndexSelector).buildVectorized(vectorSize > 0 ? vectorSize : 512);
    }

    @Override
    public Sequence<Cursor> makeCursors(@Nullable Filter filter, Interval interval, VirtualColumns virtualColumns, Granularity gran, boolean descending, @Nullable QueryMetrics<?> queryMetrics) {
        Interval actualInterval;
        if (queryMetrics != null) {
            queryMetrics.vectorized(false);
        }
        if ((actualInterval = this.computeCursorInterval(gran, interval)) == null) {
            return Sequences.empty();
        }
        ColumnSelectorBitmapIndexSelector bitmapIndexSelector = this.makeBitmapIndexSelector(virtualColumns);
        FilterAnalysis filterAnalysis = this.analyzeFilter(filter, bitmapIndexSelector, queryMetrics);
        return Sequences.filter(new QueryableIndexCursorSequenceBuilder(this.index, actualInterval, virtualColumns, filterAnalysis.getPreFilterBitmap(), this.getMinTime().getMillis(), this.getMaxTime().getMillis(), descending, filterAnalysis.getPostFilter(), bitmapIndexSelector).build(gran), Objects::nonNull);
    }

    @Nullable
    public static ColumnCapabilities getColumnCapabilities(ColumnSelector index, String columnName) {
        ColumnHolder columnHolder = index.getColumnHolder(columnName);
        if (columnHolder == null) {
            return null;
        }
        return columnHolder.getCapabilities();
    }

    public static ColumnInspector getColumnInspectorForIndex(ColumnSelector index) {
        return column -> QueryableIndexStorageAdapter.getColumnCapabilities(index, column);
    }

    @Override
    public Metadata getMetadata() {
        return this.index.getMetadata();
    }

    private void populateMinMaxTime() {
        ColumnHolder columnHolder = this.index.getColumnHolder("__time");
        try (NumericColumn column = (NumericColumn)columnHolder.getColumn();){
            this.minTime = DateTimes.utc((long)column.getLongSingleValueRow(0));
            this.maxTime = DateTimes.utc((long)column.getLongSingleValueRow(column.length() - 1));
        }
    }

    @Nullable
    private Interval computeCursorInterval(Granularity gran, Interval interval) {
        DateTime maxTime;
        DateTime minTime = this.getMinTime();
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)gran.bucketEnd(maxTime = this.getMaxTime()));
        if (!interval.overlaps((ReadableInterval)dataInterval)) {
            return null;
        }
        return interval.overlap((ReadableInterval)dataInterval);
    }

    @VisibleForTesting
    public ColumnSelectorBitmapIndexSelector makeBitmapIndexSelector(VirtualColumns virtualColumns) {
        return new ColumnSelectorBitmapIndexSelector(this.index.getBitmapFactoryForDimensions(), virtualColumns, this.index);
    }

    @VisibleForTesting
    public FilterAnalysis analyzeFilter(@Nullable Filter filter, ColumnSelectorBitmapIndexSelector indexSelector, @Nullable QueryMetrics queryMetrics) {
        DefaultBitmapResultFactory bitmapResultFactory;
        ImmutableBitmap preFilterBitmap;
        List<Filter> preFilters;
        int totalRows = this.index.getNumRows();
        ArrayList<Filter> postFilters = new ArrayList<Filter>();
        int preFilteredRows = totalRows;
        if (filter == null) {
            preFilters = Collections.emptyList();
        } else {
            preFilters = new ArrayList();
            if (filter instanceof AndFilter) {
                for (Filter subfilter : ((AndFilter)filter).getFilters()) {
                    if (subfilter.supportsBitmapIndex(indexSelector) && subfilter.shouldUseBitmapIndex(indexSelector)) {
                        preFilters.add(subfilter);
                        continue;
                    }
                    postFilters.add(subfilter);
                }
            } else if (filter.supportsBitmapIndex(indexSelector) && filter.shouldUseBitmapIndex(indexSelector)) {
                preFilters.add(filter);
            } else {
                postFilters.add(filter);
            }
        }
        if (preFilters.isEmpty()) {
            preFilterBitmap = null;
        } else if (queryMetrics != null) {
            bitmapResultFactory = queryMetrics.makeBitmapResultFactory(indexSelector.getBitmapFactory());
            long bitmapConstructionStartNs = System.nanoTime();
            preFilterBitmap = AndFilter.getBitmapIndex(indexSelector, bitmapResultFactory, preFilters);
            preFilteredRows = preFilterBitmap.size();
            queryMetrics.reportBitmapConstructionTime(System.nanoTime() - bitmapConstructionStartNs);
        } else {
            bitmapResultFactory = new DefaultBitmapResultFactory(indexSelector.getBitmapFactory());
            preFilterBitmap = AndFilter.getBitmapIndex(indexSelector, bitmapResultFactory, preFilters);
        }
        if (queryMetrics != null) {
            queryMetrics.preFilters(new ArrayList<Filter>(preFilters));
            queryMetrics.postFilters(postFilters);
            queryMetrics.reportSegmentRows(totalRows);
            queryMetrics.reportPreFilteredRows(preFilteredRows);
        }
        return new FilterAnalysis(preFilterBitmap, Filters.maybeAnd(postFilters).orElse(null));
    }

    @VisibleForTesting
    public static class FilterAnalysis {
        private final Filter postFilter;
        private final ImmutableBitmap preFilterBitmap;

        public FilterAnalysis(@Nullable ImmutableBitmap preFilterBitmap, @Nullable Filter postFilter) {
            this.preFilterBitmap = preFilterBitmap;
            this.postFilter = postFilter;
        }

        @Nullable
        public ImmutableBitmap getPreFilterBitmap() {
            return this.preFilterBitmap;
        }

        @Nullable
        public Filter getPostFilter() {
            return this.postFilter;
        }
    }
}

