/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.Iterables;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.Indexed;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public interface StorageAdapter
extends CursorFactory,
ColumnInspector {
    public Interval getInterval();

    public Indexed<String> getAvailableDimensions();

    public Iterable<String> getAvailableMetrics();

    default public RowSignature getRowSignature() {
        RowSignature.Builder builder = RowSignature.builder();
        builder.addTimeColumn();
        for (String column : Iterables.concat(this.getAvailableDimensions(), this.getAvailableMetrics())) {
            builder.add(column, Optional.ofNullable(this.getColumnCapabilities(column)).map(ColumnCapabilities::toColumnType).orElse(null));
        }
        return builder.build();
    }

    public int getDimensionCardinality(String var1);

    public DateTime getMinTime();

    public DateTime getMaxTime();

    @Nullable
    public Comparable getMinValue(String var1);

    @Nullable
    public Comparable getMaxValue(String var1);

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String var1);

    public int getNumRows();

    public DateTime getMaxIngestedEventTime();

    public Metadata getMetadata();

    default public boolean hasBuiltInFilters() {
        return false;
    }
}

