/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.segment.column.BitmapIndex;

public final class BitmapIndexes {
    public static BitmapIndex forNilColumn(final IntSupplier rowCountSupplier, final BitmapFactory bitmapFactory) {
        return new BitmapIndex(){
            private final Supplier<ImmutableBitmap> nullBitmapSupplier = Suppliers.memoize(() -> this.getBitmapFactory().complement(this.getBitmapFactory().makeEmptyImmutableBitmap(), rowCountSupplier.getAsInt()));

            @Override
            public int getCardinality() {
                return 1;
            }

            @Override
            @Nullable
            public String getValue(int index) {
                return null;
            }

            @Override
            public boolean hasNulls() {
                return true;
            }

            @Override
            public BitmapFactory getBitmapFactory() {
                return bitmapFactory;
            }

            @Override
            public int getIndex(@Nullable String value) {
                return NullHandling.isNullOrEquivalent((String)value) ? 0 : -2;
            }

            @Override
            public ImmutableBitmap getBitmap(int idx) {
                if (idx == 0) {
                    return (ImmutableBitmap)this.nullBitmapSupplier.get();
                }
                return bitmapFactory.makeEmptyImmutableBitmap();
            }
        };
    }

    private BitmapIndexes() {
    }
}

