/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.query.monomorphicprocessing.HotLoopCallee;

public interface Indexed<T>
extends Iterable<T>,
HotLoopCallee {
    public int size();

    @Nullable
    public T get(int var1);

    public int indexOf(@Nullable T var1);

    public static <T> int indexOf(IndexedGetter<T> indexed, int size, Comparator<T> comparator, @Nullable T value) {
        int minIndex = 0;
        int maxIndex = size - 1;
        while (minIndex <= maxIndex) {
            int currIndex = minIndex + maxIndex >>> 1;
            T currValue = indexed.get(currIndex);
            int comparison = comparator.compare(currValue, value);
            if (comparison == 0) {
                return currIndex;
            }
            if (comparison < 0) {
                minIndex = currIndex + 1;
                continue;
            }
            maxIndex = currIndex - 1;
        }
        return -(minIndex + 1);
    }

    @FunctionalInterface
    public static interface IndexedGetter<T> {
        @Nullable
        public T get(int var1);
    }
}

