/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherColumnProcessorFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.segment.virtual.ExpressionVectorSelectors;

public class ExpressionFilter
implements Filter {
    private final Supplier<Expr> expr;
    private final Supplier<Expr.BindingAnalysis> bindingDetails;
    private final FilterTuning filterTuning;

    public ExpressionFilter(Supplier<Expr> expr, FilterTuning filterTuning) {
        this.expr = expr;
        this.bindingDetails = Suppliers.memoize(() -> ((Expr)expr.get()).analyzeInputs());
        this.filterTuning = filterTuning;
    }

    @Override
    public boolean canVectorizeMatcher(ColumnInspector inspector) {
        return ((Expr)this.expr.get()).canVectorize((Expr.InputBindingInspector)inspector);
    }

    @Override
    public VectorValueMatcher makeVectorMatcher(VectorColumnSelectorFactory factory) {
        Expr theExpr = (Expr)this.expr.get();
        DruidPredicateFactory predicateFactory = new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return Evals::asBoolean;
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                return Evals::asBoolean;
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                return Evals::asBoolean;
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                return Evals::asBoolean;
            }

            public int hashCode() {
                return super.hashCode();
            }

            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        };
        ExpressionType outputType = theExpr.getOutputType((Expr.InputBindingInspector)factory);
        if (outputType == null) {
            if (NullHandling.sqlCompatible()) {
                return BooleanVectorValueMatcher.of(factory.getReadableVectorInspector(), false);
            }
            return BooleanVectorValueMatcher.of(factory.getReadableVectorInspector(), theExpr.eval(InputBindings.nilBindings()).asBoolean());
        }
        switch ((ExprType)outputType.getType()) {
            case LONG: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeLongProcessor(ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)ColumnType.LONG), ExpressionVectorSelectors.makeVectorValueSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
            case DOUBLE: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeDoubleProcessor(ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)ColumnType.DOUBLE), ExpressionVectorSelectors.makeVectorValueSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
            case STRING: {
                return VectorValueMatcherColumnProcessorFactory.instance().makeObjectProcessor(ColumnCapabilitiesImpl.createSimpleSingleValueStringColumnCapabilities(), ExpressionVectorSelectors.makeVectorObjectSelector(factory, theExpr)).makeMatcher(predicateFactory);
            }
        }
        throw new UOE("Vectorized expression matchers not implemented for type: [%s]", new Object[]{outputType});
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        final ColumnValueSelector<ExprEval> selector = ExpressionSelectors.makeExprEvalSelector(factory, (Expr)this.expr.get());
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                ExprEval eval = (ExprEval)selector.getObject();
                if (eval.type().isArray()) {
                    switch ((ExprType)eval.elementType().getType()) {
                        case LONG: {
                            Long[] lResult = eval.asLongArray();
                            if (lResult == null) {
                                return false;
                            }
                            return Arrays.stream(lResult).filter(Objects::nonNull).anyMatch(Evals::asBoolean);
                        }
                        case STRING: {
                            String[] sResult = eval.asStringArray();
                            if (sResult == null) {
                                return false;
                            }
                            return Arrays.stream(sResult).anyMatch(Evals::asBoolean);
                        }
                        case DOUBLE: {
                            Double[] dResult = eval.asDoubleArray();
                            if (dResult == null) {
                                return false;
                            }
                            return Arrays.stream(dResult).filter(Objects::nonNull).anyMatch(Evals::asBoolean);
                        }
                    }
                }
                return eval.asBoolean();
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        Expr.BindingAnalysis details = (Expr.BindingAnalysis)this.bindingDetails.get();
        if (details.getRequiredBindings().isEmpty()) {
            return true;
        }
        if (details.getRequiredBindings().size() == 1) {
            String column = (String)Iterables.getOnlyElement((Iterable)details.getRequiredBindings());
            return selector.getBitmapIndex(column) != null && ExpressionSelectors.canMapOverDictionary(details, selector.hasMultipleValues(column));
        }
        return false;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        if (((Expr.BindingAnalysis)this.bindingDetails.get()).getRequiredBindings().isEmpty()) {
            if (((Expr)this.expr.get()).eval(InputBindings.nilBindings()).asBoolean()) {
                return bitmapResultFactory.wrapAllTrue(Filters.allTrue(selector));
            }
            return bitmapResultFactory.wrapAllFalse(Filters.allFalse(selector));
        }
        assert (this.supportsBitmapIndex(selector));
        String column = (String)Iterables.getOnlyElement((Iterable)((Expr.BindingAnalysis)this.bindingDetails.get()).getRequiredBindings());
        return Filters.matchPredicate(column, selector, bitmapResultFactory, (Predicate<String>)((Predicate)value -> ((Expr)this.expr.get()).eval(InputBindings.forFunction(identifierName -> {
            assert (column.equals(identifierName));
            return NullHandling.nullToEmptyIfNeeded((String)value);
        })).asBoolean()));
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return false;
    }

    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ((Expr.BindingAnalysis)this.bindingDetails.get()).getRequiredBindings();
    }

    @Override
    public boolean supportsRequiredColumnRewrite() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpressionFilter that = (ExpressionFilter)o;
        return Objects.equals(this.expr, that.expr) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.expr, this.filterTuning);
    }

    public String toString() {
        return "ExpressionFilter{expr=" + this.expr + ", filterTuning=" + this.filterTuning + '}';
    }
}

