/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.query.filter.BitmapIndexSelector;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterTuning;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.filter.Filters;
import org.mozilla.javascript.Context;

public class JavaScriptFilter
implements Filter {
    private final String dimension;
    private final JavaScriptDimFilter.JavaScriptPredicateFactory predicateFactory;
    private final FilterTuning filterTuning;

    public JavaScriptFilter(String dimension, JavaScriptDimFilter.JavaScriptPredicateFactory predicate, FilterTuning filterTuning) {
        this.dimension = dimension;
        this.predicateFactory = predicate;
        this.filterTuning = filterTuning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getBitmapResult(BitmapIndexSelector selector, BitmapResultFactory<T> bitmapResultFactory) {
        Context cx = Context.enter();
        try {
            T t = Filters.matchPredicate(this.dimension, selector, bitmapResultFactory, this.makeStringPredicate(cx));
            return t;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double estimateSelectivity(BitmapIndexSelector indexSelector) {
        Context cx = Context.enter();
        try {
            double d = Filters.estimateSelectivity(this.dimension, indexSelector, this.makeStringPredicate(cx));
            return d;
        }
        finally {
            Context.exit();
        }
    }

    private Predicate<String> makeStringPredicate(final Context context) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return JavaScriptFilter.this.predicateFactory.applyInContext(context, input);
            }
        };
    }

    @Override
    public ValueMatcher makeMatcher(ColumnSelectorFactory factory) {
        return Filters.makeValueMatcher(factory, this.dimension, this.predicateFactory);
    }

    @Override
    public boolean supportsBitmapIndex(BitmapIndexSelector selector) {
        return selector.getBitmapIndex(this.dimension) != null;
    }

    @Override
    public boolean shouldUseBitmapIndex(BitmapIndexSelector selector) {
        return Filters.shouldUseBitmapIndex(this, selector, this.filterTuning);
    }

    @Override
    public boolean supportsSelectivityEstimation(ColumnSelector columnSelector, BitmapIndexSelector indexSelector) {
        return Filters.supportsSelectivityEstimation(this, this.dimension, columnSelector, indexSelector);
    }

    @Override
    public Set<String> getRequiredColumns() {
        return ImmutableSet.of((Object)this.dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaScriptFilter that = (JavaScriptFilter)o;
        return Objects.equals(this.dimension, that.dimension) && Objects.equals(this.predicateFactory, that.predicateFactory) && Objects.equals(this.filterTuning, that.filterTuning);
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.predicateFactory, this.filterTuning);
    }
}

