/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.UnparseableColumnsParseException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractIndex;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DoubleColumnSelector;
import org.apache.druid.segment.EncodedKeyComponent;
import org.apache.druid.segment.FloatColumnSelector;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.LongColumnSelector;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedColumnSelectorFactory;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndexAddResult;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.segment.incremental.IndexSizeExceededException;
import org.apache.druid.segment.incremental.SpatialDimensionRowTransformer;
import org.apache.druid.segment.serde.ComplexMetricExtractor;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.segment.transform.Transformer;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class IncrementalIndex
extends AbstractIndex
implements Iterable<Row>,
Closeable,
ColumnInspector {
    private final long minTimestamp;
    private final Granularity gran;
    private final boolean rollup;
    private final List<Function<InputRow, InputRow>> rowTransformers;
    private final VirtualColumns virtualColumns;
    private final AggregatorFactory[] metrics;
    private final boolean deserializeComplexMetrics;
    private final Metadata metadata;
    protected final boolean preserveExistingMetrics;
    private final Map<String, MetricDesc> metricDescs;
    private final DimensionsSpec dimensionsSpec;
    private final Map<String, DimensionDesc> dimensionDescs;
    private final List<DimensionDesc> dimensionDescsList;
    private final Map<String, ColumnCapabilities> timeAndMetricsColumnCapabilities;
    private final AtomicInteger numEntries = new AtomicInteger();
    private final AtomicLong bytesInMemory = new AtomicLong();
    private final boolean useMaxMemoryEstimates;
    private final ThreadLocal<InputRow> in = new ThreadLocal();
    private final Supplier<InputRow> rowSupplier = this.in::get;
    private volatile DateTime maxIngestedEventTime;

    public static ColumnSelectorFactory makeColumnSelectorFactory(VirtualColumns virtualColumns, final AggregatorFactory agg, final Supplier<InputRow> in, final boolean deserializeComplexMetrics) {
        final RowBasedColumnSelectorFactory<InputRow> baseSelectorFactory = RowBasedColumnSelectorFactory.create(RowAdapters.standardRow(), () -> in.get(), RowSignature.empty(), true);
        class IncrementalIndexInputRowColumnSelectorFactory
        implements ColumnSelectorFactory {
            IncrementalIndexInputRowColumnSelectorFactory() {
            }

            @Override
            public ColumnValueSelector<?> makeColumnValueSelector(final String column) {
                boolean isComplexMetric = agg.getIntermediateType().is((TypeDescriptor)ValueType.COMPLEX);
                final ColumnValueSelector<?> selector = baseSelectorFactory.makeColumnValueSelector(column);
                if (!isComplexMetric || !deserializeComplexMetrics) {
                    return selector;
                }
                String complexTypeName = agg.getIntermediateType().getComplexTypeName();
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(complexTypeName);
                if (serde == null) {
                    throw new ISE("Don't know how to handle type[%s]", new Object[]{complexTypeName});
                }
                final ComplexMetricExtractor extractor = serde.getExtractor();
                return new ColumnValueSelector(){

                    @Override
                    public boolean isNull() {
                        return selector.isNull();
                    }

                    @Override
                    public long getLong() {
                        return selector.getLong();
                    }

                    @Override
                    public float getFloat() {
                        return selector.getFloat();
                    }

                    @Override
                    public double getDouble() {
                        return selector.getDouble();
                    }

                    @Override
                    public Class classOfObject() {
                        return extractor.extractedClass();
                    }

                    @Override
                    @Nullable
                    public Object getObject() {
                        return extractor.extractValue((InputRow)in.get(), column, agg);
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("in", in);
                        inspector.visit("selector", selector);
                        inspector.visit("extractor", extractor);
                    }
                };
            }

            @Override
            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                return baseSelectorFactory.makeDimensionSelector(dimensionSpec);
            }

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String columnName) {
                return baseSelectorFactory.getColumnCapabilities(columnName);
            }
        }
        return virtualColumns.wrap(new IncrementalIndexInputRowColumnSelectorFactory());
    }

    protected IncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean concurrentEventAdd, boolean preserveExistingMetrics, boolean useMaxMemoryEstimates) {
        this.minTimestamp = incrementalIndexSchema.getMinTimestamp();
        this.gran = incrementalIndexSchema.getGran();
        this.rollup = incrementalIndexSchema.isRollup();
        this.virtualColumns = incrementalIndexSchema.getVirtualColumns();
        this.metrics = incrementalIndexSchema.getMetrics();
        this.rowTransformers = new CopyOnWriteArrayList<Function<InputRow, InputRow>>();
        this.deserializeComplexMetrics = deserializeComplexMetrics;
        this.preserveExistingMetrics = preserveExistingMetrics;
        this.useMaxMemoryEstimates = useMaxMemoryEstimates;
        this.timeAndMetricsColumnCapabilities = new HashMap<String, ColumnCapabilities>();
        this.metricDescs = Maps.newLinkedHashMap();
        this.dimensionDescs = Maps.newLinkedHashMap();
        this.metadata = new Metadata(null, IncrementalIndex.getCombiningAggregators(this.metrics), incrementalIndexSchema.getTimestampSpec(), this.gran, this.rollup);
        this.initAggs(this.metrics, this.rowSupplier, deserializeComplexMetrics, concurrentEventAdd);
        for (AggregatorFactory metric : this.metrics) {
            MetricDesc metricDesc = new MetricDesc(this.metricDescs.size(), metric);
            this.metricDescs.put(metricDesc.getName(), metricDesc);
            this.timeAndMetricsColumnCapabilities.put(metricDesc.getName(), metricDesc.getCapabilities());
        }
        this.dimensionsSpec = incrementalIndexSchema.getDimensionsSpec();
        this.dimensionDescsList = new ArrayList<DimensionDesc>();
        for (DimensionSchema dimSchema : this.dimensionsSpec.getDimensions()) {
            ColumnType type = dimSchema.getColumnType();
            String dimName = dimSchema.getName();
            ColumnCapabilitiesImpl capabilities = this.makeDefaultCapabilitiesFromValueType(type);
            capabilities.setHasBitmapIndexes(dimSchema.hasBitmapIndex());
            if (dimSchema.getTypeName().equals("spatial")) {
                capabilities.setHasSpatialIndexes(true);
            }
            DimensionHandler<?, ?, ?> handler = DimensionHandlerUtils.getHandlerFromCapabilities(dimName, capabilities, dimSchema.getMultiValueHandling());
            this.addNewDimension(dimName, handler);
        }
        this.timeAndMetricsColumnCapabilities.put("__time", ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)ColumnType.LONG));
        List spatialDimensions = this.dimensionsSpec.getSpatialDimensions();
        if (!spatialDimensions.isEmpty()) {
            this.rowTransformers.add(new SpatialDimensionRowTransformer(spatialDimensions));
        }
    }

    public abstract FactsHolder getFacts();

    public abstract boolean canAppendRow();

    public abstract String getOutOfRowsReason();

    protected abstract void initAggs(AggregatorFactory[] var1, Supplier<InputRow> var2, boolean var3, boolean var4);

    protected abstract AddToFactsResult addToFacts(InputRow var1, IncrementalIndexRow var2, ThreadLocal<InputRow> var3, Supplier<InputRow> var4, boolean var5) throws IndexSizeExceededException;

    public abstract int getLastRowIndex();

    protected abstract float getMetricFloatValue(int var1, int var2);

    protected abstract long getMetricLongValue(int var1, int var2);

    protected abstract Object getMetricObjectValue(int var1, int var2);

    protected abstract double getMetricDoubleValue(int var1, int var2);

    protected abstract boolean isNull(int var1, int var2);

    public boolean isRollup() {
        return this.rollup;
    }

    @Override
    public void close() {
    }

    public InputRow formatRow(InputRow row) {
        for (Function<InputRow, InputRow> rowTransformer : this.rowTransformers) {
            row = (InputRow)rowTransformer.apply((Object)row);
        }
        if (row == null) {
            throw new IAE("Row is null? How can this be?!", new Object[0]);
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ColumnCapabilities> getColumnCapabilities() {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(this.timeAndMetricsColumnCapabilities);
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            this.dimensionDescs.forEach((? super K dimension, ? super V desc) -> builder.put(dimension, (Object)desc.getCapabilities()));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.timeAndMetricsColumnCapabilities.containsKey(columnName)) {
            return this.timeAndMetricsColumnCapabilities.get(columnName);
        }
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            if (this.dimensionDescs.containsKey(columnName)) {
                return this.dimensionDescs.get(columnName).getCapabilities();
            }
        }
        return null;
    }

    public IncrementalIndexAddResult add(InputRow row) throws IndexSizeExceededException {
        return this.add(row, false);
    }

    public IncrementalIndexAddResult add(InputRow row, boolean skipMaxRowsInMemoryCheck) throws IndexSizeExceededException {
        IncrementalIndexRowResult incrementalIndexRowResult = this.toIncrementalIndexRow(row);
        AddToFactsResult addToFactsResult = this.addToFacts(row, incrementalIndexRowResult.getIncrementalIndexRow(), this.in, this.rowSupplier, skipMaxRowsInMemoryCheck);
        this.updateMaxIngestedTime(row.getTimestamp());
        ParseException parseException = IncrementalIndex.getCombinedParseException(row, incrementalIndexRowResult.getParseExceptionMessages(), addToFactsResult.getParseExceptionMessages());
        return new IncrementalIndexAddResult(addToFactsResult.getRowCount(), addToFactsResult.getBytesInMemory(), parseException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    IncrementalIndexRowResult toIncrementalIndexRow(InputRow row) {
        Object[] dims;
        if ((row = this.formatRow(row)).getTimestampFromEpoch() < this.minTimestamp) {
            throw new IAE("Cannot add row[%s] because it is below the minTimestamp[%s]", new Object[]{row, DateTimes.utc((long)this.minTimestamp)});
        }
        List rowDimensions = row.getDimensions();
        ArrayList overflow = null;
        long dimsKeySize = 0L;
        ArrayList<String> parseExceptionMessages = new ArrayList<String>();
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            HashSet absentDimensions = Sets.newHashSet(this.dimensionDescs.keySet());
            dims = new Object[this.dimensionDescs.size()];
            for (String dimension : rowDimensions) {
                if (Strings.isNullOrEmpty((String)dimension)) continue;
                boolean wasNewDim = false;
                DimensionDesc desc = this.dimensionDescs.get(dimension);
                if (desc != null) {
                    absentDimensions.remove(dimension);
                } else {
                    wasNewDim = true;
                    desc = this.addNewDimension(dimension, DimensionHandlerUtils.getHandlerFromCapabilities(dimension, this.makeDefaultCapabilitiesFromValueType(ColumnType.STRING), null));
                }
                DimensionIndexer indexer = desc.getIndexer();
                Object dimsKey = null;
                try {
                    EncodedKeyComponent encodedKeyComponent = indexer.processRowValsToUnsortedEncodedKeyComponent(row.getRaw(dimension), true);
                    dimsKey = encodedKeyComponent.getComponent();
                    dimsKeySize += encodedKeyComponent.getEffectiveSizeBytes();
                }
                catch (ParseException pe) {
                    parseExceptionMessages.add(pe.getMessage());
                }
                if (wasNewDim) {
                    if (this.maxIngestedEventTime != null) {
                        indexer.setSparseIndexed();
                    }
                    if (overflow == null) {
                        overflow = new ArrayList();
                    }
                    overflow.add(dimsKey);
                    continue;
                }
                if (desc.getIndex() > dims.length || dims[desc.getIndex()] != null) {
                    throw new ISE("Dimension[%s] occurred more than once in InputRow", new Object[]{dimension});
                }
                dims[desc.getIndex()] = dimsKey;
            }
            for (String missing : absentDimensions) {
                this.dimensionDescs.get(missing).getIndexer().setSparseIndexed();
            }
        }
        if (overflow != null) {
            Object[] newDims = new Object[dims.length + overflow.size()];
            System.arraycopy(dims, 0, newDims, 0, dims.length);
            for (int i = 0; i < overflow.size(); ++i) {
                newDims[dims.length + i] = overflow.get(i);
            }
            dims = newDims;
        }
        long truncated = 0L;
        if (row.getTimestamp() != null) {
            truncated = this.gran.bucketStart(row.getTimestampFromEpoch());
        }
        IncrementalIndexRow incrementalIndexRow = IncrementalIndexRow.createTimeAndDimswithDimsKeySize(Math.max(truncated, this.minTimestamp), dims, this.dimensionDescsList, dimsKeySize);
        return new IncrementalIndexRowResult(incrementalIndexRow, parseExceptionMessages);
    }

    @Nullable
    public static ParseException getCombinedParseException(InputRow row, @Nullable List<String> dimParseExceptionMessages, @Nullable List<String> aggParseExceptionMessages) {
        int numAdded = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> details = new ArrayList<String>();
        if (dimParseExceptionMessages != null) {
            details.addAll(dimParseExceptionMessages);
            for (String parseExceptionMessage : dimParseExceptionMessages) {
                stringBuilder.append(parseExceptionMessage);
                stringBuilder.append(",");
                ++numAdded;
            }
        }
        if (aggParseExceptionMessages != null) {
            details.addAll(aggParseExceptionMessages);
            for (String parseExceptionMessage : aggParseExceptionMessages) {
                stringBuilder.append(parseExceptionMessage);
                stringBuilder.append(",");
                ++numAdded;
            }
        }
        if (numAdded == 0) {
            return null;
        }
        int messageLen = stringBuilder.length();
        if (messageLen > 0) {
            stringBuilder.delete(messageLen - 1, messageLen);
        }
        String eventString = IncrementalIndex.getSimplifiedEventStringFromRow(row);
        return new UnparseableColumnsParseException(eventString, details, true, "Found unparseable columns in row: [%s], exceptions: [%s]", new Object[]{IncrementalIndex.getSimplifiedEventStringFromRow(row), stringBuilder.toString()});
    }

    private static String getSimplifiedEventStringFromRow(InputRow inputRow) {
        InputRow innerRow;
        if (inputRow instanceof MapBasedInputRow) {
            return ((MapBasedInputRow)inputRow).getEvent().toString();
        }
        if (inputRow instanceof Transformer.TransformedInputRow && (innerRow = ((Transformer.TransformedInputRow)inputRow).getRow()) instanceof MapBasedInputRow) {
            return ((MapBasedInputRow)innerRow).getEvent().toString();
        }
        return inputRow.toString();
    }

    private synchronized void updateMaxIngestedTime(DateTime eventTime) {
        if (this.maxIngestedEventTime == null || this.maxIngestedEventTime.isBefore((ReadableInstant)eventTime)) {
            this.maxIngestedEventTime = eventTime;
        }
    }

    public boolean isEmpty() {
        return this.numEntries.get() == 0;
    }

    public int size() {
        return this.numEntries.get();
    }

    boolean getDeserializeComplexMetrics() {
        return this.deserializeComplexMetrics;
    }

    AtomicInteger getNumEntries() {
        return this.numEntries;
    }

    AggregatorFactory[] getMetrics() {
        return this.metrics;
    }

    public AtomicLong getBytesInMemory() {
        return this.bytesInMemory;
    }

    private long getMinTimeMillis() {
        return this.getFacts().getMinTimeMillis();
    }

    private long getMaxTimeMillis() {
        return this.getFacts().getMaxTimeMillis();
    }

    public AggregatorFactory[] getMetricAggs() {
        return this.metrics;
    }

    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDimensionNames() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DimensionDesc> getDimensions() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DimensionDesc getDimension(String dimension) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return this.dimensionDescs.get(dimension);
        }
    }

    @Nullable
    public String getMetricType(String metric) {
        MetricDesc metricDesc = this.metricDescs.get(metric);
        return metricDesc != null ? metricDesc.getType() : null;
    }

    public ColumnValueSelector<?> makeMetricColumnValueSelector(String metric, IncrementalIndexRowHolder currEntry) {
        MetricDesc metricDesc = this.metricDescs.get(metric);
        if (metricDesc == null) {
            return NilColumnValueSelector.instance();
        }
        int metricIndex = metricDesc.getIndex();
        switch (metricDesc.getCapabilities().getType()) {
            case COMPLEX: {
                return new ObjectMetricColumnSelector(metricDesc, currEntry, metricIndex);
            }
            case LONG: {
                return new LongMetricColumnSelector(currEntry, metricIndex);
            }
            case FLOAT: {
                return new FloatMetricColumnSelector(currEntry, metricIndex);
            }
            case DOUBLE: {
                return new DoubleMetricColumnSelector(currEntry, metricIndex);
            }
            case STRING: {
                throw new IllegalStateException("String is not a metric column type");
            }
        }
        throw new ISE("Unknown metric value type: %s", new Object[]{metricDesc.getCapabilities().getType()});
    }

    public Interval getInterval() {
        DateTime min = DateTimes.utc((long)this.minTimestamp);
        return new Interval((ReadableInstant)min, (ReadableInstant)(this.isEmpty() ? min : this.gran.increment(DateTimes.utc((long)this.getMaxTimeMillis()))));
    }

    @Nullable
    public DateTime getMinTime() {
        return this.isEmpty() ? null : DateTimes.utc((long)this.getMinTimeMillis());
    }

    @Nullable
    public DateTime getMaxTime() {
        return this.isEmpty() ? null : DateTimes.utc((long)this.getMaxTimeMillis());
    }

    @Nullable
    public Integer getDimensionIndex(String dimension) {
        DimensionDesc dimSpec = this.getDimension(dimension);
        return dimSpec == null ? null : Integer.valueOf(dimSpec.getIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDimensionOrder() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.keySet());
        }
    }

    private ColumnCapabilitiesImpl makeDefaultCapabilitiesFromValueType(ColumnType type) {
        switch ((ValueType)type.getType()) {
            case STRING: {
                return new ColumnCapabilitiesImpl().setType(type).setHasBitmapIndexes(true).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(false);
            }
            case COMPLEX: {
                return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)type).setHasNulls(true);
            }
        }
        return ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDimensionIterable(Iterable<String> oldDimensionOrder, Map<String, ColumnCapabilities> oldColumnCapabilities) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            if (!this.dimensionDescs.isEmpty()) {
                throw new ISE("Cannot load dimension order when existing order[%s] is not empty.", new Object[]{this.dimensionDescs.keySet()});
            }
            for (String dim : oldDimensionOrder) {
                if (this.dimensionDescs.get(dim) != null) continue;
                ColumnCapabilitiesImpl capabilities = ColumnCapabilitiesImpl.snapshot(oldColumnCapabilities.get(dim), IndexMergerV9.DIMENSION_CAPABILITY_MERGE_LOGIC);
                DimensionHandler<?, ?, ?> handler = DimensionHandlerUtils.getHandlerFromCapabilities(dim, capabilities, null);
                this.addNewDimension(dim, handler);
            }
        }
    }

    @GuardedBy(value="dimensionDescs")
    private DimensionDesc addNewDimension(String dim, DimensionHandler handler) {
        DimensionDesc desc = this.initDimension(this.dimensionDescs.size(), dim, handler);
        this.dimensionDescs.put(dim, desc);
        this.dimensionDescsList.add(desc);
        return desc;
    }

    private DimensionDesc initDimension(int dimensionIndex, String dimensionName, DimensionHandler dimensionHandler) {
        return new DimensionDesc(dimensionIndex, dimensionName, dimensionHandler, this.useMaxMemoryEstimates);
    }

    public List<String> getMetricNames() {
        return ImmutableList.copyOf(this.metricDescs.keySet());
    }

    @Override
    public List<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>(this.getDimensionNames());
        columnNames.addAll(this.getMetricNames());
        return columnNames;
    }

    @Override
    public StorageAdapter toStorageAdapter() {
        return new IncrementalIndexStorageAdapter(this);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private static AggregatorFactory[] getCombiningAggregators(AggregatorFactory[] aggregators) {
        AggregatorFactory[] combiningAggregators = new AggregatorFactory[aggregators.length];
        for (int i = 0; i < aggregators.length; ++i) {
            combiningAggregators[i] = aggregators[i].getCombiningFactory();
        }
        return combiningAggregators;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iterableWithPostAggregations(null, false).iterator();
    }

    public abstract Iterable<Row> iterableWithPostAggregations(@Nullable List<PostAggregator> var1, boolean var2);

    public DateTime getMaxIngestedEventTime() {
        return this.maxIngestedEventTime;
    }

    protected ColumnSelectorFactory makeColumnSelectorFactory(AggregatorFactory agg, Supplier<InputRow> in, boolean deserializeComplexMetrics) {
        return IncrementalIndex.makeColumnSelectorFactory(this.virtualColumns, agg, in, deserializeComplexMetrics);
    }

    protected final Comparator<IncrementalIndexRow> dimsComparator() {
        return new IncrementalIndexRowComparator(this.dimensionDescsList);
    }

    private static boolean allNull(Object[] dims, int startPosition) {
        for (int i = startPosition; i < dims.length; ++i) {
            if (dims[i] == null) continue;
            return false;
        }
        return true;
    }

    private class DoubleMetricColumnSelector
    implements DoubleColumnSelector {
        private final IncrementalIndexRowHolder currEntry;
        private final int metricIndex;

        public DoubleMetricColumnSelector(IncrementalIndexRowHolder currEntry, int metricIndex) {
            this.currEntry = currEntry;
            this.metricIndex = metricIndex;
        }

        @Override
        public double getDouble() {
            assert (NullHandling.replaceWithDefault() || !this.isNull());
            return IncrementalIndex.this.getMetricDoubleValue(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public boolean isNull() {
            return IncrementalIndex.this.isNull(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("index", IncrementalIndex.this);
        }
    }

    private class FloatMetricColumnSelector
    implements FloatColumnSelector {
        private final IncrementalIndexRowHolder currEntry;
        private final int metricIndex;

        public FloatMetricColumnSelector(IncrementalIndexRowHolder currEntry, int metricIndex) {
            this.currEntry = currEntry;
            this.metricIndex = metricIndex;
        }

        @Override
        public float getFloat() {
            assert (NullHandling.replaceWithDefault() || !this.isNull());
            return IncrementalIndex.this.getMetricFloatValue(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("index", IncrementalIndex.this);
        }

        @Override
        public boolean isNull() {
            return IncrementalIndex.this.isNull(this.currEntry.get().getRowIndex(), this.metricIndex);
        }
    }

    private class ObjectMetricColumnSelector
    extends ObjectColumnSelector {
        private final IncrementalIndexRowHolder currEntry;
        private final int metricIndex;
        private Class classOfObject;

        public ObjectMetricColumnSelector(MetricDesc metricDesc, IncrementalIndexRowHolder currEntry, int metricIndex) {
            this.currEntry = currEntry;
            this.metricIndex = metricIndex;
            this.classOfObject = ComplexMetrics.getSerdeForType(metricDesc.getType()).getObjectStrategy().getClazz();
        }

        @Override
        @Nullable
        public Object getObject() {
            return IncrementalIndex.this.getMetricObjectValue(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public Class classOfObject() {
            return this.classOfObject;
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("index", IncrementalIndex.this);
        }
    }

    private class LongMetricColumnSelector
    implements LongColumnSelector {
        private final IncrementalIndexRowHolder currEntry;
        private final int metricIndex;

        public LongMetricColumnSelector(IncrementalIndexRowHolder currEntry, int metricIndex) {
            this.currEntry = currEntry;
            this.metricIndex = metricIndex;
        }

        @Override
        public long getLong() {
            assert (NullHandling.replaceWithDefault() || !this.isNull());
            return IncrementalIndex.this.getMetricLongValue(this.currEntry.get().getRowIndex(), this.metricIndex);
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("index", IncrementalIndex.this);
        }

        @Override
        public boolean isNull() {
            return IncrementalIndex.this.isNull(this.currEntry.get().getRowIndex(), this.metricIndex);
        }
    }

    static class PlainFactsHolder
    implements FactsHolder {
        private final boolean sortFacts;
        private final ConcurrentMap<Long, Deque<IncrementalIndexRow>> facts;
        private final Comparator<IncrementalIndexRow> incrementalIndexRowComparator;

        public PlainFactsHolder(boolean sortFacts, Comparator<IncrementalIndexRow> incrementalIndexRowComparator) {
            this.sortFacts = sortFacts;
            this.facts = sortFacts ? new ConcurrentSkipListMap<Long, Deque<IncrementalIndexRow>>() : new ConcurrentHashMap<Long, Deque<IncrementalIndexRow>>();
            this.incrementalIndexRowComparator = incrementalIndexRowComparator;
        }

        @Override
        public int getPriorIndex(IncrementalIndexRow key) {
            return -1;
        }

        @Override
        public long getMinTimeMillis() {
            if (this.sortFacts) {
                return (Long)((ConcurrentNavigableMap)this.facts).firstKey();
            }
            throw new UnsupportedOperationException("can't get minTime from unsorted facts data.");
        }

        @Override
        public long getMaxTimeMillis() {
            if (this.sortFacts) {
                return (Long)((ConcurrentNavigableMap)this.facts).lastKey();
            }
            throw new UnsupportedOperationException("can't get maxTime from unsorted facts data.");
        }

        @Override
        public Iterator<IncrementalIndexRow> iterator(boolean descending) {
            if (descending && this.sortFacts) {
                return this.timeOrderedConcat(((ConcurrentNavigableMap)this.facts).descendingMap().values(), true).iterator();
            }
            return this.timeOrderedConcat(this.facts.values(), false).iterator();
        }

        @Override
        public Iterable<IncrementalIndexRow> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            SortedMap subMap = ((ConcurrentNavigableMap)this.facts).subMap((Object)timeStart, (Object)timeEnd);
            SortedMap rangeMap = descending ? subMap.descendingMap() : subMap;
            return this.timeOrderedConcat(rangeMap.values(), descending);
        }

        private Iterable<IncrementalIndexRow> timeOrderedConcat(Iterable<Deque<IncrementalIndexRow>> iterable, boolean descending) {
            return () -> Iterators.concat((Iterator)Iterators.transform(iterable.iterator(), input -> descending ? input.descendingIterator() : input.iterator()));
        }

        private Stream<IncrementalIndexRow> timeAndDimsOrderedConcat(Collection<Deque<IncrementalIndexRow>> rowGroups) {
            return rowGroups.stream().flatMap(Collection::stream).sorted(this.incrementalIndexRowComparator);
        }

        @Override
        public Iterable<IncrementalIndexRow> keySet() {
            return this.timeOrderedConcat(this.facts.values(), false);
        }

        @Override
        public Iterable<IncrementalIndexRow> persistIterable() {
            return () -> this.timeAndDimsOrderedConcat(this.facts.values()).iterator();
        }

        @Override
        public int putIfAbsent(IncrementalIndexRow key, int rowIndex) {
            Long time = key.getTimestamp();
            Deque rows = (Deque)this.facts.get(time);
            if (rows == null) {
                this.facts.putIfAbsent(time, new ConcurrentLinkedDeque());
                rows = (Deque)this.facts.get(time);
            }
            key.setRowIndex(rowIndex);
            rows.add(key);
            return -1;
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    static class RollupFactsHolder
    implements FactsHolder {
        private final boolean sortFacts;
        private final ConcurrentMap<IncrementalIndexRow, IncrementalIndexRow> facts;
        private final List<DimensionDesc> dimensionDescsList;

        RollupFactsHolder(boolean sortFacts, Comparator<IncrementalIndexRow> incrementalIndexRowComparator, List<DimensionDesc> dimensionDescsList) {
            this.sortFacts = sortFacts;
            this.facts = sortFacts ? new ConcurrentSkipListMap<IncrementalIndexRow, IncrementalIndexRow>(incrementalIndexRowComparator) : new ConcurrentHashMap<IncrementalIndexRow, IncrementalIndexRow>();
            this.dimensionDescsList = dimensionDescsList;
        }

        @Override
        public int getPriorIndex(IncrementalIndexRow key) {
            IncrementalIndexRow row = (IncrementalIndexRow)this.facts.get(key);
            return row == null ? -1 : row.getRowIndex();
        }

        @Override
        public long getMinTimeMillis() {
            if (this.sortFacts) {
                return ((IncrementalIndexRow)((ConcurrentNavigableMap)this.facts).firstKey()).getTimestamp();
            }
            throw new UnsupportedOperationException("can't get minTime from unsorted facts data.");
        }

        @Override
        public long getMaxTimeMillis() {
            if (this.sortFacts) {
                return ((IncrementalIndexRow)((ConcurrentNavigableMap)this.facts).lastKey()).getTimestamp();
            }
            throw new UnsupportedOperationException("can't get maxTime from unsorted facts data.");
        }

        @Override
        public Iterator<IncrementalIndexRow> iterator(boolean descending) {
            if (descending && this.sortFacts) {
                return ((ConcurrentNavigableMap)this.facts).descendingMap().keySet().iterator();
            }
            return this.keySet().iterator();
        }

        @Override
        public Iterable<IncrementalIndexRow> timeRangeIterable(boolean descending, long timeStart, long timeEnd) {
            if (!this.sortFacts) {
                throw new UnsupportedOperationException("can't get timeRange from unsorted facts data.");
            }
            IncrementalIndexRow start = new IncrementalIndexRow(timeStart, new Object[0], this.dimensionDescsList);
            IncrementalIndexRow end = new IncrementalIndexRow(timeEnd, new Object[0], this.dimensionDescsList);
            SortedMap subMap = ((ConcurrentNavigableMap)this.facts).subMap(start, end);
            SortedMap rangeMap = descending ? subMap.descendingMap() : subMap;
            return rangeMap.keySet();
        }

        @Override
        public Iterable<IncrementalIndexRow> keySet() {
            return this.facts.keySet();
        }

        @Override
        public Iterable<IncrementalIndexRow> persistIterable() {
            return this.keySet();
        }

        @Override
        public int putIfAbsent(IncrementalIndexRow key, int rowIndex) {
            key.setRowIndex(rowIndex);
            IncrementalIndexRow prev = this.facts.putIfAbsent(key, key);
            return prev == null ? -1 : prev.getRowIndex();
        }

        @Override
        public void clear() {
            this.facts.clear();
        }
    }

    static interface FactsHolder {
        public int getPriorIndex(IncrementalIndexRow var1);

        public long getMinTimeMillis();

        public long getMaxTimeMillis();

        public Iterator<IncrementalIndexRow> iterator(boolean var1);

        public Iterable<IncrementalIndexRow> timeRangeIterable(boolean var1, long var2, long var4);

        public Iterable<IncrementalIndexRow> keySet();

        public Iterable<IncrementalIndexRow> persistIterable();

        public int putIfAbsent(IncrementalIndexRow var1, int var2);

        public void clear();
    }

    @VisibleForTesting
    static final class IncrementalIndexRowComparator
    implements Comparator<IncrementalIndexRow> {
        private List<DimensionDesc> dimensionDescs;

        public IncrementalIndexRowComparator(List<DimensionDesc> dimDescs) {
            this.dimensionDescs = dimDescs;
        }

        @Override
        public int compare(IncrementalIndexRow lhs, IncrementalIndexRow rhs) {
            int retVal = Longs.compare((long)lhs.timestamp, (long)rhs.timestamp);
            int numComparisons = Math.min(lhs.dims.length, rhs.dims.length);
            int index = 0;
            while (retVal == 0 && index < numComparisons) {
                Object lhsIdxs = lhs.dims[index];
                Object rhsIdxs = rhs.dims[index];
                if (lhsIdxs == null) {
                    if (rhsIdxs == null) {
                        ++index;
                        continue;
                    }
                    return -1;
                }
                if (rhsIdxs == null) {
                    return 1;
                }
                DimensionIndexer indexer = this.dimensionDescs.get(index).getIndexer();
                retVal = indexer.compareUnsortedEncodedKeyComponents(lhsIdxs, rhsIdxs);
                ++index;
            }
            if (retVal == 0) {
                int lengthDiff = Ints.compare((int)lhs.dims.length, (int)rhs.dims.length);
                if (lengthDiff == 0) {
                    return 0;
                }
                Object[] largerDims = lengthDiff > 0 ? lhs.dims : rhs.dims;
                return IncrementalIndex.allNull(largerDims, numComparisons) ? 0 : lengthDiff;
            }
            return retVal;
        }
    }

    public static final class MetricDesc {
        private final int index;
        private final String name;
        private final String type;
        private final ColumnCapabilities capabilities;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public MetricDesc(int index, AggregatorFactory factory) {
            this.index = index;
            this.name = factory.getName();
            ColumnType valueType = factory.getIntermediateType();
            if (valueType.isNumeric()) {
                this.capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)valueType);
                this.type = valueType.toString();
                return;
            } else {
                if (!valueType.is((TypeDescriptor)ValueType.COMPLEX)) throw new ISE("Unable to handle type[%s] for AggregatorFactory[%s]", new Object[]{valueType, factory.getClass()});
                this.capabilities = ColumnCapabilitiesImpl.createSimpleNumericColumnCapabilities((TypeSignature<ValueType>)valueType).setHasNulls(ColumnCapabilities.Capable.TRUE);
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(valueType.getComplexTypeName());
                if (serde == null) throw new ISE("Unable to handle complex type[%s]", new Object[]{valueType});
                this.type = serde.getTypeName();
            }
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public ColumnCapabilities getCapabilities() {
            return this.capabilities;
        }
    }

    public static final class DimensionDesc {
        private final int index;
        private final String name;
        private final DimensionHandler handler;
        private final DimensionIndexer indexer;

        public DimensionDesc(int index, String name, DimensionHandler handler, boolean useMaxMemoryEstimates) {
            this.index = index;
            this.name = name;
            this.handler = handler;
            this.indexer = handler.makeIndexer(useMaxMemoryEstimates);
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public ColumnCapabilities getCapabilities() {
            return this.indexer.getColumnCapabilities();
        }

        public DimensionHandler getHandler() {
            return this.handler;
        }

        public DimensionIndexer getIndexer() {
            return this.indexer;
        }
    }

    static class AddToFactsResult {
        private final int rowCount;
        private final long bytesInMemory;
        private final List<String> parseExceptionMessages;

        public AddToFactsResult(int rowCount, long bytesInMemory, List<String> parseExceptionMessages) {
            this.rowCount = rowCount;
            this.bytesInMemory = bytesInMemory;
            this.parseExceptionMessages = parseExceptionMessages;
        }

        int getRowCount() {
            return this.rowCount;
        }

        public long getBytesInMemory() {
            return this.bytesInMemory;
        }

        public List<String> getParseExceptionMessages() {
            return this.parseExceptionMessages;
        }
    }

    static class IncrementalIndexRowResult {
        private final IncrementalIndexRow incrementalIndexRow;
        private final List<String> parseExceptionMessages;

        IncrementalIndexRowResult(IncrementalIndexRow incrementalIndexRow, List<String> parseExceptionMessages) {
            this.incrementalIndexRow = incrementalIndexRow;
            this.parseExceptionMessages = parseExceptionMessages;
        }

        IncrementalIndexRow getIncrementalIndexRow() {
            return this.incrementalIndexRow;
        }

        List<String> getParseExceptionMessages() {
            return this.parseExceptionMessages;
        }
    }
}

