/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.java.util.common.parsers.UnparseableColumnsParseException;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.utils.CircularBuffer;

public class ParseExceptionHandler {
    private static final Logger LOG = new Logger(ParseExceptionHandler.class);
    private final RowIngestionMeters rowIngestionMeters;
    private final boolean logParseExceptions;
    private final int maxAllowedParseExceptions;
    @Nullable
    private final CircularBuffer<ParseExceptionReport> savedParseExceptionReports;

    public ParseExceptionHandler(RowIngestionMeters rowIngestionMeters, boolean logParseExceptions, int maxAllowedParseExceptions, int maxSavedParseExceptions) {
        this.rowIngestionMeters = (RowIngestionMeters)Preconditions.checkNotNull((Object)rowIngestionMeters, (Object)"rowIngestionMeters");
        this.logParseExceptions = logParseExceptions;
        this.maxAllowedParseExceptions = maxAllowedParseExceptions;
        this.savedParseExceptionReports = maxSavedParseExceptions > 0 ? new CircularBuffer(maxSavedParseExceptions) : null;
    }

    public void handle(@Nullable ParseException e) {
        if (e == null) {
            return;
        }
        if (e.isFromPartiallyValidRow()) {
            this.rowIngestionMeters.incrementProcessedWithError();
        } else {
            this.rowIngestionMeters.incrementUnparseable();
        }
        if (this.logParseExceptions) {
            LOG.error((Throwable)e, "Encountered parse exception", new Object[0]);
        }
        if (this.savedParseExceptionReports != null) {
            ParseExceptionReport parseExceptionReport = new ParseExceptionReport(e.getInput(), e.isFromPartiallyValidRow() ? "processedWithError" : "unparseable", e.isFromPartiallyValidRow() ? ((UnparseableColumnsParseException)e).getColumnExceptionMessages() : ImmutableList.of((Object)e.getMessage()), e.getTimeOfExceptionMillis());
            this.savedParseExceptionReports.add((Object)parseExceptionReport);
        }
        if (this.rowIngestionMeters.getUnparseable() + this.rowIngestionMeters.getProcessedWithError() > (long)this.maxAllowedParseExceptions) {
            throw new RE("Max parse exceptions[%s] exceeded", new Object[]{this.maxAllowedParseExceptions});
        }
    }

    @Nullable
    public CircularBuffer<ParseExceptionReport> getSavedParseExceptionReports() {
        return this.savedParseExceptionReports;
    }
}

