/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.data.GenericIndexed;

public class StringBitmapIndexColumnPartSupplier
implements Supplier<BitmapIndex> {
    private final BitmapFactory bitmapFactory;
    private final GenericIndexed<ImmutableBitmap> bitmaps;
    private final GenericIndexed<String> dictionary;

    public StringBitmapIndexColumnPartSupplier(BitmapFactory bitmapFactory, GenericIndexed<ImmutableBitmap> bitmaps, GenericIndexed<String> dictionary) {
        this.bitmapFactory = bitmapFactory;
        this.bitmaps = bitmaps;
        this.dictionary = dictionary;
    }

    public BitmapIndex get() {
        return new BitmapIndex(){

            @Override
            public int getCardinality() {
                return StringBitmapIndexColumnPartSupplier.this.dictionary.size();
            }

            @Override
            public String getValue(int index) {
                return (String)StringBitmapIndexColumnPartSupplier.this.dictionary.get(index);
            }

            @Override
            public boolean hasNulls() {
                return StringBitmapIndexColumnPartSupplier.this.dictionary.indexOf(null) >= 0;
            }

            @Override
            public BitmapFactory getBitmapFactory() {
                return StringBitmapIndexColumnPartSupplier.this.bitmapFactory;
            }

            @Override
            public int getIndex(@Nullable String value) {
                return StringBitmapIndexColumnPartSupplier.this.dictionary.indexOf(value);
            }

            @Override
            public ImmutableBitmap getBitmap(int idx) {
                if (idx < 0) {
                    return StringBitmapIndexColumnPartSupplier.this.bitmapFactory.makeEmptyImmutableBitmap();
                }
                ImmutableBitmap bitmap = (ImmutableBitmap)StringBitmapIndexColumnPartSupplier.this.bitmaps.get(idx);
                return bitmap == null ? StringBitmapIndexColumnPartSupplier.this.bitmapFactory.makeEmptyImmutableBitmap() : bitmap;
            }
        };
    }
}

