/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.vector;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.DictionaryEncodedColumn;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class QueryableIndexVectorColumnSelectorFactory
implements VectorColumnSelectorFactory {
    private final VirtualColumns virtualColumns;
    private final QueryableIndex index;
    private final ReadableVectorOffset offset;
    private final Closer closer;
    private final Map<String, BaseColumn> columnCache;
    private final Map<DimensionSpec, SingleValueDimensionVectorSelector> singleValueDimensionSelectorCache;
    private final Map<DimensionSpec, MultiValueDimensionVectorSelector> multiValueDimensionSelectorCache;
    private final Map<String, VectorValueSelector> valueSelectorCache;
    private final Map<String, VectorObjectSelector> objectSelectorCache;

    public QueryableIndexVectorColumnSelectorFactory(QueryableIndex index, ReadableVectorOffset offset, Closer closer, Map<String, BaseColumn> columnCache, VirtualColumns virtualColumns) {
        this.index = index;
        this.offset = offset;
        this.closer = closer;
        this.virtualColumns = virtualColumns;
        this.columnCache = columnCache;
        this.singleValueDimensionSelectorCache = new HashMap<DimensionSpec, SingleValueDimensionVectorSelector>();
        this.multiValueDimensionSelectorCache = new HashMap<DimensionSpec, MultiValueDimensionVectorSelector>();
        this.valueSelectorCache = new HashMap<String, VectorValueSelector>();
        this.objectSelectorCache = new HashMap<String, VectorObjectSelector>();
    }

    @Override
    public ReadableVectorInspector getReadableVectorInspector() {
        return this.offset;
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueDimensionSelector(DimensionSpec dimensionSpec) {
        if (!dimensionSpec.canVectorize()) {
            throw new ISE("DimensionSpec[%s] cannot be vectorized", new Object[]{dimensionSpec});
        }
        Function<DimensionSpec, MultiValueDimensionVectorSelector> mappingFunction = spec -> {
            if (this.virtualColumns.exists(spec.getDimension())) {
                MultiValueDimensionVectorSelector dimensionSelector = this.virtualColumns.makeMultiValueDimensionVectorSelector(dimensionSpec, this.index, this.offset);
                if (dimensionSelector == null) {
                    return this.virtualColumns.makeMultiValueDimensionVectorSelector(dimensionSpec, this);
                }
                return dimensionSelector;
            }
            ColumnHolder holder = this.index.getColumnHolder(spec.getDimension());
            if (holder == null || holder.getCapabilities().isDictionaryEncoded().isFalse() || !holder.getCapabilities().is((TypeDescriptor)ValueType.STRING) || holder.getCapabilities().hasMultipleValues().isFalse()) {
                throw new ISE("Column[%s] is not a multi-value string column, do not ask for a multi-value selector", new Object[]{spec.getDimension()});
            }
            DictionaryEncodedColumn dictionaryEncodedColumn = (DictionaryEncodedColumn)this.getCachedColumn(spec.getDimension());
            assert (dictionaryEncodedColumn != null);
            MultiValueDimensionVectorSelector selector = dictionaryEncodedColumn.makeMultiValueDimensionVectorSelector(this.offset);
            return spec.decorate(selector);
        };
        MultiValueDimensionVectorSelector selector = this.multiValueDimensionSelectorCache.get(dimensionSpec);
        if (selector == null) {
            selector = mappingFunction.apply(dimensionSpec);
            this.multiValueDimensionSelectorCache.put(dimensionSpec, selector);
        }
        return selector;
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueDimensionSelector(DimensionSpec dimensionSpec) {
        if (!dimensionSpec.canVectorize()) {
            throw new ISE("DimensionSpec[%s] cannot be vectorized", new Object[]{dimensionSpec});
        }
        Function<DimensionSpec, SingleValueDimensionVectorSelector> mappingFunction = spec -> {
            if (this.virtualColumns.exists(spec.getDimension())) {
                SingleValueDimensionVectorSelector dimensionSelector = this.virtualColumns.makeSingleValueDimensionVectorSelector(dimensionSpec, this.index, this.offset);
                if (dimensionSelector == null) {
                    return this.virtualColumns.makeSingleValueDimensionVectorSelector(dimensionSpec, this);
                }
                return dimensionSelector;
            }
            ColumnHolder holder = this.index.getColumnHolder(spec.getDimension());
            if (holder == null || !holder.getCapabilities().isDictionaryEncoded().isTrue() || !holder.getCapabilities().is((TypeDescriptor)ValueType.STRING)) {
                return NilVectorSelector.create(this.offset);
            }
            if (holder.getCapabilities().hasMultipleValues().isMaybeTrue()) {
                throw new ISE("Column[%s] is multi-value, do not ask for a single-value selector", new Object[]{spec.getDimension()});
            }
            DictionaryEncodedColumn dictionaryEncodedColumn = (DictionaryEncodedColumn)this.getCachedColumn(spec.getDimension());
            assert (dictionaryEncodedColumn != null);
            SingleValueDimensionVectorSelector selector = dictionaryEncodedColumn.makeSingleValueDimensionVectorSelector(this.offset);
            return spec.decorate(selector);
        };
        SingleValueDimensionVectorSelector selector = this.singleValueDimensionSelectorCache.get(dimensionSpec);
        if (selector == null) {
            selector = mappingFunction.apply(dimensionSpec);
            this.singleValueDimensionSelectorCache.put(dimensionSpec, selector);
        }
        return selector;
    }

    @Override
    public VectorValueSelector makeValueSelector(String columnName) {
        Function<String, VectorValueSelector> mappingFunction = name -> {
            if (this.virtualColumns.exists(columnName)) {
                VectorValueSelector selector = this.virtualColumns.makeVectorValueSelector(columnName, this.index, this.offset);
                if (selector == null) {
                    return this.virtualColumns.makeVectorValueSelector(columnName, this);
                }
                return selector;
            }
            BaseColumn column = this.getCachedColumn((String)name);
            if (column == null) {
                return NilVectorSelector.create(this.offset);
            }
            return column.makeVectorValueSelector(this.offset);
        };
        VectorValueSelector columnValueSelector = this.valueSelectorCache.get(columnName);
        if (columnValueSelector == null) {
            columnValueSelector = mappingFunction.apply(columnName);
            this.valueSelectorCache.put(columnName, columnValueSelector);
        }
        return columnValueSelector;
    }

    @Override
    public VectorObjectSelector makeObjectSelector(String columnName) {
        Function<String, VectorObjectSelector> mappingFunction = name -> {
            if (this.virtualColumns.exists(columnName)) {
                VectorObjectSelector selector = this.virtualColumns.makeVectorObjectSelector(columnName, this.index, this.offset);
                if (selector == null) {
                    return this.virtualColumns.makeVectorObjectSelector(columnName, this);
                }
                return selector;
            }
            BaseColumn column = this.getCachedColumn((String)name);
            if (column == null) {
                return NilVectorSelector.create(this.offset);
            }
            return column.makeVectorObjectSelector(this.offset);
        };
        VectorObjectSelector columnValueSelector = this.objectSelectorCache.get(columnName);
        if (columnValueSelector == null) {
            columnValueSelector = mappingFunction.apply(columnName);
            this.objectSelectorCache.put(columnName, columnValueSelector);
        }
        return columnValueSelector;
    }

    @Nullable
    private BaseColumn getCachedColumn(String columnName) {
        return this.columnCache.computeIfAbsent(columnName, name -> {
            ColumnHolder holder = this.index.getColumnHolder((String)name);
            if (holder != null) {
                return (BaseColumn)this.closer.register((Closeable)holder.getColumn());
            }
            return null;
        });
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.getColumnCapabilities(QueryableIndexStorageAdapter.getColumnInspectorForIndex(this.index), columnName);
        }
        return QueryableIndexStorageAdapter.getColumnCapabilities(this.index, columnName);
    }
}

