/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.ReadableVectorInspector;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

class ExpressionVectorInputBinding
implements Expr.VectorInputBinding {
    private final Map<String, VectorValueSelector> numeric = new HashMap<String, VectorValueSelector>();
    private final Map<String, VectorObjectSelector> objects = new HashMap<String, VectorObjectSelector>();
    private final Map<String, ExpressionType> types = new HashMap<String, ExpressionType>();
    private final NilVectorSelector nilSelector;
    private final ReadableVectorInspector vectorInspector;

    public ExpressionVectorInputBinding(ReadableVectorInspector vectorInspector) {
        this.vectorInspector = vectorInspector;
        this.nilSelector = NilVectorSelector.create(this.vectorInspector);
    }

    public ExpressionVectorInputBinding addNumeric(String name, ExpressionType type, VectorValueSelector selector) {
        this.numeric.put(name, selector);
        this.types.put(name, type);
        return this;
    }

    public ExpressionVectorInputBinding addObjectSelector(String name, ExpressionType type, VectorObjectSelector selector) {
        this.objects.put(name, selector);
        this.types.put(name, type);
        return this;
    }

    public ExpressionType getType(String name) {
        return this.types.get(name);
    }

    public <T> T[] getObjectVector(String name) {
        return this.objects.getOrDefault(name, this.nilSelector).getObjectVector();
    }

    public long[] getLongVector(String name) {
        return this.numeric.getOrDefault(name, this.nilSelector).getLongVector();
    }

    public double[] getDoubleVector(String name) {
        return this.numeric.getOrDefault(name, this.nilSelector).getDoubleVector();
    }

    @Nullable
    public boolean[] getNullVector(String name) {
        return this.numeric.getOrDefault(name, this.nilSelector).getNullVector();
    }

    public int getMaxVectorSize() {
        return this.vectorInspector.getMaxVectorSize();
    }

    public int getCurrentVectorSize() {
        return this.vectorInspector.getCurrentVectorSize();
    }

    public int getCurrentVectorId() {
        return this.vectorInspector.getId();
    }
}

