/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ListFilteredDimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdMapping;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.BitmapIndex;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.data.Indexed;

public class ListFilteredVirtualColumn
implements VirtualColumn {
    private final String name;
    private final DimensionSpec delegate;
    private final Set<String> values;
    private final boolean allowList;

    @JsonCreator
    public ListFilteredVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="values") Set<String> values, @JsonProperty(value="isAllowList") @Nullable Boolean isAllowList) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.delegate = delegate;
        this.values = values;
        this.allowList = isAllowList == null ? true : isAllowList;
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty
    public Set<String> getValues() {
        return this.values;
    }

    @JsonProperty(value="isAllowList")
    public boolean isAllowList() {
        return this.allowList;
    }

    @JsonProperty
    public DimensionSpec getDelegate() {
        return this.delegate;
    }

    public byte[] getCacheKey() {
        CacheKeyBuilder builder = new CacheKeyBuilder(2).appendString(this.name).appendCacheable((Cacheable)this.delegate).appendStringsIgnoringOrder(this.values).appendBoolean(this.allowList);
        return builder.build();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        if (this.allowList) {
            return ListFilteredDimensionSpec.filterAllowList(this.values, factory.makeDimensionSelector(this.delegate));
        }
        return ListFilteredDimensionSpec.filterDenyList(this.values, factory.makeDimensionSelector(this.delegate));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        return this.makeDimensionSelector(DefaultDimensionSpec.of(columnName), factory);
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        return new ColumnCapabilitiesImpl().setType(this.delegate.getOutputType()).setDictionaryEncoded(true).setHasBitmapIndexes(true);
    }

    @Override
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        return inspector.getColumnCapabilities(this.delegate.getDimension());
    }

    @Override
    public List<String> requiredColumns() {
        return Collections.singletonList(this.delegate.getDimension());
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    @Nullable
    public BitmapIndex getBitmapIndex(String columnName, ColumnSelector selector) {
        ColumnHolder holder = selector.getColumnHolder(this.delegate.getDimension());
        if (holder == null) {
            return null;
        }
        BitmapIndex underlyingIndex = holder.getBitmapIndex();
        if (underlyingIndex == null) {
            return null;
        }
        IdMapping idMapping = this.allowList ? ListFilteredDimensionSpec.buildAllowListIdMapping(this.values, underlyingIndex.getCardinality(), null, underlyingIndex::getValue) : ListFilteredDimensionSpec.buildDenyListIdMapping(this.values, underlyingIndex.getCardinality(), underlyingIndex::getValue);
        return new ListFilteredBitmapIndex(underlyingIndex, idMapping);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListFilteredVirtualColumn that = (ListFilteredVirtualColumn)o;
        return this.allowList == that.allowList && this.name.equals(that.name) && this.delegate.equals(that.delegate) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.delegate, this.values, this.allowList);
    }

    public String toString() {
        return "ListFilteredVirtualColumn{name='" + this.name + '\'' + ", delegate=" + this.delegate + ", values=" + this.values + ", isAllowList=" + this.allowList + '}';
    }

    private static class ListFilteredBitmapIndex
    implements BitmapIndex {
        final BitmapIndex delegate;
        final IdMapping idMapping;

        private ListFilteredBitmapIndex(BitmapIndex delegate, IdMapping idMapping) {
            this.delegate = delegate;
            this.idMapping = idMapping;
        }

        @Override
        public String getValue(int index) {
            return this.delegate.getValue(this.idMapping.getReverseId(index));
        }

        @Override
        public boolean hasNulls() {
            return this.delegate.hasNulls();
        }

        @Override
        public BitmapFactory getBitmapFactory() {
            return this.delegate.getBitmapFactory();
        }

        @Override
        public ImmutableBitmap getBitmap(int idx) {
            return this.delegate.getBitmap(this.idMapping.getReverseId(idx));
        }

        @Override
        public int getCardinality() {
            return this.idMapping.getValueCardinality();
        }

        @Override
        public int getIndex(@Nullable String value) {
            return Indexed.indexOf(this::getValue, this.getCardinality(), Comparators.naturalNullsFirst(), value);
        }
    }
}

