/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.segment.virtual.ExpressionColumnValueSelector;
import org.apache.druid.segment.virtual.ExpressionPlan;

public class RowBasedExpressionColumnValueSelector
extends ExpressionColumnValueSelector {
    private final List<String> unknownColumns;
    private final Expr.BindingAnalysis baseBindingAnalysis;
    private final Set<String> ignoredColumns;
    private final Int2ObjectMap<Expr> transformedCache;

    public RowBasedExpressionColumnValueSelector(ExpressionPlan plan, Expr.ObjectBinding bindings) {
        super(plan.getAppliedExpression(), bindings);
        this.unknownColumns = plan.getUnknownInputs().stream().filter(x -> !plan.getAnalysis().getArrayBindings().contains(x)).collect(Collectors.toList());
        this.baseBindingAnalysis = plan.getAnalysis();
        this.ignoredColumns = new HashSet<String>();
        this.transformedCache = new Int2ObjectArrayMap(this.unknownColumns.size());
    }

    @Override
    public ExprEval getObject() {
        List arrayBindings = this.unknownColumns.stream().filter(this::isBindingArray).collect(Collectors.toList());
        if (this.ignoredColumns.size() > 0) {
            this.unknownColumns.removeAll(this.ignoredColumns);
            this.ignoredColumns.clear();
        }
        if (arrayBindings.size() > 0) {
            int key = arrayBindings.hashCode();
            if (this.transformedCache.containsKey(key)) {
                return ((Expr)this.transformedCache.get(key)).eval(this.bindings);
            }
            Expr transformed = Parser.applyUnappliedBindings((Expr)this.expression, (Expr.BindingAnalysis)this.baseBindingAnalysis, arrayBindings);
            this.transformedCache.put(key, (Object)transformed);
            return transformed.eval(this.bindings);
        }
        return this.expression.eval(this.bindings);
    }

    private boolean isBindingArray(String x) {
        Object binding = this.bindings.get(x);
        if (binding != null) {
            if (binding instanceof Object[] && ((Object[])binding).length > 0) {
                return true;
            }
            if (binding instanceof Number) {
                this.ignoredColumns.add(x);
            }
        }
        return false;
    }
}

