/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.collections.CombiningIterable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.Result;
import org.junit.Assert;
import org.junit.Test;

public class CombiningIterableTest {
    @Test
    public void testMerge() {
        List<Result> resultsBefore = Arrays.asList(new Result(DateTimes.of((String)"2011-01-01"), (Object)1L), new Result(DateTimes.of((String)"2011-01-01"), (Object)2L));
        List<Result> expectedResults = Collections.singletonList(new Result(DateTimes.of((String)"2011-01-01"), (Object)3L));
        CombiningIterable resultsAfter = CombiningIterable.create(resultsBefore, Comparator.comparing(Result::getTimestamp), (arg1, arg2) -> {
            if (arg1 == null) {
                return arg2;
            }
            if (arg2 == null) {
                return arg1;
            }
            return new Result(arg1.getTimestamp(), (Object)((Long)arg1.getValue() + (Long)arg2.getValue()));
        });
        Iterator it1 = expectedResults.iterator();
        Iterator it2 = resultsAfter.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Result r1 = (Result)it1.next();
            Result r2 = (Result)it2.next();
            Assert.assertEquals((Object)r1.getTimestamp(), (Object)r2.getTimestamp());
            Assert.assertEquals((Object)r1.getValue(), (Object)r2.getValue());
        }
    }
}

