/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.testutil.FrameSequenceBuilder;
import org.apache.druid.java.util.common.ByteBufferUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.incremental.IncrementalIndexStorageAdapter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class FrameTest {
    private static byte[] frameToByteArray(Frame frame, boolean compressed) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        frame.writeTo(Channels.newChannel(baos), compressed, ByteBuffer.allocate(Frame.compressionBufferSize((long)((int)frame.numBytes()))));
        return baos.toByteArray();
    }

    public static class BadFramesTest
    extends InitializedNullHandlingTest {
        @Test
        public void testGoodFrameIsActuallyGood() throws Exception {
            Frame frame = BadFramesTest.makeGoodFrame();
            Memory compressedFrameMemory = Memory.wrap((byte[])FrameTest.frameToByteArray(frame, true));
            Assert.assertEquals((Object)frame.writableMemory(), (Object)Frame.decompress((Memory)compressedFrameMemory, (long)0L, (long)compressedFrameMemory.getCapacity()).writableMemory());
        }

        @Test
        public void testBadChecksum() throws Exception {
            Frame frame = BadFramesTest.makeGoodFrame();
            WritableMemory compressedFrameMemory = WritableMemory.writableWrap((byte[])FrameTest.frameToByteArray(frame, true));
            compressedFrameMemory.putByte(100L, (byte)0);
            IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> Frame.decompress((Memory)compressedFrameMemory, (long)0L, (long)compressedFrameMemory.getCapacity()));
            MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Checksum mismatch")));
        }

        private static Frame makeGoodFrame() {
            IncrementalIndexStorageAdapter adapter = new IncrementalIndexStorageAdapter(TestIndex.getIncrementalTestIndex());
            return (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromAdapter((StorageAdapter)adapter).frameType(FrameType.COLUMNAR).frames().toList());
        }
    }

    @RunWith(value=Parameterized.class)
    public static class WrapAndWriteTest
    extends InitializedNullHandlingTest {
        private static byte[] FRAME_DATA;
        private static byte[] FRAME_DATA_COMPRESSED;
        private final MemType memType;
        private final boolean compressed;
        private final Closer closer = Closer.create();

        public WrapAndWriteTest(MemType memType, boolean compressed) {
            this.memType = memType;
            this.compressed = compressed;
        }

        @Parameterized.Parameters(name="memType = {0}, compressed = {1}")
        public static Iterable<Object[]> constructorFeeder() {
            ArrayList<Object[]> constructors = new ArrayList<Object[]>();
            for (MemType memType : MemType.values()) {
                for (boolean compressed : new boolean[]{true, false}) {
                    constructors.add(new Object[]{memType, compressed});
                }
            }
            return constructors;
        }

        @BeforeClass
        public static void setUpClass() throws Exception {
            IncrementalIndexStorageAdapter adapter = new IncrementalIndexStorageAdapter(TestIndex.getIncrementalTestIndex());
            Frame frame = (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromAdapter((StorageAdapter)adapter).frameType(FrameType.COLUMNAR).frames().toList());
            FRAME_DATA = FrameTest.frameToByteArray(frame, false);
            FRAME_DATA_COMPRESSED = FrameTest.frameToByteArray(frame, true);
        }

        @AfterClass
        public static void tearDownClass() {
            FRAME_DATA = null;
            FRAME_DATA_COMPRESSED = null;
        }

        @After
        public void tearDown() throws IOException {
            this.closer.close();
        }

        @Test
        public void testWrapAndWrite() throws Exception {
            Frame frame = this.compressed ? this.memType.decompress(this.closer) : this.memType.wrap(this.closer);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            frame.writeTo(Channels.newChannel(baos), this.compressed, ByteBuffer.allocate(Frame.compressionBufferSize((long)((int)frame.numBytes()))));
            if (!this.compressed) {
                Assert.assertArrayEquals((byte[])FRAME_DATA, (byte[])baos.toByteArray());
            } else {
                byte[] compressedData = baos.toByteArray();
                Frame frame2 = Frame.decompress((Memory)Memory.wrap((byte[])baos.toByteArray()), (long)0L, (long)compressedData.length);
                Assert.assertArrayEquals((byte[])FRAME_DATA, (byte[])FrameTest.frameToByteArray(frame2, false));
            }
        }

        static enum MemType {
            ARRAY{

                @Override
                Frame wrap(Closer closer) {
                    return Frame.wrap((byte[])FRAME_DATA);
                }

                @Override
                Frame decompress(Closer closer) {
                    return Frame.decompress((Memory)Memory.wrap((byte[])FRAME_DATA_COMPRESSED), (long)0L, (long)FRAME_DATA_COMPRESSED.length);
                }
            }
            ,
            BB_HEAP{

                @Override
                Frame wrap(Closer closer) {
                    return Frame.wrap((ByteBuffer)ByteBuffer.wrap(FRAME_DATA));
                }

                @Override
                Frame decompress(Closer closer) {
                    return Frame.decompress((Memory)Memory.wrap((ByteBuffer)ByteBuffer.wrap(FRAME_DATA_COMPRESSED), (ByteOrder)ByteOrder.LITTLE_ENDIAN), (long)0L, (long)FRAME_DATA_COMPRESSED.length);
                }
            }
            ,
            BB_DIRECT{

                @Override
                Frame wrap(Closer closer) {
                    ByteBuffer buf = ByteBuffer.allocateDirect(FRAME_DATA.length);
                    buf.put(FRAME_DATA, 0, FRAME_DATA.length);
                    closer.register(() -> ByteBufferUtils.free((ByteBuffer)buf));
                    return Frame.wrap((ByteBuffer)buf);
                }

                @Override
                Frame decompress(Closer closer) {
                    ByteBuffer buf = ByteBuffer.allocateDirect(FRAME_DATA_COMPRESSED.length);
                    buf.put(FRAME_DATA_COMPRESSED, 0, FRAME_DATA_COMPRESSED.length);
                    closer.register(() -> ByteBufferUtils.free((ByteBuffer)buf));
                    return Frame.decompress((Memory)Memory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN), (long)0L, (long)FRAME_DATA_COMPRESSED.length);
                }
            }
            ,
            BB_MAPPED{

                @Override
                Frame wrap(Closer closer) throws IOException {
                    File file = File.createTempFile("frame-test", "");
                    closer.register(file::delete);
                    Files.write((byte[])FRAME_DATA, (File)file);
                    MappedByteBuffer buf = Files.map((File)file);
                    closer.register(() -> ByteBufferUtils.unmap((MappedByteBuffer)buf));
                    return Frame.wrap((ByteBuffer)buf);
                }

                @Override
                Frame decompress(Closer closer) throws IOException {
                    File file = File.createTempFile("frame-test", "");
                    closer.register(file::delete);
                    Files.write((byte[])FRAME_DATA_COMPRESSED, (File)file);
                    MappedByteBuffer buf = Files.map((File)file);
                    closer.register(() -> ByteBufferUtils.unmap((MappedByteBuffer)buf));
                    return Frame.decompress((Memory)Memory.wrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN), (long)0L, (long)buf.capacity());
                }
            }
            ,
            MEMORY_ARRAY{

                @Override
                Frame wrap(Closer closer) {
                    return Frame.wrap((Memory)Memory.wrap((byte[])FRAME_DATA, (ByteOrder)ByteOrder.LITTLE_ENDIAN));
                }

                @Override
                Frame decompress(Closer closer) {
                    byte[] copyFrameData = new byte[FRAME_DATA_COMPRESSED.length + 2];
                    System.arraycopy(FRAME_DATA_COMPRESSED, 0, copyFrameData, 1, FRAME_DATA_COMPRESSED.length);
                    return Frame.decompress((Memory)Memory.wrap((byte[])copyFrameData, (ByteOrder)ByteOrder.LITTLE_ENDIAN), (long)1L, (long)FRAME_DATA_COMPRESSED.length);
                }
            }
            ,
            MEMORY_BB{

                @Override
                Frame wrap(Closer closer) {
                    return Frame.wrap((Memory)Memory.wrap((ByteBuffer)ByteBuffer.wrap(FRAME_DATA), (ByteOrder)ByteOrder.LITTLE_ENDIAN));
                }

                @Override
                Frame decompress(Closer closer) {
                    byte[] copyFrameData = new byte[FRAME_DATA_COMPRESSED.length + 2];
                    System.arraycopy(FRAME_DATA_COMPRESSED, 0, copyFrameData, 1, FRAME_DATA_COMPRESSED.length);
                    return Frame.decompress((Memory)Memory.wrap((ByteBuffer)ByteBuffer.wrap(copyFrameData), (ByteOrder)ByteOrder.LITTLE_ENDIAN), (long)1L, (long)FRAME_DATA_COMPRESSED.length);
                }
            };


            abstract Frame wrap(Closer var1) throws IOException;

            abstract Frame decompress(Closer var1) throws IOException;
        }
    }

    public static class GoodFramesTest
    extends InitializedNullHandlingTest {
        private Frame columnarFrame;
        private Frame rowBasedSortedFrame;
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @Before
        public void setUp() {
            QueryableIndexStorageAdapter adapter = new QueryableIndexStorageAdapter(TestIndex.getNoRollupMMappedTestIndex());
            ImmutableList sortBy = ImmutableList.of((Object)new SortColumn("quality", true), (Object)new SortColumn("__time", false));
            this.columnarFrame = (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromAdapter((StorageAdapter)adapter).frameType(FrameType.COLUMNAR).frames().toList());
            this.rowBasedSortedFrame = (Frame)Iterables.getOnlyElement((Iterable)FrameSequenceBuilder.fromAdapter((StorageAdapter)adapter).frameType(FrameType.ROW_BASED).sortBy((List<SortColumn>)sortBy).frames().toList());
        }

        @Test
        public void test_numRows() {
            Assert.assertEquals((long)1209L, (long)this.columnarFrame.numRows());
            Assert.assertEquals((long)1209L, (long)this.rowBasedSortedFrame.numRows());
        }

        @Test
        public void test_numRegions() {
            Assert.assertEquals((long)21L, (long)this.columnarFrame.numRegions());
            Assert.assertEquals((long)2L, (long)this.rowBasedSortedFrame.numRegions());
        }

        @Test
        public void test_isPermuted() {
            Assert.assertFalse((boolean)this.columnarFrame.isPermuted());
            Assert.assertTrue((boolean)this.rowBasedSortedFrame.isPermuted());
        }

        @Test
        public void test_physicalRow_standard() {
            for (int i = 0; i < this.columnarFrame.numRows(); ++i) {
                Assert.assertEquals((long)i, (long)this.columnarFrame.physicalRow(i));
            }
        }

        @Test
        public void test_physicalRow_standard_outOfBoundsTooLow() {
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Row [-1] out of bounds");
            this.columnarFrame.physicalRow(-1);
        }

        @Test
        public void test_physicalRow_standard_outOfBoundsTooHigh() {
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Row [1,209] out of bounds");
            this.columnarFrame.physicalRow(Ints.checkedCast((long)this.columnarFrame.numRows()));
        }

        @Test
        public void test_physicalRow_sorted_outOfBoundsTooLow() {
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Row [-1] out of bounds");
            this.rowBasedSortedFrame.physicalRow(-1);
        }

        @Test
        public void test_physicalRow_sorted_outOfBoundsTooHigh() {
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("Row [1,209] out of bounds");
            this.rowBasedSortedFrame.physicalRow(Ints.checkedCast((long)this.columnarFrame.numRows()));
        }
    }
}

