/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.RowKeyComparator;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.java.util.common.guava.Comparators;
import org.junit.Assert;
import org.junit.Test;

public class ClusterByTest {
    @Test
    public void test_keyComparator() {
        ImmutableList sortColumns = ImmutableList.of((Object)new SortColumn("x", false), (Object)new SortColumn("y", false));
        Assert.assertEquals((Object)RowKeyComparator.create((List)sortColumns), (Object)new ClusterBy((List)sortColumns, 1).keyComparator());
    }

    @Test
    public void test_bucketComparator_noKey() {
        Assert.assertSame((Object)Comparators.alwaysEqual(), (Object)ClusterBy.none().bucketComparator());
    }

    @Test
    public void test_bucketComparator_noBucketKey() {
        Assert.assertSame((Object)Comparators.alwaysEqual(), (Object)new ClusterBy((List)ImmutableList.of((Object)new SortColumn("x", false), (Object)new SortColumn("y", false)), 0).bucketComparator());
    }

    @Test
    public void test_bucketComparator_withBucketKey() {
        Assert.assertEquals((Object)RowKeyComparator.create((List)ImmutableList.of((Object)new SortColumn("x", false))), (Object)new ClusterBy((List)ImmutableList.of((Object)new SortColumn("x", false), (Object)new SortColumn("y", false)), 1).bucketComparator());
    }

    @Test
    public void test_equals() {
        EqualsVerifier.forClass(ClusterBy.class).usingGetClass().verify();
    }
}

