/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.test;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;

public class SuperBlasterFrameProcessor
implements FrameProcessor<Long> {
    private final List<ReadableFrameChannel> inChannels;
    private final List<WritableFrameChannel> outChannels;
    private final AwaitStyle awaitStyle;
    private final Random rand;
    private long rowsRead = 0L;

    public SuperBlasterFrameProcessor(List<ReadableFrameChannel> inChannels, List<WritableFrameChannel> outChannels, AwaitStyle awaitStyle) {
        this.inChannels = inChannels;
        this.outChannels = outChannels;
        this.awaitStyle = awaitStyle;
        this.rand = new Random(0L);
    }

    public List<ReadableFrameChannel> inputChannels() {
        return this.inChannels;
    }

    public List<WritableFrameChannel> outputChannels() {
        return this.outChannels;
    }

    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        if (readableInputs.size() == this.inChannels.size() && this.inChannels.stream().allMatch(ReadableFrameChannel::isFinished)) {
            return ReturnOrAwait.returnObject((Object)this.rowsRead);
        }
        IntIterator intIterator = readableInputs.iterator();
        while (intIterator.hasNext()) {
            int channelNumber = (Integer)intIterator.next();
            ReadableFrameChannel inChannel = this.inChannels.get(channelNumber);
            if (inChannel.isFinished()) continue;
            Frame frame = inChannel.read();
            this.rowsRead += (long)frame.numRows();
            for (WritableFrameChannel outChannel : this.outChannels) {
                outChannel.write(frame);
            }
        }
        switch (this.awaitStyle) {
            case ALL: {
                return ReturnOrAwait.awaitAll((int)this.inChannels.size());
            }
            case ANY: {
                return ReturnOrAwait.awaitAny((IntSet)IntSets.fromTo((int)0, (int)this.inChannels.size()));
            }
            case SINGLE_ALL: {
                return ReturnOrAwait.awaitAll((IntSet)IntSets.singleton((int)this.rand.nextInt(this.inChannels.size())));
            }
            case SINGLE_ANY: {
                return ReturnOrAwait.awaitAny((IntSet)IntSets.singleton((int)this.rand.nextInt(this.inChannels.size())));
            }
            case NONE: {
                return ReturnOrAwait.runAgain();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inChannels, this.outChannels, (Closeable[])new Closeable[0]);
    }

    public static enum AwaitStyle {
        NONE,
        ALL,
        ANY,
        SINGLE_ALL,
        SINGLE_ANY;

    }
}

